/*
 * Decompiled with CFR 0.152.
 */
package gishur.core;

import gishur.core.BasicTree;
import gishur.core.Comparitor;
import gishur.core.ControlledCloneable;
import gishur.core.HashComparitor;
import gishur.core.LinkException;
import gishur.core.SimpleTreeItem;
import gishur.core.StdComparitor;
import gishur.core.StdTreeItem;
import gishur.core.TreeException;
import gishur.core.TreeItem;
import java.util.Enumeration;
import java.util.Hashtable;

public class BinarySearchTree
extends BasicTree
implements ControlledCloneable {
    private Comparitor _comparitor = null;
    private boolean _allow_duplicates = true;
    private boolean _left_is_smaller = true;

    public boolean allowDuplicates() {
        return this._allow_duplicates;
    }

    public void beforeAdd(TreeItem treeItem) {
    }

    public TreeItem add(Object object) {
        return this.add_item(this.createNew(object));
    }

    public TreeItem add(Object object, Object object2) {
        return this.add_item(this.createNew(object, object2));
    }

    public TreeItem add(TreeItem treeItem) {
        if (treeItem == null) {
            return null;
        }
        if (!treeItem.setOwningTree(null) && !(treeItem = (TreeItem)treeItem.clone(null, 1)).setOwningTree(null)) {
            throw new LinkException(1538, treeItem);
        }
        if (!treeItem.clearConnections()) {
            throw new LinkException(1539, treeItem);
        }
        if (!treeItem.setMaxRank(2)) {
            throw new TreeException(1028, treeItem);
        }
        return this.add_item(treeItem);
    }

    public TreeItem add(int n) {
        return this.add(new Integer(n));
    }

    public void beforeRemove(TreeItem treeItem) {
    }

    public TreeItem add(long l) {
        return this.add(new Long(l));
    }

    public TreeItem add(float f) {
        return this.add(new Float(f));
    }

    public TreeItem add(double d) {
        return this.add(new Double(d));
    }

    public TreeItem add(boolean bl) {
        return this.add(new Boolean(bl));
    }

    public TreeItem last(byte by) {
        return super.last(null, by);
    }

    public TreeItem last() {
        return super.last(null, (byte)3);
    }

    public void onDoubleRotation(TreeItem treeItem, TreeItem treeItem2, TreeItem treeItem3) {
    }

    public Enumeration keys() {
        return super.enumerate(null, (byte)3, true, (byte)1);
    }

    public Enumeration keys(Object object, Object object2) {
        TreeItem treeItem = this.findBigger(object);
        TreeItem treeItem2 = this.findSmaller(object2);
        if (this._left_is_smaller) {
            if (this._comparitor.compare(treeItem, treeItem2) == 1) {
                return super.emptyEnumeration();
            }
            return super.enumerate(treeItem, treeItem2, (byte)3, (byte)1);
        }
        if (this._comparitor.compare(treeItem, treeItem2) == -1) {
            return super.emptyEnumeration();
        }
        return super.enumerate(treeItem2, treeItem, (byte)3, (byte)1);
    }

    public Comparitor comparitor() {
        return this._comparitor;
    }

    public TreeItem findPath(Object object) {
        return super.find(object, null, this._comparitor, this._left_is_smaller);
    }

    public Enumeration values() {
        return super.enumerate(null, (byte)3, true, (byte)2);
    }

    public TreeItem root() {
        return super.root();
    }

    public Enumeration values(Object object, Object object2) {
        TreeItem treeItem = this.findBigger(object);
        TreeItem treeItem2 = this.findSmaller(object2);
        if (this._left_is_smaller) {
            if (this._comparitor.compare(treeItem, treeItem2) == 1) {
                return super.emptyEnumeration();
            }
            return super.enumerate(treeItem, treeItem2, (byte)3, (byte)2);
        }
        if (this._comparitor.compare(treeItem, treeItem2) == -1) {
            return super.emptyEnumeration();
        }
        return super.enumerate(treeItem2, treeItem, (byte)3, (byte)2);
    }

    public boolean leftIsSmaller() {
        return this._left_is_smaller;
    }

    public Object clone(Hashtable hashtable, int n) {
        return super.clone(hashtable, n);
    }

    public Object clone() {
        return super.clone(null, 1);
    }

    public TreeItem min(TreeItem treeItem) {
        if (treeItem == null) {
            treeItem = super.root();
        }
        if (treeItem == null) {
            return null;
        }
        if (this._left_is_smaller) {
            return super.findLast(treeItem, 0);
        }
        return super.findLast(treeItem, 1);
    }

    public TreeItem min() {
        return this.min(null);
    }

    public int length() {
        return super.length();
    }

    public int length(TreeItem treeItem) {
        if (treeItem == null) {
            return super.length();
        }
        return super.countItems(treeItem);
    }

    public synchronized TreeItem remove(TreeItem treeItem) {
        this.beforeRemove(treeItem);
        treeItem = super.removeSym(treeItem);
        this.afterRemove(treeItem);
        return treeItem;
    }

    public TreeItem remove(Object object) {
        TreeItem treeItem = super.find(object, null, this._comparitor, this._left_is_smaller);
        if (treeItem != null && treeItem.equals(object)) {
            return this.remove(treeItem);
        }
        return null;
    }

    public TreeItem findBigger(Object object, TreeItem treeItem) {
        TreeItem treeItem2 = super.find(object, treeItem, this._comparitor, this._left_is_smaller);
        short s = this._comparitor.compare(object, treeItem2);
        if (s != 1) {
            return treeItem2;
        }
        if (this._left_is_smaller) {
            return this.next(treeItem, treeItem2, (byte)3);
        }
        return this.prev(treeItem, treeItem2, (byte)3);
    }

    public TreeItem findBigger(Object object) {
        return this.findBigger(object, null);
    }

    public int height() {
        return super.height(null);
    }

    public int height(TreeItem treeItem) {
        return super.height(treeItem);
    }

    public BinarySearchTree() {
        this._comparitor = new StdComparitor();
    }

    public BinarySearchTree(Comparitor comparitor) {
        this(comparitor, true);
    }

    public BinarySearchTree(Comparitor comparitor, boolean bl) {
        this._comparitor = comparitor;
        if (this._comparitor == null) {
            this._comparitor = new HashComparitor();
        }
        this._left_is_smaller = bl;
    }

    public TreeItem max(TreeItem treeItem) {
        if (treeItem == null) {
            treeItem = super.root();
        }
        if (treeItem == null) {
            return null;
        }
        if (this._left_is_smaller) {
            return super.findLast(treeItem, 1);
        }
        return super.findLast(treeItem, 0);
    }

    public TreeItem max() {
        return this.max(null);
    }

    public void afterAdd(TreeItem treeItem) {
    }

    public TreeItem findSmaller(Object object, TreeItem treeItem) {
        TreeItem treeItem2 = super.find(object, treeItem, this._comparitor, this._left_is_smaller);
        short s = this._comparitor.compare(object, treeItem2);
        if (s != -1) {
            return treeItem2;
        }
        if (this._left_is_smaller) {
            return this.prev(treeItem, treeItem2, (byte)3);
        }
        return this.next(treeItem, treeItem2, (byte)3);
    }

    public TreeItem findSmaller(Object object) {
        return this.findSmaller(object, null);
    }

    public void setAllowDuplicates(boolean bl) {
        this._allow_duplicates = bl;
    }

    public boolean contains(TreeItem treeItem) {
        return super.contains(treeItem);
    }

    public TreeItem first(byte by) {
        return super.first(null, by);
    }

    public TreeItem first() {
        return super.first(null, (byte)3);
    }

    protected TreeItem add_item(TreeItem treeItem) {
        this.beforeAdd(treeItem);
        treeItem = super.add(treeItem, this._comparitor, this._left_is_smaller, this._allow_duplicates);
        this.afterAdd(treeItem);
        return treeItem;
    }

    public boolean requestAccess(int n, Object object, Object object2) {
        boolean bl = super.requestAccess(n, object, object2);
        if (!bl) {
            return false;
        }
        if (this._access == 1) {
            return true;
        }
        switch (n) {
            case 6: 
            case 103: {
                return false;
            }
        }
        return true;
    }

    public TreeItem next(TreeItem treeItem, byte by) {
        return super.next(null, treeItem, by);
    }

    public TreeItem next(TreeItem treeItem) {
        return super.next(null, treeItem, (byte)3);
    }

    public void afterRemove(TreeItem treeItem) {
    }

    protected synchronized TreeItem rotation(TreeItem treeItem, int n, int n2) {
        TreeItem treeItem2 = treeItem.child(n);
        if (treeItem2 == null || n == n2 || n > 1 || n2 > 1) {
            return treeItem;
        }
        TreeItem treeItem3 = super.rotation(treeItem, n, n2);
        if (n2 == 0) {
            this.onLeftRotate(treeItem, treeItem2);
        } else {
            this.onRightRotate(treeItem2, treeItem);
        }
        return treeItem3;
    }

    public boolean empty() {
        return super.empty();
    }

    public void clear() {
        this.removeTree(this.root());
    }

    public void onLeftRotate(TreeItem treeItem, TreeItem treeItem2) {
    }

    public TreeItem find(Object object, TreeItem treeItem) {
        TreeItem treeItem2 = super.find(object, treeItem, this._comparitor, this._left_is_smaller);
        if (treeItem2 != null && treeItem2.equals(object)) {
            return treeItem2;
        }
        return null;
    }

    public TreeItem find(Object object) {
        if (object instanceof TreeItem && this.contains((TreeItem)object)) {
            return (TreeItem)object;
        }
        TreeItem treeItem = super.find(object, null, this._comparitor, this._left_is_smaller);
        if (treeItem != null && treeItem.equals(object)) {
            return treeItem;
        }
        return null;
    }

    public TreeItem prev(TreeItem treeItem, byte by) {
        return super.prev(null, treeItem, by);
    }

    public TreeItem prev(TreeItem treeItem) {
        return super.prev(null, treeItem, (byte)3);
    }

    public Enumeration treeItems(Object object, Object object2) {
        TreeItem treeItem = this.findBigger(object);
        TreeItem treeItem2 = this.findSmaller(object2);
        if (this._left_is_smaller) {
            if (this._comparitor.compare(treeItem, treeItem2) == 1) {
                return super.emptyEnumeration();
            }
            return super.enumerate(treeItem, treeItem2, (byte)3, (byte)0);
        }
        if (this._comparitor.compare(treeItem, treeItem2) == -1) {
            return super.emptyEnumeration();
        }
        return super.enumerate(treeItem2, treeItem, (byte)3, (byte)0);
    }

    public void onRightRotate(TreeItem treeItem, TreeItem treeItem2) {
    }

    private TreeItem createNew(Object object) {
        return new SimpleTreeItem(2, object);
    }

    private TreeItem createNew(Object object, Object object2) {
        return new StdTreeItem(2, object, object2);
    }

    public synchronized TreeItem double_rotation(TreeItem treeItem, int n, int n2) {
        TreeItem treeItem2 = super.double_rotation(treeItem, n, n2);
        if (treeItem == null || treeItem2 == treeItem || treeItem2 == null) {
            return treeItem2;
        }
        this.onDoubleRotation(treeItem2.child(n), treeItem2.child(n2), treeItem2);
        return treeItem2;
    }
}

