/*
 * Decompiled with CFR 0.152.
 */
package gishur.core.algorithms;

import gishur.core.algorithms.TraceCursor;
import gishur.core.algorithms.TraceException;
import gishur.core.algorithms.TraceLabel;
import gishur.core.algorithms.TraceObject;
import java.util.Enumeration;
import java.util.Hashtable;

public class Tracer {
    private String _name = null;
    private Hashtable _objects = new Hashtable();
    private TraceLabel _label = null;
    private int _record_step = -1;
    private int _rec_label_count = 0;
    private int _max_level = -1;

    public TraceObject object(String string) {
        if (string == null) {
            return null;
        }
        TraceObject traceObject = (TraceObject)this._objects.get(string);
        if (traceObject != null) {
            return traceObject;
        }
        if (this._record_step < 0) {
            return null;
        }
        traceObject = new TraceObject(this, string);
        this._objects.put(string, traceObject);
        traceObject.startRecord();
        return traceObject;
    }

    synchronized int getStepNumber() {
        if (this._record_step < 0) {
            throw new TraceException(2563);
        }
        return this._record_step++;
    }

    public String toString() {
        String string = this.getClass().getName() + "[" + this._name;
        if (this._record_step >= 0) {
            return string + ",(recording)]";
        }
        String string2 = "\n ";
        TraceCursor traceCursor = this.createTraceCursor();
        traceCursor.next();
        StringBuffer stringBuffer = new StringBuffer();
        while (traceCursor.valid()) {
            stringBuffer.append(traceCursor.label().toString(string2, false));
            traceCursor.next();
        }
        if (stringBuffer.length() > 0) {
            return string + stringBuffer + "\n]";
        }
        return string + "]";
    }

    public Tracer(String string) {
        this._name = string;
    }

    public int recLabelCount() {
        return this._rec_label_count;
    }

    public TraceLabel[] getTraceLabels(int n) {
        if (this._label == null) {
            return new TraceLabel[0];
        }
        int n2 = 0;
        TraceLabel traceLabel = this._label.next(n);
        while (traceLabel != null) {
            ++n2;
            traceLabel = traceLabel.next(n);
        }
        TraceLabel[] traceLabelArray = new TraceLabel[n2];
        traceLabel = this._label.next(n);
        n2 = 0;
        while (traceLabel != null) {
            traceLabelArray[n2++] = traceLabel;
            traceLabel = traceLabel.next(n);
        }
        return traceLabelArray;
    }

    public void recordLabel(String string, int n, int n2) {
        if (this._record_step < 0) {
            throw new TraceException(2563);
        }
        TraceLabel traceLabel = new TraceLabel(this, this._record_step - 1, string, n, n2);
        this._label.prev_pr().add(traceLabel);
        ++this._rec_label_count;
        this._max_level = this._max_level > n2 ? this._max_level : n2;
    }

    public void recordLabel(String string, int n) {
        this.recordLabel(string, 0, n);
    }

    public void startRecord() {
        this._record_step = 0;
        this._rec_label_count = 0;
        this._max_level = -1;
        this._label = new TraceLabel(this, -1, "Start tracing" + (this._name != null ? " [" + this._name + "]." : "."), 0, -1);
        this._label.initFirst();
        this._objects.clear();
    }

    public void stopRecord() {
        this._record_step = -1;
        Enumeration enumeration = this._objects.elements();
        while (enumeration.hasMoreElements()) {
            ((TraceObject)enumeration.nextElement()).finishRecord();
        }
    }

    public Enumeration objects() {
        return this._objects.elements();
    }

    public int maxUsedLevel() {
        return this._max_level;
    }

    public boolean recordMode() {
        return this._record_step >= 0;
    }

    public TraceCursor createTraceCursor() {
        return new TraceCursor(this);
    }

    TraceLabel firstLabel() {
        return this._label;
    }

    TraceLabel lastLabel() {
        return this._label.prev_pr();
    }

    public TraceObject createTraceObject(String string) {
        if (string == null) {
            return null;
        }
        TraceObject traceObject = (TraceObject)this._objects.get(string);
        if (traceObject != null) {
            return traceObject;
        }
        if (this._record_step < 0) {
            throw new TraceException(2563);
        }
        traceObject = new TraceObject(this, string);
        this._objects.put(string, traceObject);
        traceObject.startRecord();
        return traceObject;
    }
}

