/*
 * Decompiled with CFR 0.152.
 */
package gishur.core.math;

class DoubleArray {
    double[][] _data;
    private int _dimX;
    private int _dimY;

    void setColumn(int n, double d, double d2, double d3) {
        this._data[0][n] = d;
        this._data[1][n] = d2;
        this._data[2][n] = d3;
    }

    boolean isColumnNull(int n) {
        boolean bl = true;
        int n2 = 0;
        while (n2 < this._dimX && bl) {
            bl = this._data[n2][n] == 0.0;
            ++n2;
        }
        return bl;
    }

    void set(int n, int n2, double d) {
        this._data[n][n2] = d;
    }

    double get(int n, int n2) {
        return this._data[n][n2];
    }

    int dimY() {
        return this._dimY;
    }

    boolean valid(int n, int n2) {
        return n >= 0 && n < this._dimX && n2 >= 0 && n2 <= this._dimY;
    }

    public DoubleArray(int n, int n2) {
        this._dimX = n;
        this._dimY = n2;
        this._data = new double[n][n2];
    }

    void setNull() {
        int n = 0;
        while (n < this._dimY) {
            int n2 = 0;
            while (n2 < this._dimX) {
                this._data[n2][n] = 0.0;
                ++n2;
            }
            ++n;
        }
    }

    public boolean equals(DoubleArray doubleArray) {
        if (this == doubleArray) {
            return true;
        }
        if (this._dimX != doubleArray._dimX || this._dimY != doubleArray._dimY) {
            return false;
        }
        boolean bl = true;
        int n = 0;
        while (n < this._dimY && bl) {
            int n2 = 0;
            while (n2 < this._dimX && bl) {
                bl = this._data[n2][n] == doubleArray._data[n2][n];
                ++n2;
            }
            ++n;
        }
        return bl;
    }

    public boolean equals(Object object) {
        if (object instanceof DoubleArray) {
            return this.equals((DoubleArray)object);
        }
        return false;
    }

    int dimX() {
        return this._dimX;
    }

    void setRowNull(int n) {
        int n2 = 0;
        while (n2 < this._dimY) {
            this._data[n][n2] = 0.0;
            ++n2;
        }
    }

    void setColumnNull(int n) {
        int n2 = 0;
        while (n2 < this._dimX) {
            this._data[n2][n] = 0.0;
            ++n2;
        }
    }

    boolean isNull() {
        boolean bl = true;
        int n = 0;
        while (n < this._dimY && bl) {
            int n2 = 0;
            while (n2 < this._dimX && bl) {
                bl = this._data[n2][n] == 0.0;
                ++n2;
            }
            ++n;
        }
        return bl;
    }

    boolean isRowNull(int n) {
        boolean bl = true;
        int n2 = 0;
        while (n2 < this._dimY && bl) {
            bl = this._data[n][n2] == 0.0;
            ++n2;
        }
        return bl;
    }

    void setRow(int n, double d, double d2) {
        this._data[n][0] = d;
        this._data[n][1] = d2;
    }

    void setRow(int n, double d, double d2, double d3) {
        this._data[n][0] = d;
        this._data[n][1] = d2;
        this._data[n][2] = d3;
    }

    void setColumn(int n, double d, double d2) {
        this._data[0][n] = d;
        this._data[1][n] = d2;
    }
}

