/*
 * Decompiled with CFR 0.152.
 */
package gishur.core.math;

import gishur.core.math.DoubleArray;

public class Vector
extends DoubleArray {
    public void set(int n, double d) {
        super.set(n, 0, d);
    }

    public double get(int n) {
        return super.get(n, 0);
    }

    public void set(double d, double d2) {
        super.setColumn(0, d, d2);
    }

    public void set(double d, double d2, double d3) {
        super.setColumn(0, d, d2, d3);
    }

    public Vector(int n) {
        super(n, 1);
    }

    public Vector(double d, double d2) {
        super(2, 1);
        this.setColumn(0, d, d2);
    }

    public Vector(double d, double d2, double d3) {
        super(3, 1);
        this.setColumn(0, d, d2, d3);
    }

    public int dim() {
        return super.dimX();
    }

    public boolean linDependend(Vector vector) {
        if (this.dim() != vector.dim()) {
            return false;
        }
        if (this.equals(vector)) {
            return true;
        }
        if (this.isNull() || vector.isNull()) {
            return false;
        }
        double d = this.get(0) / vector.get(0);
        int n = 1;
        while (n < this.dim() && d == this.get(n) / vector.get(n)) {
            ++n;
        }
        return n >= this.dim();
    }

    public boolean equals(Vector vector) {
        if (this.dimX() != vector.dimX()) {
            return false;
        }
        int n = 0;
        while (n < this.dimX() && this.get(n) == vector.get(n)) {
            ++n;
        }
        return n >= this.dimX();
    }

    public boolean isNull() {
        return this.isColumnNull(0);
    }
}

