/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.pdf.swing.impl.dynform;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.gvsig.pdf.lib.api.PDFDocument;
import org.gvsig.pdf.lib.api.PDFLocator;
import org.gvsig.pdf.lib.api.PDFManager;
import org.gvsig.pdf.swing.api.EmbeddedViewer;
import org.gvsig.pdf.swing.impl.viewer.EmbeddedViewerPDF;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynform.DynFormFieldDefinition;
import org.gvsig.tools.dynform.services.dynformfield.File.JDynFormFieldFile;
import org.gvsig.tools.dynform.spi.DynFormSPIManager;
import org.gvsig.tools.dynform.spi.dynformfield.JDynFormFieldFactory;
import org.gvsig.tools.dynobject.Tags;
import org.gvsig.tools.util.Invocable;

public class JDynFormFieldPDFFile
extends JDynFormFieldFile {
    private EmbeddedViewer viewer;
    private JComponent fileContents;

    public JDynFormFieldPDFFile(DynFormSPIManager serviceManager, DynFormSPIManager.ComponentsFactory componentsFactory, JDynFormFieldFactory factory, DynFormFieldDefinition definition, Object value) {
        super(serviceManager, componentsFactory, factory, definition, value);
    }

    public void setReadOnly(boolean readonly) {
        super.setReadOnly(readonly);
        if (this.viewer != null) {
            this.viewer.setReadOnly(readonly);
        }
    }

    public void initComponent() {
        JPanel panelButtons;
        if (this.fileContents != null) {
            return;
        }
        super.initComponent();
        this.fileContents = this.contents;
        this.viewer = new EmbeddedViewerPDF();
        this.viewer.setMessageHandler(new Invocable(){

            public Object call(Object ... os) {
                JDynFormFieldPDFFile.this.problemIndicator().set((String)os[0]);
                return true;
            }
        });
        if (this.viewer.supportShowInWindow()) {
            JButton ShowInWindowButton = this.getComponentsFactory().getJButton(this.getDefinition(), "ShowInWindow");
            ShowInWindowButton.setAction(this.viewer.createShowInWindowAction());
            panelButtons = new JPanel();
            panelButtons.setLayout(new BorderLayout(2, 0));
            panelButtons.add((Component)this.fileContents, "Center");
            panelButtons.add((Component)ShowInWindowButton, "After");
        } else {
            panelButtons = (JPanel)this.fileContents;
        }
        this.contents = new JPanel();
        this.contents.setLayout(new BorderLayout());
        this.contents.add((Component)panelButtons, "North");
        this.contents.add((Component)this.viewer.asJComponent(), "Center");
        this.setReadOnly(this.readOnly);
    }

    public void setValue(Object value) {
        super.setValue(value);
        if (this.viewer != null) {
            PDFManager pdfManager = PDFLocator.getPDFManager();
            PDFDocument pdfDocument = pdfManager.createPDFDocument();
            pdfDocument.setSource(this.getAbsoluteFile(value));
            this.viewer.put((Object)pdfDocument);
        }
    }

    public void clear() {
        super.clear();
        if (this.viewer != null) {
            this.viewer.clear();
        }
    }

    protected Object getAbsoluteFile(Object value) {
        Tags tags;
        if (!(value instanceof File)) {
            return value;
        }
        File f = (File)value;
        if (!f.isAbsolute() && (tags = this.getDefinition().getTags()).has("path")) {
            File folder = tags.get("path") instanceof File ? (File)tags.get("path") : new File(Objects.toString(tags.get("path"), null));
            File f2 = new File(folder, f.getPath());
            if (f2.exists()) {
                f = f2;
            } else {
                folder = ToolsLocator.getFoldersManager().get("Project");
                if (folder != null) {
                    f = new File(folder, f.getPath());
                }
            }
        }
        return f;
    }
}

