/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.xml2db.swing.impl.createdbfromxml;

import java.awt.Color;
import java.awt.Cursor;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.PersonalDatabaseServerExplorerFactory;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.dal.swing.ProjectionPickerController;
import org.gvsig.fmap.dal.swing.featuretype.FeatureTypePanel;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.pickercontroller.CharsetPickerController;
import org.gvsig.tools.swing.api.pickercontroller.FilePickerController;
import org.gvsig.tools.swing.api.pickercontroller.PickerController;
import org.gvsig.tools.swing.api.task.TaskStatusController;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.util.LabeledValue;
import org.gvsig.tools.util.LabeledValueImpl;
import org.gvsig.xml2db.lib.api.Xml2dbLocator;
import org.gvsig.xml2db.lib.api.Xml2dbManager;
import org.gvsig.xml2db.lib.api.xmlinfo.XMLInfo;
import org.gvsig.xml2db.lib.api.xmlinfo.XMLTableInfo;
import org.gvsig.xml2db.swing.Xml2dbPanel;
import org.gvsig.xml2db.swing.impl.Task;
import org.gvsig.xml2db.swing.impl.Xml2dbSwingCommons;
import org.gvsig.xml2db.swing.impl.createdbfromxml.CreatedbFromXmlPanelView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreatedbFromXmlPanel
extends CreatedbFromXmlPanelView
implements Xml2dbPanel {
    protected static final Logger LOGGER = LoggerFactory.getLogger(CreatedbFromXmlPanel.class);
    private static final int MODE_NEW = 0;
    private static final int MODE_OVERWRITE = 1;
    private static final int MODE_ADD = 2;
    private PickerController<Locale> pickerLocale;
    private Dialog dialog;
    private FilePickerController pickerXMLFile;
    private FilePickerController pickerDbfile;
    private ProjectionPickerController pickerProjection;
    private CharsetPickerController pickerCharset;
    private TaskStatusController taskStatusController;
    private Task lastTask;
    private XMLInfo xmlinfo;

    public CreatedbFromXmlPanel() {
        this.createComponents();
    }

    private void createComponents() {
        this.lastTask = Task.FAKE_TASK;
        this.xmlinfo = null;
        this.initComponents();
    }

    private void initComponents() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        DataSwingManager dataSwingManager = DALSwingLocator.getDataSwingManager();
        this.taskStatusController = ToolsSwingLocator.getTaskStatusSwingManager().createTaskStatusController(this.lblStatusCaption, this.lblStatusMsg, this.pbStatus);
        this.taskStatusController.setVisible(false);
        this.translate();
        this.setTablesModel(null);
        this.pickerXMLFile = toolsSwingManager.createFilePickerController((JTextComponent)this.txtXMLFile, this.btnXMLFile, null, "Xml2db_xmlFile", null, true);
        this.pickerXMLFile.addChangeListener(e -> this.doChangeXMLfile());
        this.pickerCharset = toolsSwingManager.createCharsetPickerController(null, this.cboCharset);
        this.pickerProjection = dataSwingManager.createProjectionPickerController(this.txtProjection, this.btnProjection);
        this.pickerProjection.addChangeListener(e -> this.setTablesModel(null));
        this.txtPrefixesForTables.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                CreatedbFromXmlPanel.this.setTablesModel(null);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CreatedbFromXmlPanel.this.setTablesModel(null);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                CreatedbFromXmlPanel.this.setTablesModel(null);
            }
        });
        this.cboDatabaseType.setModel(Xml2dbSwingCommons.getPersonalDatabaseServerExplorersComboModel());
        this.pickerDbfile = toolsSwingManager.createFilePickerController((JTextComponent)this.txtDatabaseFile, this.btnDataBaseFile);
        this.pickerDbfile.addChangeListener(e -> this.doChangeDBfile());
        this.btnAnalizeXML.addActionListener(e -> this.doAnalizeXML());
        this.btnAnalizeXML.setCursor(new Cursor(12));
        this.btnViewTableStructure.addActionListener(e -> this.doViewTableStructure());
        this.btnViewTableStructure.setCursor(new Cursor(12));
        this.pickerCharset.set((Object)Charset.defaultCharset());
        this.chkRegisterConnection.setSelected(true);
        this.cboMode.addItemListener(e -> {
            if (this.getMode() == 2) {
                this.chkRegisterConnection.setSelected(false);
            }
            this.updateStateComponents();
        });
        I18nManager i18n = ToolsLocator.getI18nManager();
        DefaultComboBoxModel<LabeledValueImpl> model = new DefaultComboBoxModel<LabeledValueImpl>();
        model.addElement(new LabeledValueImpl(i18n.getTranslation("_New_database"), (Object)0));
        model.addElement(new LabeledValueImpl(i18n.getTranslation("_Overwrite_database"), (Object)1));
        model.addElement(new LabeledValueImpl(i18n.getTranslation("_Add_to_existing_database"), (Object)2));
        this.cboMode.setModel(model);
        this.cboMode.setSelectedIndex(0);
        this.cboCharset.setSelectedIndex(-1);
        this.pickerLocale = toolsSwingManager.createLocalePickerController(this.cboLocale);
        this.pickerLocale.set((Object)Locale.getDefault());
        this.pickerLocale.addChangeListener(e -> this.setTablesModel(null));
        toolsSwingManager.addClearButton((JTextComponent)this.txtPrefixesForTables);
        SwingUtilities.invokeLater(() -> this.updateStateComponents());
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)5, (int)80, (int)6, (int)100);
    }

    private void translate() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        toolsSwingManager.translate(this.lblCharset);
        toolsSwingManager.translate(this.lblRepositoryName);
        toolsSwingManager.translate((JComponent)this.lblCreatedb);
        toolsSwingManager.translate(this.lblFileXML);
        toolsSwingManager.translate(this.lblDatabaseFile);
        toolsSwingManager.translate(this.lblProjection);
        toolsSwingManager.translate((JComponent)this.lblTables);
        toolsSwingManager.translate((AbstractButton)this.btnAnalizeXML);
        toolsSwingManager.translate((AbstractButton)this.btnViewTableStructure);
        toolsSwingManager.translate(this.lblRegisterConnection);
        toolsSwingManager.translate(this.lblMode);
        toolsSwingManager.translate(this.lblLocale);
        toolsSwingManager.translate(this.lblPrefixesForTables);
        toolsSwingManager.translate(this.lblDatabaseType);
    }

    private boolean isProcessing() {
        return this.lastTask.isProcessing();
    }

    private void updateStateComponents() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(this::updateStateComponents);
            return;
        }
        this.message(null);
        if (this.isProcessing()) {
            this.pickerXMLFile.setEnabled(false);
            this.pickerCharset.setEnabled(false);
            this.pickerProjection.setEnabled(false);
            this.btnAnalizeXML.setEnabled(false);
            this.lstTables.setEnabled(false);
            this.btnViewTableStructure.setEnabled(false);
            if (this.dialog != null) {
                this.dialog.setButtonEnabled(1, false);
            }
            return;
        }
        PersonalDatabaseServerExplorerFactory explorerFactory = this.getExplorerFactory();
        this.pickerXMLFile.setEnabled(true);
        this.pickerCharset.setEnabled(true);
        this.pickerProjection.setEnabled(true);
        I18nManager i18n = ToolsLocator.getI18nManager();
        File xmlfile = (File)this.pickerXMLFile.get();
        if (xmlfile == null || !xmlfile.exists()) {
            if (xmlfile == null) {
                this.message(i18n.getTranslation("_XML_file_is_required"), 2);
            } else {
                this.message(i18n.getTranslation("_XML_file_not_exists"), 2);
            }
            this.btnAnalizeXML.setEnabled(false);
            this.lstTables.setEnabled(false);
            this.btnViewTableStructure.setEnabled(false);
            if (this.dialog != null) {
                this.dialog.setButtonEnabled(1, false);
            }
            return;
        }
        this.btnAnalizeXML.setEnabled(true);
        if (this.lstTables.getModel().getSize() < 1) {
            if (this.xmlinfo == null) {
                this.message(i18n.getTranslation("_Analize_XML_required"), 2);
            } else {
                this.message(i18n.getTranslation("_No_tables_recognized_in_the_XML"), 2);
            }
            this.btnViewTableStructure.setEnabled(false);
            if (this.dialog != null) {
                this.dialog.setButtonEnabled(1, false);
            }
            return;
        }
        if (this.xmlinfo != null && this.xmlinfo.hasGeometries() && this.pickerProjection.get() == null) {
            this.message(i18n.getTranslation("_Projection_is_required"), 2);
            if (this.dialog != null) {
                this.dialog.setButtonEnabled(1, false);
            }
            return;
        }
        this.lstTables.setEnabled(true);
        this.btnViewTableStructure.setEnabled(true);
        File dbfile = (File)this.pickerDbfile.get();
        if (dbfile == null) {
            this.message(i18n.getTranslation("_Database_file_is_required"), 2);
            if (this.dialog != null) {
                this.dialog.setButtonEnabled(1, false);
            }
            return;
        }
        if (explorerFactory.existsdb(dbfile) && this.getMode() == 0) {
            this.message(i18n.getTranslation("_Database_file_already_exists"), 2);
            if (this.dialog != null) {
                this.dialog.setButtonEnabled(1, false);
            }
            return;
        }
        if (StringUtils.isBlank((CharSequence)this.txtRepositoryName.getText())) {
            this.message(i18n.getTranslation("_Repository_name_is_required"), 2);
            if (this.dialog != null) {
                this.dialog.setButtonEnabled(1, false);
            }
            return;
        }
        if (this.dialog != null) {
            this.dialog.setButtonEnabled(1, true);
        }
        this.taskStatusController.setVisible(this.lastTask.needToShowTheStatus());
    }

    public void setDialog(Dialog dialog) {
        this.dialog = dialog;
    }

    public JComponent asJComponent() {
        return this;
    }

    public void performAction() {
        this.doCreatedb();
    }

    private void doCreatedb() {
        if (this.xmlinfo == null) {
            return;
        }
        final File dbfile = (File)this.pickerDbfile.get();
        if (dbfile == null || dbfile.exists()) {
            return;
        }
        String s = this.txtRepositoryName.getText();
        if (StringUtils.isBlank((CharSequence)s)) {
            s = FilenameUtils.getBaseName((String)dbfile.getName());
        }
        final String repoName = s;
        final boolean registerConnection = this.chkRegisterConnection.isSelected();
        final PersonalDatabaseServerExplorerFactory explorerFactory = this.getExplorerFactory();
        final Xml2dbManager manager = Xml2dbLocator.getXml2dbManager();
        final I18nManager i18n = ToolsLocator.getI18nManager();
        switch (this.getMode()) {
            default: {
                if (!explorerFactory.existsdb(dbfile)) break;
                this.message(i18n.getTranslation("Database already exists"), 2);
                return;
            }
            case 1: {
                break;
            }
            case 2: {
                if (explorerFactory.existsdb(dbfile)) break;
                this.message(i18n.getTranslation("Database not exists"), 2);
                return;
            }
        }
        this.lastTask = new Task("Xml2db_Creating_database", i18n.getTranslation("_Create_database"), this::updateStateComponents, this.taskStatusController){

            @Override
            protected void task(SimpleTaskStatus taskStatus) throws Throwable {
                try {
                    JDBCServerExplorerParameters params;
                    switch (CreatedbFromXmlPanel.this.getMode()) {
                        default: {
                            if (explorerFactory.existsdb(dbfile)) {
                                CreatedbFromXmlPanel.this.message(i18n.getTranslation("Database already exists"), 2);
                                return;
                            }
                            params = manager.createDatabase(explorerFactory.getName(), dbfile, CreatedbFromXmlPanel.this.xmlinfo, taskStatus);
                            break;
                        }
                        case 1: {
                            if (explorerFactory.existsdb(dbfile)) {
                                taskStatus.message(i18n.getTranslation("_Removing_existing_database"));
                                explorerFactory.serverStop();
                                explorerFactory.removedb(dbfile);
                                explorerFactory.serverStart(new Object[0]);
                            }
                            params = manager.createDatabase(explorerFactory.getName(), dbfile, CreatedbFromXmlPanel.this.xmlinfo, taskStatus);
                            break;
                        }
                        case 2: {
                            params = manager.addToDatabase(explorerFactory.getName(), dbfile, CreatedbFromXmlPanel.this.xmlinfo, taskStatus);
                        }
                    }
                    if (params == null) {
                        throw new RuntimeException("Can't create database");
                    }
                    if (registerConnection) {
                        CreatedbFromXmlPanel.this.addToConnectionPool(params, repoName);
                    }
                }
                catch (Exception ex) {
                    LOGGER.warn("Can't create database", (Throwable)ex);
                    throw ex;
                }
            }

            @Override
            protected void postTask() {
                CreatedbFromXmlPanel.this.message(null);
            }
        };
        this.lastTask.start();
    }

    public void addToConnectionPool(JDBCServerExplorerParameters params, String id) {
        DataManager dataManager = DALLocator.getDataManager();
        dataManager.getDataServerExplorerPool().add(id, (DataServerExplorerParameters)params);
    }

    private void doAnalizeXML() {
        final Xml2dbManager manager = Xml2dbLocator.getXml2dbManager();
        final File xmlfile = (File)this.pickerXMLFile.get();
        if (xmlfile == null || !xmlfile.exists()) {
            return;
        }
        final IProjection proj = (IProjection)this.pickerProjection.get();
        final Charset charset = (Charset)this.pickerCharset.get();
        final Locale locale = (Locale)this.pickerLocale.get();
        final String tablesPrefix = (String)StringUtils.defaultIfBlank((CharSequence)this.txtPrefixesForTables.getText(), null);
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.lastTask = new Task("Xml2db_AnalizeXML", i18n.getTranslation("_Analize_xml"), this::updateStateComponents, this.taskStatusController){

            @Override
            protected void task(SimpleTaskStatus taskStatus) throws Throwable {
                try {
                    XMLInfo xmlinfo = manager.extractStructure(xmlfile, charset, proj, locale, tablesPrefix, taskStatus);
                    if (proj == null && xmlinfo.getSrid() != null) {
                        CreatedbFromXmlPanel.this.pickerProjection.set((Object)xmlinfo.getSrid());
                    }
                    if (xmlinfo.getCharset() != null && charset == null) {
                        CreatedbFromXmlPanel.this.pickerCharset.set((Object)xmlinfo.getCharset());
                    }
                    CreatedbFromXmlPanel.this.setTablesModel(xmlinfo);
                }
                catch (Throwable ex) {
                    LOGGER.warn("Can't analize xml", ex);
                    CreatedbFromXmlPanel.this.setTablesModel(null);
                    I18nManager i18n = ToolsLocator.getI18nManager();
                    ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
                    dialogs.messageDialog(i18n.getTranslation("_Problems_processing_XML_file") + "\n\n" + ex.getLocalizedMessage(), i18n.getTranslation("_Xml2db_Create_database_from_xml"), 2);
                    throw ex;
                }
            }
        };
        this.lastTask.start();
    }

    private void setTablesModel(XMLInfo xmlinfo) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.setTablesModel(xmlinfo));
            return;
        }
        this.xmlinfo = xmlinfo;
        if (xmlinfo == null) {
            this.lstTables.setModel(new XMLInfoListModel());
            return;
        }
        this.lstTables.setModel(new XMLInfoListModel(xmlinfo));
    }

    private void doViewTableStructure() {
        LabeledValue x = (LabeledValue)this.lstTables.getSelectedValue();
        if (x == null) {
            return;
        }
        DataSwingManager dataSwingManager = DALSwingLocator.getDataSwingManager();
        WindowManager_v2 windowManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        XMLTableInfo tableInfo = (XMLTableInfo)x.getValue();
        EditableFeatureType featureType = tableInfo.getFeatureType();
        FeatureTypePanel panel = dataSwingManager.createFeatureTypePanel();
        panel.setMode(1);
        panel.put((FeatureType)featureType);
        Dialog theDialog = windowManager.createDialog(panel.asJComponent(), ToolsSwingUtils.makeTitle((String)"_Xml2db_Column_manager", (String)tableInfo.getName(), (String)featureType.getLabel()), null, 3);
        theDialog.addActionListener(e -> {
            if (theDialog.getAction() == 1) {
                panel.fetch(((XMLTableInfo)x.getValue()).getFeatureType());
            }
        });
        theDialog.show(WindowManager.MODE.WINDOW, Collections.singletonMap("align", 10));
    }

    private void doChangeXMLfile() {
        File dbfile;
        File xmlfile = (File)this.pickerXMLFile.get();
        if (xmlfile != null && (dbfile = (File)this.pickerDbfile.get()) == null) {
            dbfile = new File(FilenameUtils.removeExtension((String)xmlfile.getAbsolutePath()));
            this.pickerDbfile.set((Object)dbfile);
            this.txtRepositoryName.setText(FilenameUtils.getBaseName((String)xmlfile.getName()));
        }
        this.updateStateComponents();
    }

    private void doChangeDBfile() {
        String repoName;
        File dbfile = (File)this.pickerDbfile.get();
        if (dbfile != null && StringUtils.isBlank((CharSequence)(repoName = this.txtRepositoryName.getText()))) {
            this.txtRepositoryName.setText(FilenameUtils.getBaseName((String)dbfile.getName()));
        }
        this.updateStateComponents();
    }

    private void message(String msg) {
        this.message(msg, 1);
    }

    private void message(String msg, int type) {
        if (StringUtils.isBlank((CharSequence)msg)) {
            this.lblStatusMsg.setText("");
            return;
        }
        if (type == 2) {
            msg = Xml2dbSwingCommons.getHTMLColorTag(Color.RED.darker(), msg);
        }
        this.lblStatusMsg.setText(msg);
        this.lblStatusMsg.setVisible(true);
    }

    private int getMode() {
        LabeledValue item = (LabeledValue)this.cboMode.getSelectedItem();
        if (item == null) {
            return 0;
        }
        return (Integer)item.getValue();
    }

    private PersonalDatabaseServerExplorerFactory getExplorerFactory() {
        LabeledValue item = (LabeledValue)this.cboDatabaseType.getSelectedItem();
        if (item == null) {
            return null;
        }
        return (PersonalDatabaseServerExplorerFactory)item.getValue();
    }

    private static class XMLInfoListModel
    extends AbstractListModel<LabeledValue<XMLTableInfo>> {
        private final XMLInfo xmlinfo;
        private final List<LabeledValue<XMLTableInfo>> tables;

        public XMLInfoListModel() {
            this(null);
        }

        public XMLInfoListModel(XMLInfo xmlinfo) {
            this.xmlinfo = xmlinfo;
            if (xmlinfo != null) {
                this.tables = new ArrayList<LabeledValue<XMLTableInfo>>(xmlinfo.size());
                for (XMLTableInfo tableInfo : xmlinfo) {
                    this.tables.add((LabeledValue<XMLTableInfo>)new LabeledValueImpl(xmlinfo.getNameWithPrefix(tableInfo.getName()), (Object)tableInfo));
                }
            } else {
                this.tables = null;
            }
        }

        @Override
        public LabeledValue<XMLTableInfo> getElementAt(int index) {
            if (this.tables == null) {
                return null;
            }
            return this.tables.get(index);
        }

        @Override
        public int getSize() {
            if (this.tables == null) {
                return 0;
            }
            return this.tables.size();
        }
    }
}

