/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.impl;

import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.gvsig.export.ExportException;
import org.gvsig.export.ExportLocator;
import org.gvsig.export.ExportParameters;
import org.gvsig.export.ExportParametersGeometry;
import org.gvsig.export.ExportProcess;
import org.gvsig.export.spi.ExportService;
import org.gvsig.export.spi.ExportServiceFactory;
import org.gvsig.export.spi.ExportServiceManager;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.fmap.dal.OpenDataStoreParameters;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.TaskStatus;

public class DefaultExportProcess
implements ExportProcess {
    private ExportServiceFactory factory;
    private List<OpenDataStoreParameters> targetOpenStoreParameters;
    private ExportParameters parameters;
    private FeatureStore sourceFeatureStore;
    private IProjection contextProjection;
    private ICoordTrans sourceTransformation;
    private IProjection sourceProjection;
    private Object context;
    private Expression filterExpression;
    private int featuresToUse;
    private SimpleTaskStatus taskStatus;
    private FeatureQuery featureQuery;

    public void setOutputFormat(String serviceName) throws ExportException {
        ExportServiceManager serviceManager = ExportLocator.getServiceManager();
        this.factory = serviceManager.getServiceFactory(serviceName);
        this.parameters = this.factory.createParameters();
        this.parameters.setFeatureQuery(this.featureQuery);
        this.parameters.setSourceFeatureStore(this.sourceFeatureStore);
        this.parameters.setFeaturesToUse(this.featuresToUse);
        if (this.parameters instanceof ExportParametersGeometry) {
            ExportParametersGeometry params = (ExportParametersGeometry)this.parameters;
            params.setContextProjection(this.contextProjection);
            params.setSourceProjection(this.sourceProjection);
            params.setSourceTransformation(this.sourceTransformation);
            params.setTargetProjection(this.contextProjection);
            params.setContext(this.context);
            if (this.sourceFeatureStore != null) {
                try {
                    FeatureType ftype = this.sourceFeatureStore.getDefaultFeatureType();
                    if (ftype != null) {
                        params.setSourceGeometryFieldName(ftype.getDefaultGeometryAttributeName());
                    }
                }
                catch (DataException dataException) {
                    // empty catch block
                }
            }
        }
        this.setFilterExpression(this.filterExpression);
    }

    public void setParameters(ExportParameters params) {
        this.parameters = params;
        this.factory = this.parameters.getFactory();
        this.parameters.setSourceFeatureStore(this.sourceFeatureStore);
        this.parameters.setContext(this.context);
        this.featuresToUse = this.parameters.getFeaturesToUse();
        if (ExpressionUtils.isEmpty((Expression)this.filterExpression)) {
            this.filterExpression = this.parameters.getFilterExpresion();
        } else if (!Objects.equals(this.filterExpression, this.parameters.getFilterExpresion())) {
            StringBuilder message = new StringBuilder();
            message.append(ToolsLocator.getI18nManager().getTranslation("_A_filter_is_already_applied_to_this_export_process"));
            message.append(":\n");
            message.append(StringUtils.abbreviate((String)this.filterExpression.getPhrase(), (int)30));
            message.append("\n");
            message.append(ToolsLocator.getI18nManager().getTranslation("_Its_going_to_be_replace_by_the_filter_in_the_parameters"));
            message.append(":\n");
            if (this.parameters.getFilterExpresion() != null) {
                message.append(StringUtils.abbreviate((String)this.parameters.getFilterExpresion().getPhrase(), (int)30));
            } else {
                message.append("empty filter");
            }
            message.append("\n");
            message.append(ToolsLocator.getI18nManager().getTranslation("_Do_you_want_to_keep_the_applied_filter"));
            int keepFilter = ToolsSwingLocator.getThreadSafeDialogsManager().confirmDialog(message.toString(), ToolsLocator.getI18nManager().getTranslation("_Filter_to_apply"), 0, 2, "exporto-overwrite-expression-parameters");
            if (keepFilter == 0) {
                this.parameters.setFilterExpresion(this.filterExpression);
            }
        }
        if (this.parameters instanceof ExportParametersGeometry) {
            ExportParametersGeometry pa = (ExportParametersGeometry)this.parameters;
            this.contextProjection = pa.getContextProjection();
            this.sourceProjection = pa.getSourceProjection();
            this.sourceTransformation = pa.getSourceTransformation();
        }
    }

    public void setSourceFeatureStore(FeatureStore store) {
        this.sourceFeatureStore = store;
        if (this.parameters != null) {
            this.parameters.setSourceFeatureStore(this.sourceFeatureStore);
        }
    }

    public void setContextProjection(IProjection projection) {
        this.contextProjection = projection;
        if (this.parameters instanceof ExportParametersGeometry) {
            ((ExportParametersGeometry)this.parameters).setContextProjection(projection);
        }
    }

    public void setSourceTransformation(ICoordTrans transformation) {
        this.sourceTransformation = transformation;
        if (this.parameters instanceof ExportParametersGeometry) {
            ((ExportParametersGeometry)this.parameters).setSourceTransformation(transformation);
        }
    }

    public void setSourceProjection(IProjection projection) {
        this.sourceProjection = projection;
        if (this.parameters instanceof ExportParametersGeometry) {
            ((ExportParametersGeometry)this.parameters).setSourceProjection(projection);
        }
    }

    public Object getContext() {
        return this.context;
    }

    public void setContext(Object context) {
        this.context = context;
        if (this.parameters != null) {
            this.parameters.setContext(context);
        }
    }

    public ExportParameters getParameters() {
        return this.parameters;
    }

    public TaskStatus getTaskStatus() {
        if (this.taskStatus == null) {
            this.taskStatus = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("Export");
        }
        return this.taskStatus;
    }

    public void run() {
        if (this.factory == null) {
            throw new IllegalStateException("Can't start export process, need setting output format.");
        }
        if (this.parameters == null) {
            throw new IllegalStateException("Can't start export process, need setting parameters.");
        }
        try {
            FeatureSelection featureSet;
            FeatureQuery exportFeatureQuery;
            if (this.featureQuery != null) {
                exportFeatureQuery = this.featureQuery.getCopy();
                exportFeatureQuery.clearFilter();
                exportFeatureQuery.retrievesAllAttributes();
            } else {
                exportFeatureQuery = null;
            }
            switch (this.parameters.getFeaturesToUse()) {
                default: {
                    featureSet = this.parameters.getSourceFeatureStore().getFeatureSet(exportFeatureQuery);
                    break;
                }
                case 1: {
                    featureSet = this.parameters.getSourceFeatureStore().getFeatureSelection();
                    break;
                }
                case 2: {
                    if (exportFeatureQuery != null) {
                        exportFeatureQuery.setFilter(this.parameters.getFeatureQuery().getExpressionFilter());
                    } else {
                        exportFeatureQuery = this.parameters.getFeatureQuery();
                    }
                    if (exportFeatureQuery != null) {
                        exportFeatureQuery.retrievesAllAttributes();
                        featureSet = this.parameters.getSourceFeatureStore().getFeatureSet(exportFeatureQuery);
                        break;
                    }
                    featureSet = this.parameters.getFilterExpresion().isEmpty() ? this.parameters.getSourceFeatureStore().getFeatureSet() : this.parameters.getSourceFeatureStore().getFeatureSet(this.parameters.getFilterExpresion());
                }
            }
            ExportService service = this.factory.createService(this.parameters);
            this.parameters.resetVolatileValues();
            service.setTaskStatus(this.taskStatus);
            service.export((FeatureSet)featureSet);
            this.targetOpenStoreParameters = service.getTargetOpenStoreParameters();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public List<OpenDataStoreParameters> getTargetOpenStoreParameters() {
        return this.targetOpenStoreParameters;
    }

    public void setFilterExpression(Expression expression) {
        block7: {
            this.filterExpression = expression;
            if (this.parameters != null) {
                this.parameters.setFilterExpresion(expression);
            }
            if (expression == null) {
                if (this.sourceFeatureStore != null) {
                    try {
                        FeatureSelection selection = this.sourceFeatureStore.getFeatureSelection();
                        if (selection != null && selection.size() > 0) {
                            this.setFeaturesToUse(1);
                            break block7;
                        }
                        this.setFeaturesToUse(0);
                    }
                    catch (DataException ex) {
                        this.setFeaturesToUse(0);
                    }
                }
            } else {
                this.setFeaturesToUse(2);
            }
        }
    }

    public void setFeaturesToUse(int featuresToUse) {
        this.featuresToUse = featuresToUse;
        if (this.parameters != null) {
            this.parameters.setFeaturesToUse(featuresToUse);
        }
    }

    public void setFeatureQuery(FeatureQuery featureQuery) {
        this.featureQuery = featureQuery == null ? null : featureQuery.getCopy();
    }
}

