/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.impl.service;

import org.gvsig.export.ExportAttributes;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.namestranslator.NamesTranslator;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class DefaultExportAttribute
implements ExportAttributes.ExportAttribute {
    private FeatureAttributeDescriptor fad;
    private int newDataType;
    private int size;
    private boolean exported;
    private boolean computed;
    private NamesTranslator translator;
    private boolean fromQuery;

    public DefaultExportAttribute(FeatureAttributeDescriptor fad, NamesTranslator namesTranslator, boolean fromQuery) {
        this.fad = fad;
        this.translator = namesTranslator;
        this.computed = this.fad.isComputed();
        this.fromQuery = fromQuery;
    }

    public DefaultExportAttribute() {
    }

    public FeatureAttributeDescriptor getDescriptor() {
        return this.fad;
    }

    public String getName() {
        return this.fad.getName();
    }

    public int getDataType() {
        return this.fad.getDataType().getType();
    }

    public String getNewName() {
        if (this.translator == null) {
            return this.getName();
        }
        return this.translator.getTranslation(this.getName());
    }

    public int getNewDataType() {
        return this.newDataType;
    }

    public boolean isExported() {
        return this.exported;
    }

    public boolean isComputed() {
        return this.computed;
    }

    public int setNewName(String newName) {
        if (this.translator == null) {
            return -1;
        }
        int indexChanged = this.translator.setTranslation(this.getName(), newName);
        return indexChanged;
    }

    public void setExported(boolean exported) {
        this.exported = exported;
    }

    public void setComputed(boolean computed) {
        this.computed = computed;
    }

    public void setNewType(int dataType) {
        this.newDataType = dataType;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public ExportAttributes.ExportAttribute clone() throws CloneNotSupportedException {
        DefaultExportAttribute clone = (DefaultExportAttribute)super.clone();
        clone.fad = (FeatureAttributeDescriptor)this.fad.clone();
        return clone;
    }

    public static void registerPersistence() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition("ExportAttribute") == null) {
            DynStruct definition = manager.addDefinition(DefaultExportAttribute.class, "ExportAttribute", "ExportAttribute persistence definition", null, null);
            definition.addDynFieldObject("fad").setClassOfValue(FeatureAttributeDescriptor.class);
            definition.addDynFieldInt("newDataType").setMandatory(false);
            definition.addDynFieldInt("size").setMandatory(false);
            definition.addDynFieldBoolean("exported").setMandatory(false);
            definition.addDynFieldBoolean("calculated").setMandatory(false);
        }
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("fad", (Persistent)this.fad);
        state.set("newDataType", this.newDataType);
        state.set("size", this.size);
        state.set("exported", this.exported);
        state.set("calculated", this.computed);
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        FeatureAttributeDescriptor stateFad;
        this.fad = stateFad = (FeatureAttributeDescriptor)state.get("fad");
        this.newDataType = state.getInt("newDataType");
        this.size = state.getInt("size");
        this.exported = state.getBoolean("exported");
        this.computed = state.getBoolean("calculated");
    }

    public boolean isFromQuery() {
        return this.fromQuery;
    }
}

