/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.impl.service;

import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.gvsig.export.ExportLocator;
import org.gvsig.export.ExportParametersGeometry;
import org.gvsig.export.spi.ExportGeometryHelper;
import org.gvsig.export.spi.ExportServiceManager;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.geom.Geometry;

public class DefaultExportGeometryHelper
implements ExportGeometryHelper {
    private final int targetGeometryIndex;
    private final int sourceGeometryIndex;
    private final ICoordTrans coord_trans;
    private boolean isExtraColumn;
    private String sourceGeometryName;
    private final ExportServiceManager serviceManager = ExportLocator.getServiceManager();
    private final ExportParametersGeometry parameters;
    private String lastErrorMessage;

    public DefaultExportGeometryHelper(ExportParametersGeometry parameters, FeatureType theTargetFeatureType, FeatureType theSourceFeatureType) {
        FeatureAttributeDescriptor targetGeomAtt;
        this.parameters = parameters;
        FeatureAttributeDescriptor sourceGeomAtt = theSourceFeatureType.getDefaultGeometryAttribute();
        this.isExtraColumn = false;
        String sourceGeometryFieldName = this.parameters.getSourceGeometryFieldName();
        if (!StringUtils.isEmpty((CharSequence)sourceGeometryFieldName) && (sourceGeomAtt = theSourceFeatureType.getAttributeDescriptor(sourceGeometryFieldName)) == null) {
            sourceGeomAtt = theSourceFeatureType.getExtraColumns().get(sourceGeometryFieldName);
            boolean bl = this.isExtraColumn = sourceGeomAtt != null;
        }
        if (sourceGeomAtt == null) {
            this.targetGeometryIndex = -1;
            this.sourceGeometryIndex = -1;
            this.coord_trans = null;
            return;
        }
        switch (this.getGeometryColumnCount(theTargetFeatureType)) {
            case 0: {
                this.targetGeometryIndex = -1;
                this.sourceGeometryIndex = -1;
                this.coord_trans = null;
                return;
            }
            case 1: {
                targetGeomAtt = theTargetFeatureType.getDefaultGeometryAttribute();
                break;
            }
            default: {
                targetGeomAtt = theTargetFeatureType.getAttributeDescriptor(sourceGeomAtt.getName());
                if (targetGeomAtt != null && targetGeomAtt.getType() == 66 || (targetGeomAtt = theTargetFeatureType.getDefaultGeometryAttribute()) != null || (targetGeomAtt = this.getFirstGeometryColumn(theTargetFeatureType)) != null) break;
                this.targetGeometryIndex = -1;
                this.sourceGeometryIndex = -1;
                this.coord_trans = null;
                return;
            }
        }
        IProjection targetProjection = this.parameters.getTargetProjection();
        IProjection sourceProjection = sourceGeomAtt.getSRS();
        if (targetProjection == null) {
            targetProjection = sourceProjection;
        }
        this.coord_trans = sourceProjection != null && targetProjection != null && sourceProjection != targetProjection ? sourceProjection.getCT(targetProjection) : null;
        this.sourceGeometryIndex = this.isExtraColumn ? theSourceFeatureType.getExtraColumns().getIndexOf(sourceGeomAtt.getName()) : sourceGeomAtt.getIndex();
        this.targetGeometryIndex = targetGeomAtt.getIndex();
        this.sourceGeometryName = sourceGeomAtt.getName();
    }

    private int getGeometryColumnCount(FeatureType featureType) {
        int count = 0;
        for (int i = 0; i < featureType.size(); ++i) {
            if (featureType.getAttributeDescriptor(i).getType() != 66) continue;
            ++count;
        }
        return count;
    }

    public String getLastErrorMessage() {
        return this.lastErrorMessage;
    }

    public int copyGeometry(Feature sourceFeature, EditableFeature targetFeature) {
        if (this.sourceGeometryIndex < 0 || this.targetGeometryIndex < 0) {
            return 0;
        }
        Geometry geometry = this.isExtraColumn ? sourceFeature.getGeometry(this.sourceGeometryName) : sourceFeature.getGeometry(this.sourceGeometryIndex);
        ExportServiceManager.FixGeometryStatus check = this.serviceManager.fixGeometry(this.parameters, this.coord_trans, geometry);
        if (check.getState() == 0) {
            targetFeature.setGeometry(this.targetGeometryIndex, check.getGeometry());
        }
        this.lastErrorMessage = check.getMessage();
        return check.getState();
    }

    public boolean canProcessGeometry() {
        return this.sourceGeometryIndex >= 0 && this.targetGeometryIndex >= 0;
    }

    private FeatureAttributeDescriptor getFirstGeometryColumn(FeatureType featureType) {
        for (int i = 0; i < featureType.size(); ++i) {
            FeatureAttributeDescriptor descriptor = featureType.getAttributeDescriptor(i);
            if (descriptor.getType() != 66) continue;
            return descriptor;
        }
        return null;
    }
}

