/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.polyline;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.gvsig.euclidean.EuclideanLine2D;
import org.gvsig.euclidean.EuclideanManager;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Arc;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.OrientablePrimitive;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.geom.primitive.Surface;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.tools.util.ToolsUtilLocator;
import org.gvsig.vectorediting.lib.api.DrawingStatus;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.EditingServiceParameterOptions;
import org.gvsig.vectorediting.lib.api.exceptions.DrawServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;
import org.gvsig.vectorediting.lib.api.exceptions.StartServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.VectorEditingException;
import org.gvsig.vectorediting.lib.prov.polyline.MyPolyLinePoint;
import org.gvsig.vectorediting.lib.spi.AbstractEditingProvider;
import org.gvsig.vectorediting.lib.spi.DefaultDrawingStatus;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameter;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameterOptions;
import org.gvsig.vectorediting.lib.spi.EditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProviderLocator;
import org.gvsig.vectorediting.lib.spi.EditingProviderManager;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolylineEditingProvider
extends AbstractEditingProvider
implements EditingProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolylineEditingProvider.class);
    public static final String KEY_REMOVE_LAST_POINT = "key_remove_last_point";
    public static final String KEY_FINISH = "key_finish";
    public static final String KEY_CLOSE = "key_close";
    public static final String KEY_LINE_MODE = "key_line_mode";
    public static final String KEY_ARC_MODE = "key_arc_mode";
    public static final String REMOVE_LAST_POINT = "remove_last_point";
    public static final String FINISH = "finish";
    public static final String CLOSE_POLYLINE = "close_polyline";
    public static final String LINE_MODE = "line_mode";
    public static final String ARC_MODE = "arc_mode";
    protected EditingProviderServices editingProviderServices = this.getProviderServices();
    protected EditingServiceParameter points;
    private boolean arcMode;
    private boolean finishPolyline;
    private boolean closeGeometry;
    private List<MyPolyLinePoint> values;
    protected FeatureStore featureStore;

    public PolylineEditingProvider(ProviderServices providerServices, DynObject parameters) {
        super(providerServices);
        this.featureStore = (FeatureStore)parameters.getDynValue("featureStore");
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        DefaultEditingServiceParameterOptions options = new DefaultEditingServiceParameterOptions().add(ARC_MODE, (Object)ARC_MODE, i18nManager.getTranslation(KEY_ARC_MODE)).add(LINE_MODE, (Object)LINE_MODE, i18nManager.getTranslation(KEY_LINE_MODE)).add(CLOSE_POLYLINE, (Object)CLOSE_POLYLINE, i18nManager.getTranslation(KEY_CLOSE)).add(FINISH, (Object)FINISH, i18nManager.getTranslation(KEY_FINISH)).add(REMOVE_LAST_POINT, (Object)REMOVE_LAST_POINT, i18nManager.getTranslation(KEY_REMOVE_LAST_POINT));
        String consoleMsg = this.editingProviderServices.makeConsoleMessage("indicate_new_point", (EditingServiceParameterOptions)options);
        this.points = new DefaultEditingServiceParameter("_point_options", consoleMsg, (EditingServiceParameterOptions)options, null, new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.LIST_POSITIONS, EditingServiceParameter.TYPE.OPTION}).setDataType(8);
        this.arcMode = false;
        this.finishPolyline = false;
        this.closeGeometry = false;
    }

    protected Line calculatePolyline(Point lastPosition) throws VectorEditingException, CreateGeometryException, DataException {
        DefaultDrawingStatus drawingStatus = new DefaultDrawingStatus();
        return this.calculatePolyline(lastPosition, drawingStatus);
    }

    protected Line calculatePolyline(Point lastPosition, DefaultDrawingStatus drawingStatus) throws VectorEditingException, CreateGeometryException, DataException {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        GeometryType storeGeomType = this.editingProviderServices.getGeomType(this.featureStore);
        Line line = geomManager.createLine(storeGeomType.getSubType());
        Line previewLine = geomManager.createLine(storeGeomType.getSubType());
        EuclideanManager euclideanManager = ToolsUtilLocator.getEuclideanManager();
        EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
        ISymbol previewSymbol = this.getPreviewSymbol();
        ISymbol lineSymbolEditing = editingProviderManager.getSymbol("line-symbol-editing");
        ISymbol auxiliaryLineSymbolEditing = editingProviderManager.getSymbol("auxiliary-line-symbol-editing");
        ISymbol auxiliaryPointSymbolEditing = editingProviderManager.getSymbol("auxiliary-point-symbol-editing");
        Point antPoint = null;
        Point center = null;
        double radius = 0.0;
        double startAngle = 0.0;
        double sweepAngle = 0.0;
        boolean addGeom = false;
        Point nextPoint = null;
        if (this.values.size() > 0) {
            for (int i = 0; i < this.values.size(); ++i) {
                MyPolyLinePoint polyLinePoint = this.values.get(i);
                MyPolyLinePoint polyLineNextPoint = this.getNextPoint(i);
                Point point = polyLinePoint.getPoint();
                previewLine.addVertex(point);
                line.addVertex(point);
                if (polyLineNextPoint == null) {
                    nextPoint = lastPosition;
                    addGeom = true;
                } else {
                    nextPoint = polyLineNextPoint.getPoint();
                }
                if (nextPoint == null) {
                    drawingStatus.addStatus((Geometry)previewLine, lineSymbolEditing, "");
                    drawingStatus.addStatus((Geometry)previewLine, previewSymbol, "", 0);
                    if (line.getNumVertices() > 1) {
                        return line;
                    }
                    return null;
                }
                try {
                    int subtype;
                    boolean areThreePointsInLine = false;
                    if (antPoint != null) {
                        areThreePointsInLine = GeometryUtils.areThreePointsInLine(antPoint, (Point)point, (Point)nextPoint);
                    }
                    if (polyLinePoint.isArcMode() && !areThreePointsInLine) {
                        EuclideanLine2D lineAPP;
                        EuclideanLine2D perpAPP;
                        subtype = this.editingProviderServices.getSubType(this.featureStore);
                        double coefDirection = 1.0;
                        if (antPoint != null) {
                            coefDirection = GeometryUtils.getCoefDirection((Point)antPoint, (Point)point, (Point)nextPoint);
                        }
                        Line lineAntPointToPoint = GeometryUtils.createLine((Point)point, (Point)nextPoint, (int)subtype);
                        Point midPointPNP = GeometryUtils.getMidPoint((Point)point, (Point)nextPoint, (int)subtype);
                        EuclideanLine2D linePNP = euclideanManager.createLine2D(point.getX(), point.getY(), nextPoint.getX(), nextPoint.getY());
                        EuclideanLine2D bisectorAC = linePNP.getPerpendicular(midPointPNP.getX(), midPointPNP.getY());
                        Point2D intersection = bisectorAC.getIntersection(perpAPP = (lineAPP = euclideanManager.createLine2D(antPoint.getX(), antPoint.getY(), point.getX(), point.getY())).getPerpendicular(point.getX(), point.getY()));
                        center = geomManager.createPoint(intersection.getX(), intersection.getY(), subtype);
                        if (center != null) {
                            startAngle = GeometryUtils.calculateAngle((Point)center, (Point)point);
                            radius = center.distance((Geometry)point);
                            sweepAngle = GeometryUtils.calculateAngle((Point)center, (Point)point, (Point)nextPoint);
                            if (coefDirection < 0.0) {
                                sweepAngle = -(Math.PI * 2 - sweepAngle);
                            }
                            if (Math.signum(coefDirection) != Math.signum(sweepAngle)) {
                                sweepAngle = -(Math.PI * 2 - sweepAngle);
                            }
                        } else {
                            String msg = String.format("Can't calculate center of arc between point (%1$s,%2$s) and nextPoint (%3$s,%4$s) with previous point (%5$s,%6$s)", point.getX(), point.getY(), nextPoint.getX(), nextPoint.getY(), antPoint.getX(), antPoint.getY());
                            throw new DrawServiceException(msg, null);
                        }
                        Arc arco = GeometryUtils.createArc((Point)center, (double)radius, (double)startAngle, (double)sweepAngle, (int)0);
                        antPoint = GeometryUtils.createPoint((Point)center, (double)Math.sqrt(Math.pow(radius, 2.0) + Math.pow(radius * Math.sin(sweepAngle / 1000.0), 2.0)), (double)(startAngle + sweepAngle - sweepAngle / 1000.0));
                        if (addGeom) {
                            drawingStatus.addStatus((Geometry)point, auxiliaryPointSymbolEditing, "");
                            drawingStatus.addStatus((Geometry)nextPoint, auxiliaryPointSymbolEditing, "");
                            drawingStatus.addStatus((Geometry)center, auxiliaryPointSymbolEditing, "");
                            drawingStatus.addStatus((Geometry)lineAntPointToPoint, auxiliaryLineSymbolEditing, "");
                        }
                        Object vertexAnt = null;
                        MultiLine multiline = arco.toLines();
                        for (int n = 0; n < multiline.getPrimitivesNumber(); ++n) {
                            Line arcLine = (Line)multiline.getPrimitiveAt(n);
                            if (arcLine.getNumVertices() > 0 && vertexAnt != null && arcLine.getVertex(0) != vertexAnt) {
                                arcLine.flip();
                            }
                            for (int j = 0; j < arcLine.getNumVertices() - 1; ++j) {
                                if (vertexAnt != null && vertexAnt.equals(arcLine.getVertex(j))) continue;
                                line.addVertex(arcLine.getVertex(j));
                                previewLine.addVertex(arcLine.getVertex(j));
                                vertexAnt = arcLine.getVertex(j);
                            }
                            nextPoint = arcLine.getVertex(arcLine.getNumVertices() - 1);
                        }
                        continue;
                    }
                    subtype = this.editingProviderServices.getSubType(this.featureStore);
                    if (addGeom) {
                        drawingStatus.addStatus((Geometry)point, auxiliaryPointSymbolEditing, "");
                        drawingStatus.addStatus((Geometry)nextPoint, auxiliaryPointSymbolEditing, "");
                    }
                    antPoint = point;
                    continue;
                }
                catch (Exception e) {
                    throw new DrawServiceException((Throwable)e);
                }
            }
            if (nextPoint != null) {
                line.addVertex(nextPoint);
                previewLine.addVertex(nextPoint);
                nextPoint = null;
            }
            drawingStatus.addStatus((Geometry)previewLine, lineSymbolEditing, "");
            drawingStatus.addStatus((Geometry)previewLine, previewSymbol, "", 0);
            if (line.getNumVertices() > 1) {
                return line;
            }
            return null;
        }
        return null;
    }

    protected Geometry closeGeometryIfNecessary(Geometry geometry) {
        if (!this.isClose(geometry) && geometry != null) {
            if (geometry instanceof Surface) {
                Surface surface = (Surface)geometry;
                Point firstp = surface.getVertex(0);
                firstp = firstp.cloneGeometry();
                surface.addVertex(firstp);
                return surface;
            }
            if (geometry instanceof Curve) {
                Curve line = (Curve)geometry;
                Point firstp = line.getVertex(0);
                firstp = firstp.cloneGeometry();
                line.addVertex(firstp);
                return line;
            }
        }
        return geometry;
    }

    public DrawingStatus getDrawingStatus(Point mousePosition) throws DrawServiceException {
        try {
            DefaultDrawingStatus drawingStatus = new DefaultDrawingStatus();
            Line geom = this.calculatePolyline(mousePosition, drawingStatus);
            return drawingStatus;
        }
        catch (Exception e) {
            throw new DrawServiceException((Throwable)e);
        }
    }

    public void finishAndStore() throws FinishServiceException {
        try {
            Geometry geometry = this.finish();
            if (geometry != null) {
                this.editingProviderServices.insertGeometryIntoFeatureStore(geometry, this.featureStore);
            }
        }
        catch (Exception e) {
            throw new FinishServiceException((Throwable)e);
        }
    }

    public Geometry finish() throws FinishServiceException {
        try {
            GeometryManager geomManager = GeometryLocator.getGeometryManager();
            GeometryType storeGeomType = this.editingProviderServices.getGeomType(this.featureStore);
            Line line = this.calculatePolyline(null);
            if (line == null) {
                return null;
            }
            if (this.closeGeometry) {
                line = (Line)this.closeGeometryIfNecessary((Geometry)line);
            }
            return this.makeMultiPrimitiveIsNeeded(this.featureStore, (Primitive)line);
        }
        catch (BaseException e) {
            throw new FinishServiceException((Throwable)e);
        }
    }

    public String getName() {
        return "insert-polyline";
    }

    private MyPolyLinePoint getNextPoint(int i) {
        if (!this.values.isEmpty() && i < this.values.size() - 1) {
            return this.values.get(i + 1);
        }
        return null;
    }

    private MyPolyLinePoint getPreviousPoint(int i) {
        if (!this.values.isEmpty() && i > 0) {
            return this.values.get(i - 1);
        }
        return null;
    }

    public List<EditingServiceParameter> getParameters() {
        ArrayList<EditingServiceParameter> list = new ArrayList<EditingServiceParameter>();
        list.add(this.points);
        return list;
    }

    private boolean isClose(Geometry geometry) {
        Point lastPoint;
        OrientablePrimitive orientablePrimitive;
        Point firstPoint;
        return geometry != null && geometry instanceof OrientablePrimitive && (firstPoint = (orientablePrimitive = (OrientablePrimitive)geometry).getVertex(0)).equals(lastPoint = orientablePrimitive.getVertex(orientablePrimitive.getNumVertices() - 1));
    }

    public EditingServiceParameter next() {
        if (this.finishPolyline) {
            return null;
        }
        return this.points;
    }

    public void start() throws StartServiceException {
        this.stop();
        this.values = new ArrayList<MyPolyLinePoint>();
    }

    public void stop() {
        if (this.values != null) {
            this.values.clear();
        }
        this.arcMode = false;
        this.finishPolyline = false;
        this.closeGeometry = false;
    }

    private void validateAndInsertValue(EditingServiceParameter param, Object value) throws InvalidEntryException {
        if (value instanceof String) {
            String option = (String)param.getOptions2().getValue(value, param.getDefaultValue());
            if (StringUtils.equalsIgnoreCase((String)option, (String)FINISH)) {
                this.finishPolyline = true;
                return;
            }
            if (this.values.size() > 0 && StringUtils.equalsIgnoreCase((String)option, (String)REMOVE_LAST_POINT)) {
                this.arcMode = this.values.get(this.values.size() - 1).isArcMode();
                if (this.values.size() > 2) {
                    this.values.get(this.values.size() - 2).setArcMode(this.arcMode);
                } else {
                    this.arcMode = false;
                }
                this.values.remove(this.values.size() - 1);
                return;
            }
            if (this.values.size() >= 2) {
                if (StringUtils.equalsIgnoreCase((String)option, (String)ARC_MODE)) {
                    this.arcMode = true;
                } else if (StringUtils.equalsIgnoreCase((String)option, (String)LINE_MODE)) {
                    this.arcMode = false;
                } else if (StringUtils.equalsIgnoreCase((String)option, (String)CLOSE_POLYLINE)) {
                    this.closeGeometry = true;
                    this.finishPolyline = true;
                }
            } else {
                throw new InvalidEntryException(null);
            }
            if (this.values.size() > 0) {
                this.values.get(this.values.size() - 1).setArcMode(this.arcMode);
                return;
            }
        } else if (param == this.points && value instanceof Point) {
            Point vertex = ((Point)value).cloneGeometry();
            this.values.add(new MyPolyLinePoint(vertex, this.arcMode));
            return;
        }
        throw new InvalidEntryException(null);
    }

    public void setValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        this.validateAndInsertValue(parameter, value);
    }

    public void setValue(Object value) throws InvalidEntryException {
        EditingServiceParameter param = this.next();
        this.validateAndInsertValue(param, value);
    }

    public Object getValue(EditingServiceParameter parameter) {
        if (parameter == this.points) {
            return this.values;
        }
        return null;
    }
}

