/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.complexlegend.swing.impl;

import com.jgoodies.forms.layout.CellConstraints;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.project.documents.view.legend.gui.AbstractParentPanel;
import org.gvsig.app.project.documents.view.legend.gui.Features;
import org.gvsig.app.project.documents.view.legend.gui.ILegendPanel;
import org.gvsig.complexlegend.ComplexLegendItem;
import org.gvsig.complexlegend.VectorComplexLegend;
import org.gvsig.complexlegend.impl.DefaultVectorComplexLegend;
import org.gvsig.complexlegend.swing.ComplexLegendPanel;
import org.gvsig.complexlegend.swing.impl.ComplexLegendItemPanel;
import org.gvsig.complexlegend.swing.impl.DefaultComplexLegendPanelView;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.rendering.legend.ILegend;
import org.gvsig.symbology.swing.SymbologySwingLocator;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultComplexLegendPanelController
extends DefaultComplexLegendPanelView
implements ComplexLegendPanel,
Observer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultComplexLegendPanelController.class);
    private VectorComplexLegend auxLegend;
    private FLayer layer;
    private DefaultComboBoxModel model;
    private ILegendPanel legendPanel;
    private JDialog dlg;
    private ComplexLegendItem currentItem;

    public DefaultComplexLegendPanelController() {
        this.translate();
        this.initializeComponents();
    }

    private void translate() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        this.chkAllowOverlap.setText(i18nManager.getTranslation(this.chkAllowOverlap.getText()));
        this.legendPanelTitle.setText(i18nManager.getTranslation(this.legendPanelTitle.getText()));
        this.symbolPanelTitle.setText(i18nManager.getTranslation(this.symbolPanelTitle.getText()));
        this.addButton.setToolTipText(i18nManager.getTranslation(this.addButton.getToolTipText()));
        this.removeButton.setToolTipText(i18nManager.getTranslation(this.removeButton.getToolTipText()));
    }

    private void initializeComponents() {
        this.addButton.setIcon(PluginServices.getIconTheme().get("legend-add"));
        this.addButton.addActionListener(arg0 -> this.createComplexLegendItemWindow());
        this.removeButton.setIcon(PluginServices.getIconTheme().get("legend-delete"));
        this.removeButton.addActionListener(arg0 -> this.removeComplexLegendItem());
        this.cmbValue.setModel(this.getComboBoxModel());
        this.cmbValue.setPreferredSize(new Dimension(350, 20));
        this.cmbValue.addActionListener(e -> this.refreshLegendPanel());
    }

    private DefaultComboBoxModel getComboBoxModel() {
        if (this.model == null) {
            this.model = new DefaultComboBoxModel();
            this.model.addListDataListener(new ListDataListener(){

                @Override
                public void intervalRemoved(ListDataEvent arg0) {
                }

                @Override
                public void intervalAdded(ListDataEvent arg0) {
                }

                @Override
                public void contentsChanged(ListDataEvent arg0) {
                    DefaultComplexLegendPanelController.this.refreshButtons();
                }
            });
        }
        return this.model;
    }

    protected void refreshButtons() {
        boolean status = this.getComboBoxModel().getSize() != 0;
        this.cmbValue.setEnabled(status);
        this.removeButton.setEnabled(status);
        if (this.legendPanel != null) {
            this.legendPanel.getPanel().setVisible(status);
        }
        if (this.auxLegend != null && this.auxLegend instanceof DefaultVectorComplexLegend) {
            this.chkAllowOverlap.setSelected(this.auxLegend.getAllowOverlap());
        }
    }

    protected void createComplexLegendItemWindow() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        if (this.layer != null) {
            ComplexLegendItemPanel legendItemPanel = new ComplexLegendItemPanel(this.layer, (VectorComplexLegend)this.getLegend());
            legendItemPanel.addObserver(this);
            this.dlg = new JDialog();
            this.dlg.setTitle(i18nManager.getTranslation("SelectItem"));
            this.dlg.setResizable(true);
            this.dlg.getContentPane().add(legendItemPanel);
            this.dlg.setDefaultCloseOperation(2);
            this.dlg.setSize(510, 510);
            this.dlg.setModal(true);
            this.dlg.pack();
            this.dlg.setLocationRelativeTo(null);
            this.dlg.setVisible(true);
        }
    }

    public String getDescription() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        return i18nManager.getTranslation("legend_by_scale");
    }

    public ImageIcon getIcon() {
        return IconThemeHelper.getImageIcon((String)"scaled-symbols");
    }

    public ILegend getLegend() {
        if (this.auxLegend == null) {
            this.auxLegend = (VectorComplexLegend)MapContextLocator.getMapContextManager().createLegend("ComplexLegend");
        }
        this.saveCurrentPanel();
        this.auxLegend.setAllowOverlap(this.chkAllowOverlap.isSelected());
        return (VectorComplexLegend)this.auxLegend.cloneLegend();
    }

    public Class getLegendClass() {
        return DefaultVectorComplexLegend.class;
    }

    public JPanel getPanel() {
        return this;
    }

    public Class getParentClass() {
        return Features.class;
    }

    public String getTitle() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        return i18nManager.getTranslation("complex_symbology");
    }

    public boolean isSuitableFor(FLayer layer) {
        return layer instanceof FLyrVect;
    }

    public void setData(FLayer layer, ILegend data) {
        this.layer = layer;
        if (data instanceof DefaultVectorComplexLegend) {
            this.auxLegend = (DefaultVectorComplexLegend)data.cloneLegend();
            this.updateComboModel();
            this.chkAllowOverlap.setSelected(this.auxLegend.getAllowOverlap());
        }
    }

    private void saveCurrentPanel() {
        if (this.legendPanel != null && this.currentItem != null) {
            this.currentItem.setLegend(this.legendPanel.getLegend());
        }
    }

    public void refreshLegendPanel() {
        ILegendPanel aux;
        ComplexLegendItem item = (ComplexLegendItem)this.cmbValue.getSelectedItem();
        if (item != null && (aux = this.getLegendPanel(item.getLegend())) != null) {
            this.saveCurrentPanel();
            this.symbolPanel.removeAll();
            this.legendPanel = aux;
            this.legendPanel.setData(this.layer, item.getLegend());
            CellConstraints cc = new CellConstraints();
            this.symbolPanel.add((Component)this.legendPanel.getPanel(), cc.xy(1, 1));
            this.symbolPanel.repaint();
            this.symbolPanel.revalidate();
            this.currentItem = item;
        }
    }

    private ILegendPanel getLegendPanel(ILegend legend) {
        List panels = SymbologySwingLocator.getSwingManager().getLegendEditorClasses();
        for (Class panelClass : panels) {
            try {
                ILegendPanel panel = (ILegendPanel)panelClass.newInstance();
                if (panel instanceof AbstractParentPanel || !panel.getLegendClass().equals(legend.getClass())) continue;
                panel.setData(this.layer, legend);
                return panel;
            }
            catch (Exception e) {
                LOGGER.warn("Error creating ILegendPanel. ", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    protected void removeComplexLegendItem() {
        ComplexLegendItem item = (ComplexLegendItem)this.cmbValue.getSelectedItem();
        int index = this.auxLegend.getLegends().indexOf(item);
        if (index != -1) {
            this.auxLegend.remove(item);
            this.getComboBoxModel().removeElementAt(index);
        }
        this.refreshButtons();
    }

    public void update(Observable observable, Object isAccepted) {
        if (observable instanceof ComplexLegendItemPanel && isAccepted instanceof Boolean) {
            ComplexLegendItemPanel itemPanel = (ComplexLegendItemPanel)observable;
            boolean acceptForm = (Boolean)isAccepted;
            if (!acceptForm) {
                this.dlg.dispose();
            } else if (itemPanel.validateValues()) {
                ComplexLegendItem item = itemPanel.getLegendItem();
                this.saveCurrentPanel();
                this.auxLegend.add(item);
                this.updateComboModel();
                this.symbolPanel.removeAll();
                this.legendPanel = itemPanel.getLegendPanel();
                this.legendPanel.setData(this.layer, item.getLegend());
                CellConstraints cc = new CellConstraints();
                this.symbolPanel.add((Component)this.legendPanel.getPanel(), cc.xy(1, 1));
                this.symbolPanel.repaint();
                this.currentItem = item;
                this.cmbValue.setSelectedItem(item);
                this.dlg.dispose();
            }
        }
    }

    private void updateComboModel() {
        this.getComboBoxModel().removeAllElements();
        if (this.auxLegend != null) {
            for (ComplexLegendItem item : this.auxLegend.getLegends()) {
                this.getComboBoxModel().addElement(item);
            }
        }
    }
}

