/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.derivedgeometries.swing.impl.panels;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FilenameUtils;
import org.gvsig.derivedgeometries.swing.api.DerivedGeometriesLocator;
import org.gvsig.derivedgeometries.swing.api.DerivedGeometriesParameters;
import org.gvsig.derivedgeometries.swing.api.DerivedGeometriesProcess;
import org.gvsig.derivedgeometries.swing.api.exceptions.ValidateSourceLayerException;
import org.gvsig.derivedgeometries.swing.api.panels.LayerAndProcessSelectionPanel;
import org.gvsig.derivedgeometries.swing.impl.views.LayerAndProcessSelectionPanelView;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.layers.CancelationException;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontext.layers.LayerCollectionEvent;
import org.gvsig.fmap.mapcontext.layers.LayerCollectionListener;
import org.gvsig.fmap.mapcontext.layers.LayerPositionEvent;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.utils.GenericFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLayerAndProcessSelectionPanel
extends LayerAndProcessSelectionPanelView
implements LayerAndProcessSelectionPanel {
    private static final long serialVersionUID = 1032294236575442328L;
    private static final Logger LOG = LoggerFactory.getLogger(DefaultLayerAndProcessSelectionPanel.class);
    private final String[] SHAPE_EXTENSIONS = new String[]{"shp", "SHP", "Shp", "sHp", "SHp", "shP", "ShP", "sHP"};
    private MapControl mapControl;
    private DerivedGeometriesParameters parameters;

    public DefaultLayerAndProcessSelectionPanel(MapControl mapControl) {
        this.mapControl = mapControl;
        this.initSourceLayerCombo();
        this.initProcessCombo();
        this.initSelectPathButton();
        this.addVectorialLayers();
        this.initMapControlListeners();
    }

    private void addVectorialLayers() {
        this.getLayersComboBox().removeAllItems();
        FLayers flayers = this.mapControl.getMapContext().getLayers();
        for (FLyrVect layer : this.getVectorialLayers(flayers)) {
            this.getLayersComboBox().addItem((Object)layer);
        }
    }

    public JComponent asJComponent() {
        return this;
    }

    public void closePanel() {
        this.setVisible(false);
    }

    private void deleteShapeFiles(FLyrVect sourceLayer, String outputLayerPath) {
        DataManager dataManager = DALLocator.getDataManager();
        try {
            DataServerExplorerParameters eparams = dataManager.createServerExplorerParameters("FilesystemExplorer");
            eparams.setDynValue("initialpath", (Object)"/data");
            DataServerExplorer serverExplorer = dataManager.openServerExplorer(eparams.getExplorerName(), eparams);
            DataStoreParameters dataStoreParams = dataManager.createStoreParameters("Shape");
            dataStoreParams.setDynValue("shpfile", (Object)outputLayerPath);
            dataStoreParams.setDynValue("CRS", (Object)sourceLayer.getProjection());
            dataStoreParams.setDynValue("useNullGeometry", (Object)false);
            dataStoreParams.validate();
            serverExplorer.remove(dataStoreParams);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doAccept() {
        FLyrVect sourceLayer = (FLyrVect)this.getLayersComboBox().getSelectedItem();
        String outputLayerName = this.getOutputLayerName().getText();
        String outputLayerPath = this.getOutputLayerPath().getText();
        String type = (String)this.getOutputShapeTypeCombo().getSelectedItem();
        File outputLayer = new File(outputLayerPath);
        if (this.exist(outputLayer)) {
            this.deleteShapeFiles(sourceLayer, outputLayerPath);
        }
        int outputLayerType = 0;
        if (type.equalsIgnoreCase("Multicurve")) {
            outputLayerType = 8;
        } else if (type.equalsIgnoreCase("Surface")) {
            outputLayerType = 3;
        }
        DerivedGeometriesProcess.TYPE processType = (DerivedGeometriesProcess.TYPE)this.getProcessCombo().getSelectedItem();
        this.parameters = DerivedGeometriesLocator.getManager().createDerivedGeometriesParameters(this.mapControl, sourceLayer, outputLayerName, outputLayerPath, outputLayerType, processType);
    }

    public void doCancel() {
        this.closePanel();
    }

    public DerivedGeometriesParameters getParameters() {
        return this.parameters;
    }

    private boolean exist(File file) {
        String pathWithoutExtension = FilenameUtils.removeExtension((String)file.getAbsolutePath());
        for (int i = 0; i < this.SHAPE_EXTENSIONS.length; ++i) {
            String path = pathWithoutExtension + "." + this.SHAPE_EXTENSIONS[i];
            File tmpFile = new File(path);
            if (!tmpFile.exists()) continue;
            return true;
        }
        return false;
    }

    private Vector<FLyrVect> getVectorialLayers(FLayers flayers) {
        Vector<FLyrVect> vectorialLayers = new Vector<FLyrVect>();
        for (int i = 0; i < flayers.getLayersCount(); ++i) {
            if (flayers.getLayer(i) instanceof FLyrVect) {
                vectorialLayers.add((FLyrVect)flayers.getLayer(i));
                continue;
            }
            if (!(flayers.getLayer(i) instanceof FLayers)) continue;
            FLayers group = (FLayers)flayers.getLayer(i);
            vectorialLayers.addAll(this.getVectorialLayers(group));
        }
        return vectorialLayers;
    }

    private void initMapControlListeners() {
        MapContext context = this.mapControl.getMapContext();
        FLayers layers = context.getLayers();
        layers.addLayerCollectionListener(new LayerCollectionListener(){

            public void layerAdded(LayerCollectionEvent e) {
                FLayer layer = e.getAffectedLayer();
                if (layer instanceof FLyrVect) {
                    DefaultLayerAndProcessSelectionPanel.this.getLayersComboBox().addItem((Object)layer);
                }
            }

            public void layerAdding(LayerCollectionEvent e) throws CancelationException {
            }

            public void layerMoved(LayerPositionEvent e) {
            }

            public void layerMoving(LayerPositionEvent e) throws CancelationException {
            }

            public void layerRemoved(LayerCollectionEvent e) {
                FLayer layer = e.getAffectedLayer();
                if (layer instanceof FLyrVect) {
                    DefaultLayerAndProcessSelectionPanel.this.getLayersComboBox().removeItem((Object)layer);
                }
            }

            public void layerRemoving(LayerCollectionEvent e) throws CancelationException {
            }

            public void visibilityChanged(LayerCollectionEvent e) throws CancelationException {
            }
        });
    }

    private void initProcessCombo() {
        this.getProcessCombo().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DerivedGeometriesProcess.TYPE processType = (DerivedGeometriesProcess.TYPE)DefaultLayerAndProcessSelectionPanel.this.getProcessCombo().getSelectedItem();
                if (processType != null) {
                    switch (processType) {
                        case POINTS_TO_LINE: {
                            DefaultLayerAndProcessSelectionPanel.this.getOutputShapeTypeCombo().removeAllItems();
                            DefaultLayerAndProcessSelectionPanel.this.getOutputShapeTypeCombo().addItem((Object)"Multicurve");
                            break;
                        }
                        case POINTS_TO_POLYGON: {
                            DefaultLayerAndProcessSelectionPanel.this.getOutputShapeTypeCombo().removeAllItems();
                            DefaultLayerAndProcessSelectionPanel.this.getOutputShapeTypeCombo().addItem((Object)"Surface");
                            break;
                        }
                    }
                }
            }
        });
    }

    private void initSelectPathButton() {
        this.getJButtonSelectPath().addActionListener(new ActionListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                I18nManager i18nManager;
                ThreadSafeDialogsManager dlgManager = ToolsSwingLocator.getThreadSafeDialogsManager();
                File[] files = dlgManager.showChooserDialog((i18nManager = ToolsLocator.getI18nManager()).getTranslation("shape_file"), 0, 0, false, new File(System.getProperty("user.home")), (FileFilter)new GenericFileFilter(DefaultLayerAndProcessSelectionPanel.this.SHAPE_EXTENSIONS, i18nManager.getTranslation("shape_file") + " (*.shp)"), true);
                if (files == null) {
                    return;
                }
                if (files.length != 1) return;
                File file = files[0];
                String extension = FilenameUtils.getExtension((String)file.getAbsolutePath());
                if (extension == "") {
                    StringBuilder stb = new StringBuilder();
                    stb.append(file.getAbsolutePath());
                    stb.append(".");
                    stb.append(DefaultLayerAndProcessSelectionPanel.this.SHAPE_EXTENSIONS[0]);
                    file = new File(stb.toString());
                }
                if (DefaultLayerAndProcessSelectionPanel.this.exist(file)) {
                    String title = i18nManager.getTranslation("_file_already_exist");
                    String message = i18nManager.getTranslation("_file_already_exist_override_it");
                    int answer = dlgManager.confirmDialog(message, title, 0, 1);
                    if (answer != 0) return;
                    DefaultLayerAndProcessSelectionPanel.this.getOutputLayerPath().setText(file.getAbsolutePath());
                    return;
                } else {
                    DefaultLayerAndProcessSelectionPanel.this.getOutputLayerPath().setText(file.getAbsolutePath());
                }
            }
        });
    }

    private void initSourceLayerCombo() {
        this.getLayersComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FLyrVect selectedLayer = (FLyrVect)DefaultLayerAndProcessSelectionPanel.this.getLayersComboBox().getSelectedItem();
                GeometryType featureGeomType = null;
                DefaultLayerAndProcessSelectionPanel.this.getOutputShapeTypeCombo().removeAllItems();
                DefaultLayerAndProcessSelectionPanel.this.getProcessCombo().removeAllItems();
                if (selectedLayer != null) {
                    FeatureStore featureStore = selectedLayer.getFeatureStore();
                    try {
                        featureGeomType = featureStore.getDefaultFeatureType().getDefaultGeometryAttribute().getGeomType();
                    }
                    catch (DataException ex) {
                        String message = String.format("Error getting feature type of %1", featureStore);
                        LOG.info(message, (Throwable)ex);
                        return;
                    }
                    if (featureGeomType.isTypeOf(1) || featureGeomType.isTypeOf(7)) {
                        DefaultLayerAndProcessSelectionPanel.this.setSelectableComponentsEnabled(true);
                        DefaultLayerAndProcessSelectionPanel.this.getOutputShapeTypeCombo().addItem((Object)"Multicurve");
                        DefaultLayerAndProcessSelectionPanel.this.getProcessCombo().addItem((Object)DerivedGeometriesProcess.TYPE.POINTS_TO_LINE);
                        DefaultLayerAndProcessSelectionPanel.this.getProcessCombo().addItem((Object)DerivedGeometriesProcess.TYPE.POINTS_TO_POLYGON);
                    } else if (featureGeomType.isTypeOf(8)) {
                        DefaultLayerAndProcessSelectionPanel.this.setSelectableComponentsEnabled(true);
                        DefaultLayerAndProcessSelectionPanel.this.getOutputShapeTypeCombo().addItem((Object)"Surface");
                        DefaultLayerAndProcessSelectionPanel.this.getProcessCombo().addItem((Object)DerivedGeometriesProcess.TYPE.LINES_TO_CLOSED_POLYLINE);
                    } else {
                        DefaultLayerAndProcessSelectionPanel.this.setSelectableComponentsEnabled(false);
                        DefaultLayerAndProcessSelectionPanel.this.getOutputLayerName().setText("");
                        DefaultLayerAndProcessSelectionPanel.this.getOutputLayerPath().setText("");
                    }
                }
            }
        });
    }

    public void setMapControl(MapControl mapControl) {
        this.mapControl = mapControl;
    }

    private void setSelectableComponentsEnabled(boolean b) {
        this.getOutputLayerPath().setEnabled(b);
        this.getOutputLayerName().setEnabled(b);
        this.getOutputShapeTypeCombo().setEnabled(b);
        this.getJButtonSelectPath().setEnabled(b);
        this.getProcessCombo().setEnabled(b);
    }

    public boolean validateFields() {
        FLyrVect sourceLayer = (FLyrVect)this.getLayersComboBox().getSelectedItem();
        String outputLayerName = this.getOutputLayerName().getText();
        String outputLayerPath = this.getOutputLayerPath().getText();
        return sourceLayer != null && outputLayerName.length() > 0 && outputLayerPath.length() > 0;
    }

    public boolean validateSourceLayer() throws ValidateSourceLayerException {
        GeometryType featureGeomType;
        FLyrVect sourceLayer = (FLyrVect)this.getLayersComboBox().getSelectedItem();
        FeatureStore featureStore = sourceLayer.getFeatureStore();
        try {
            featureGeomType = featureStore.getDefaultFeatureType().getDefaultGeometryAttribute().getGeomType();
        }
        catch (DataException e) {
            String message = String.format("Error validating %1. Can't get feature geometry type", sourceLayer);
            throw new ValidateSourceLayerException(message, (Throwable)e);
        }
        return featureGeomType.isTypeOf(1) || featureGeomType.isTypeOf(7) || featureGeomType.isTypeOf(8);
    }
}

