/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.derivedgeometries.swing.impl.views;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableModel;
import org.gvsig.derivedgeometries.swing.api.exceptions.FetaureTableModelException;
import org.gvsig.derivedgeometries.swing.impl.views.SelectedFeaturesTableModel;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.FeatureSelectionModel;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.FeatureTable;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.table.ConfigurableFeatureTableModel;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.table.FeatureTableModel;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;

public class FeaturesControlPanelView
extends JPanel {
    private static final long serialVersionUID = -3899738999699332396L;
    private I18nManager i18nManager = ToolsLocator.getI18nManager();
    private JPanel summaryPanel;
    private JLabel sourceLayerNameLabel;
    private JTextField sourceLayerNameTextField;
    private JLabel destLayerNameLabel;
    private JTextField destLayerNameTextField;
    private JPanel centerPanel;
    private JSplitPane horizontalSplitPane;
    private JPanel featuresPanel;
    private JScrollPane allFeaturesScrollPane;
    private FeatureTable allFeaturesTable;
    private ConfigurableFeatureTableModel allFeaturesTableModel;
    private JPanel newFeatureSelectionPanel;
    private JPanel motionButtonsPanel;
    private JScrollPane selectedFeaturesScrollPane;
    private JTable selectedFeaturesTable;
    private JButton addAllIconButton;
    private JButton removeAllIconButton;
    private JButton addIconButton;
    private JButton removeIconButton;
    private JButton moveUpButton;
    private JButton moveDownButton;

    public FeaturesControlPanelView() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getSummaryPanel(), "First");
        this.add((Component)this.getCenterPanel(), "Center");
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(500, 550);
    }

    protected JScrollPane getAllFeaturesScrollPane() {
        if (this.allFeaturesScrollPane == null) {
            this.allFeaturesScrollPane = new JScrollPane();
            this.allFeaturesScrollPane.setHorizontalScrollBarPolicy(30);
        }
        return this.allFeaturesScrollPane;
    }

    protected FeatureTable getAllFeaturesTable(FeatureStore featureStore) throws FetaureTableModelException {
        if (this.allFeaturesTable == null) {
            try {
                this.allFeaturesTable = new FeatureTable((FeatureTableModel)this.getAllFeaturesTableModel(featureStore)){

                    public boolean isCellEditable(int row, int column) {
                        return false;
                    }
                };
                this.allFeaturesTable.setSelectionModel((ListSelectionModel)new FeatureSelectionModel((FeatureTableModel)this.allFeaturesTableModel));
            }
            catch (DataException e) {
                throw new FetaureTableModelException(e.getMessage(), (Throwable)e);
            }
            this.allFeaturesTable.setAutoResizeMode(0);
        }
        return this.allFeaturesTable;
    }

    protected ConfigurableFeatureTableModel getAllFeaturesTableModel(FeatureStore featureStore) throws FetaureTableModelException {
        if (this.allFeaturesTableModel == null) {
            try {
                FeatureQuery query = featureStore.createFeatureQuery();
                this.allFeaturesTableModel = new ConfigurableFeatureTableModel(featureStore, query);
            }
            catch (BaseException e) {
                throw new FetaureTableModelException(e.getMessage(), (Throwable)e);
            }
        }
        return this.allFeaturesTableModel;
    }

    private JPanel getCenterPanel() {
        if (this.centerPanel == null) {
            this.centerPanel = new JPanel();
            this.centerPanel.setLayout(new BorderLayout());
            this.centerPanel.add((Component)this.getHorizontalSplitPane(), "Center");
        }
        return this.centerPanel;
    }

    private JPanel getFeaturesPanel() {
        if (this.featuresPanel == null) {
            this.featuresPanel = new JPanel();
            this.featuresPanel.setBorder(BorderFactory.createTitledBorder(this.i18nManager.getTranslation("features")));
            this.featuresPanel.setLayout(new BorderLayout());
            this.featuresPanel.add((Component)this.getAllFeaturesScrollPane(), "Center");
        }
        return this.featuresPanel;
    }

    private JSplitPane getHorizontalSplitPane() {
        if (this.horizontalSplitPane == null) {
            this.horizontalSplitPane = new JSplitPane(0);
            this.horizontalSplitPane.setPreferredSize(this.getPreferredSize());
            this.horizontalSplitPane.setOneTouchExpandable(true);
            this.horizontalSplitPane.setTopComponent(this.getFeaturesPanel());
            this.horizontalSplitPane.setBottomComponent(this.getNewFeaturePanel());
            this.horizontalSplitPane.setDividerLocation((int)(this.horizontalSplitPane.getPreferredSize().getHeight() * 0.4));
        }
        return this.horizontalSplitPane;
    }

    private JPanel getNewFeaturePanel() {
        if (this.newFeatureSelectionPanel == null) {
            this.newFeatureSelectionPanel = new JPanel();
            this.newFeatureSelectionPanel.setBorder(BorderFactory.createTitledBorder(this.i18nManager.getTranslation("_new_features")));
            this.newFeatureSelectionPanel.setLayout(new BorderLayout());
            this.addAllIconButton = this.getAddAllButton();
            this.removeAllIconButton = this.getRemoveAllButton();
            this.addIconButton = this.getAddButton();
            this.removeIconButton = this.getRemoveButton();
            JPanel rightPanel = new JPanel();
            rightPanel.add(this.addIconButton);
            rightPanel.add(this.removeIconButton);
            JPanel leftPanel = new JPanel();
            leftPanel.add(this.addAllIconButton);
            leftPanel.add(this.removeAllIconButton);
            JPanel northPanel = new JPanel();
            northPanel.setLayout(new BorderLayout());
            northPanel.add((Component)leftPanel, "Before");
            northPanel.add((Component)rightPanel, "After");
            this.newFeatureSelectionPanel.add((Component)northPanel, "First");
            JPanel southPanel = new JPanel();
            southPanel.setLayout(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = -1;
            constraints.gridy = 0;
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.fill = 1;
            constraints.anchor = 17;
            southPanel.add((Component)this.getSelectedFeaturesScrollPane(), constraints);
            constraints = new GridBagConstraints();
            constraints.gridx = -1;
            constraints.gridy = 0;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.fill = 1;
            constraints.anchor = 13;
            southPanel.add((Component)this.getMotionButtonsPanel(), constraints);
            this.newFeatureSelectionPanel.add((Component)southPanel, "Center");
        }
        return this.newFeatureSelectionPanel;
    }

    protected JButton getAddAllButton() {
        if (this.addAllIconButton == null) {
            ImageIcon addAllIcon = ToolsSwingLocator.getIconThemeManager().getCurrent().get("add-all-icon");
            this.addAllIconButton = new JButton(addAllIcon);
            this.addAllIconButton.setToolTipText(this.i18nManager.getTranslation("_add_all_button_tooltip"));
        }
        return this.addAllIconButton;
    }

    protected JButton getAddButton() {
        if (this.addIconButton == null) {
            ImageIcon addIcon = ToolsSwingLocator.getIconThemeManager().getCurrent().get("add-selected-icon");
            this.addIconButton = new JButton(addIcon);
            this.addIconButton.setToolTipText(this.i18nManager.getTranslation("_add_selected_button_tooltip"));
        }
        return this.addIconButton;
    }

    protected JButton getRemoveAllButton() {
        if (this.removeAllIconButton == null) {
            ImageIcon removeAllIcon = ToolsSwingLocator.getIconThemeManager().getCurrent().get("remove-all-icon");
            this.removeAllIconButton = new JButton(removeAllIcon);
            this.removeAllIconButton.setToolTipText(this.i18nManager.getTranslation("_remove_all_button_tooltip"));
        }
        return this.removeAllIconButton;
    }

    protected JButton getRemoveButton() {
        if (this.removeIconButton == null) {
            ImageIcon removeIcon = ToolsSwingLocator.getIconThemeManager().getCurrent().get("remove-selected-icon");
            this.removeIconButton = new JButton(removeIcon);
            this.removeIconButton.setToolTipText(this.i18nManager.getTranslation("_remove_selected_button_tooltip"));
        }
        return this.removeIconButton;
    }

    protected JScrollPane getSelectedFeaturesScrollPane() {
        if (this.selectedFeaturesScrollPane == null) {
            this.selectedFeaturesScrollPane = new JScrollPane();
            this.selectedFeaturesScrollPane.setHorizontalScrollBarPolicy(30);
        }
        return this.selectedFeaturesScrollPane;
    }

    protected JTable getSelectedFeaturesTable() {
        if (this.selectedFeaturesTable == null) {
            this.selectedFeaturesTable = new JTable(){

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            };
            this.selectedFeaturesTable.setSelectionMode(2);
            this.selectedFeaturesTable.setAutoResizeMode(0);
        }
        return this.selectedFeaturesTable;
    }

    protected SelectedFeaturesTableModel getSelectedFeaturesTableModel() {
        TableModel model = this.getSelectedFeaturesTable().getModel();
        if (model instanceof SelectedFeaturesTableModel) {
            return (SelectedFeaturesTableModel)model;
        }
        return null;
    }

    private JPanel getMotionButtonsPanel() {
        if (this.motionButtonsPanel == null) {
            this.motionButtonsPanel = new JPanel();
            this.motionButtonsPanel.setLayout(new GridBagLayout());
            this.moveUpButton = this.getMoveUpButton();
            JPanel upPanel = new JPanel();
            upPanel.add(this.moveUpButton);
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = -1;
            constraints.gridheight = 0;
            constraints.gridwidth = 0;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.anchor = 10;
            constraints.fill = 0;
            constraints.insets = new Insets(4, 4, 4, 0);
            this.motionButtonsPanel.add((Component)upPanel, constraints);
            this.moveDownButton = this.getMoveDownButton();
            JPanel downPanel = new JPanel();
            downPanel.add(this.moveDownButton);
            this.motionButtonsPanel.add((Component)downPanel, constraints);
        }
        return this.motionButtonsPanel;
    }

    protected JButton getMoveUpButton() {
        if (this.moveUpButton == null) {
            ImageIcon moveUpIcon = ToolsSwingLocator.getIconThemeManager().getCurrent().get("up-arrow-icon");
            this.moveUpButton = new JButton(moveUpIcon);
            this.moveUpButton.setToolTipText(this.i18nManager.getTranslation("_move_up_button_tooltip"));
        }
        return this.moveUpButton;
    }

    protected JButton getMoveDownButton() {
        if (this.moveDownButton == null) {
            ImageIcon moveDownIcon = ToolsSwingLocator.getIconThemeManager().getCurrent().get("down-arrow-icon");
            this.moveDownButton = new JButton(moveDownIcon);
            this.moveDownButton.setToolTipText(this.i18nManager.getTranslation("_move_down_button_tooltip"));
        }
        return this.moveDownButton;
    }

    private JLabel getOutputLayerNameLabel() {
        if (this.destLayerNameLabel == null) {
            this.destLayerNameLabel = new JLabel(this.i18nManager.getTranslation("_output_layer"));
            this.destLayerNameLabel.setToolTipText(this.i18nManager.getTranslation("_output_layer"));
        }
        return this.destLayerNameLabel;
    }

    protected JTextField getOutputLayerNameTextField() {
        if (this.destLayerNameTextField == null) {
            this.destLayerNameTextField = new JTextField();
            this.destLayerNameTextField.setEnabled(false);
        }
        return this.destLayerNameTextField;
    }

    private JLabel getSourceLayerNameLabel() {
        if (this.sourceLayerNameLabel == null) {
            this.sourceLayerNameLabel = new JLabel(this.i18nManager.getTranslation("_source_layer"));
            this.sourceLayerNameLabel.setToolTipText(this.i18nManager.getTranslation("_source_layer"));
        }
        return this.sourceLayerNameLabel;
    }

    protected JTextField getSourceLayerNameTextField() {
        if (this.sourceLayerNameTextField == null) {
            this.sourceLayerNameTextField = new JTextField();
            this.sourceLayerNameTextField.setEnabled(false);
        }
        return this.sourceLayerNameTextField;
    }

    private JPanel getSummaryPanel() {
        if (this.summaryPanel == null) {
            this.summaryPanel = new JPanel();
            this.summaryPanel.setLayout(new BorderLayout());
            this.summaryPanel.setBorder(BorderFactory.createTitledBorder(this.i18nManager.getTranslation("_layers")));
            JPanel pageStartPanel = new JPanel();
            pageStartPanel.setLayout(new GridBagLayout());
            GridBagConstraints constraints = this.getConstraintsForLabel();
            pageStartPanel.add((Component)this.getSourceLayerNameLabel(), constraints);
            constraints = this.getContraintsForTextField();
            pageStartPanel.add((Component)this.getSourceLayerNameTextField(), constraints);
            this.summaryPanel.add((Component)pageStartPanel, "First");
            JPanel pageEndPanel = new JPanel();
            pageEndPanel.setLayout(new GridBagLayout());
            constraints = this.getConstraintsForLabel();
            pageEndPanel.add((Component)this.getOutputLayerNameLabel(), constraints);
            constraints = this.getContraintsForTextField();
            pageEndPanel.add((Component)this.getOutputLayerNameTextField(), constraints);
            this.summaryPanel.add((Component)pageEndPanel, "Last");
        }
        return this.summaryPanel;
    }

    private GridBagConstraints getConstraintsForLabel() {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = -1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(4, 4, 4, 4);
        return constraints;
    }

    private GridBagConstraints getContraintsForTextField() {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = -1;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.anchor = 10;
        constraints.fill = 2;
        constraints.insets = new Insets(4, 4, 4, 4);
        return constraints;
    }
}

