/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geometry.app.jts;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.PluginsManager;
import org.gvsig.andami.preferences.AbstractPreferencePage;
import org.gvsig.andami.preferences.StoreException;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.i18n.I18nManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlatnessPage
extends AbstractPreferencePage
implements KeyListener {
    private static final long serialVersionUID = -6521882508307037082L;
    private static final Logger logger = LoggerFactory.getLogger(FlatnessPage.class);
    public static final String ID = FlatnessPage.class.getName();
    private JPanel flatnessPanel;
    private JTextArea jTextArea = null;
    private JTextField txtFlatness;
    private boolean valChanged = false;
    private DynObject pluginProperties;
    private PluginServices plugin;
    private ImageIcon icon;

    public FlatnessPage() {
        this.initComponents();
    }

    private void initComponents() {
        this.icon = IconThemeHelper.getImageIcon((String)"preferences-layer-modify-flatness");
        PluginsManager pluginManager = PluginsLocator.getManager();
        this.plugin = pluginManager.getPlugin((Object)this);
        this.pluginProperties = this.plugin.getPluginProperties();
        this.flatnessPanel = this.getFlatnessPanel();
        this.setLayout(new BorderLayout());
        this.add(this.flatnessPanel, "North");
        this.initializeValues();
    }

    public void storeValues() throws StoreException {
        double flatness;
        try {
            flatness = Double.parseDouble(this.txtFlatness.getText());
        }
        catch (Exception e) {
            throw new StoreException(PluginServices.getText((Object)this, (String)"minimum_size_of_line_incorrect"));
        }
        GeometryManager geometryManager = GeometryLocator.getGeometryManager();
        geometryManager.setFlatness(flatness);
        this.pluginProperties.setDynValue("flatness", (Object)flatness);
        this.plugin.savePluginProperties();
    }

    public void setChangesApplied() {
        this.setChanged(false);
    }

    public String getID() {
        return ID;
    }

    public String getTitle() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        return i18nManager.getTranslation("Flatness");
    }

    public JPanel getPanel() {
        return this;
    }

    public void initializeValues() {
        Double flatness = (Double)this.pluginProperties.getDynValue("flatness");
        this.txtFlatness.setText(String.valueOf(flatness));
        GeometryManager geometryManager = GeometryLocator.getGeometryManager();
        geometryManager.setFlatness(flatness.doubleValue());
    }

    public void initializeDefaults() {
        GeometryManager geometryManager = GeometryLocator.getGeometryManager();
        this.txtFlatness.setText(String.valueOf(geometryManager.getFlatness()));
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public boolean isValueChanged() {
        return this.valChanged;
    }

    public boolean isResizeable() {
        return true;
    }

    public JPanel getFlatnessPanel() {
        if (this.flatnessPanel == null) {
            this.flatnessPanel = new JPanel();
            this.flatnessPanel.setLayout(new GridBagLayout());
            this.flatnessPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.fill = 2;
            constraints.weightx = 1.0;
            constraints.gridwidth = 2;
            constraints.insets = new Insets(0, 0, 5, 0);
            this.flatnessPanel.add((Component)this.getJTextArea(), constraints);
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 1;
            this.flatnessPanel.add((Component)new JLabel(PluginServices.getText((Object)this, (String)"densityfication") + ":"), constraints);
            this.txtFlatness = new JTextField("", 15);
            this.txtFlatness.addKeyListener(this);
            constraints = new GridBagConstraints();
            constraints.gridx = 1;
            constraints.gridy = 1;
            constraints.fill = 2;
            constraints.weightx = 1.0;
            this.flatnessPanel.add((Component)this.txtFlatness, constraints);
        }
        return this.flatnessPanel;
    }

    private JTextArea getJTextArea() {
        if (this.jTextArea == null) {
            this.jTextArea = new JTextArea();
            this.jTextArea.setBounds(new Rectangle(13, 7, 285, 57));
            this.jTextArea.setForeground(Color.black);
            this.jTextArea.setBackground(SystemColor.control);
            this.jTextArea.setRows(3);
            this.jTextArea.setWrapStyleWord(true);
            this.jTextArea.setLineWrap(true);
            this.jTextArea.setEditable(false);
            this.jTextArea.setText(PluginServices.getText((Object)this, (String)"specifies_the_minimum_size_of_the_lines_that_will_form_the_curves"));
        }
        return this.jTextArea;
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.valChanged = true;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.valChanged = true;
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

