/*
 * Decompiled with CFR 0.152.
 */
package thinletcommons;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.text.Collator;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.filechooser.FileSystemView;
import thinlet.Thinlet;
import thinletcommons.AntiAliasedThinlet;
import thinletcommons.ExtensionFileFilter;
import thinletcommons.FileFilter;
import thinletcommons.MessageDialog;
import thinletcommons.ThinletDialog;

public class FileChooser {
    private static final Logger log = Logger.getLogger("thinletcommons");
    public static final int MODE_OPEN = 0;
    public static final int MODE_SAVE = 1;
    private static final FileSystemView fsv = FileSystemView.getFileSystemView();
    private static final DecimalFormat decimalFormat = new DecimalFormat("#,##0.0");
    private static final DecimalFormat integerFormat = new DecimalFormat("###,###,###,###,###,###,###,###,###,###");
    private static final DateFormat dateFormat = DateFormat.getInstance();
    private ThinletDialog dialog;
    private Thinlet thinlet;
    private File selectedFile;
    private File showFile;
    private File currentDir;
    private int mode;
    private boolean showHiddenFiles = false;
    private int sortColumn = 0;
    private boolean sortAscending = true;
    private FileFilter[] filters;
    private FileFilter selectedFilter;
    private Object cbPath;
    private Object bUp;
    private Object bShowHidden;
    private Object tbFilelist;
    private Object tFilename;
    private Object bOk;
    private Object cbFilter;

    private static final boolean debug() {
        return log.isLoggable(Level.FINE);
    }

    public FileChooser(Frame owner, String title, int mode) {
        this.dialog = new ThinletDialog(owner, title);
        this.mode = mode;
        this.init();
    }

    public FileChooser(Dialog owner, String title, int mode) {
        this.dialog = new ThinletDialog(owner, title);
        this.mode = mode;
        this.init();
    }

    private void init() {
        this.thinlet = new AntiAliasedThinlet();
        try {
            Object panel = this.thinlet.parse("/thinletcommons/filechooser.xml", (Object)this);
            this.thinlet.add(panel);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error parsing filechooser.xml", e);
        }
        this.tbFilelist = this.thinlet.find("tbFilelist");
        this.cbPath = this.thinlet.find("cbPath");
        this.bUp = this.thinlet.find("bUp");
        this.bShowHidden = this.thinlet.find("bShowHidden");
        this.bOk = this.thinlet.find("bOk");
        this.tFilename = this.thinlet.find("tFilename");
        this.cbFilter = this.thinlet.find("cbFilter");
        this.dialog.setContent(this.thinlet);
    }

    public void show() {
        this.selectedFile = null;
        this.setupFileFilters();
        if (this.showFile == null || !this.showFile.exists()) {
            this.showFile = fsv.getHomeDirectory();
        }
        this.addFiles(this.showFile);
        this.showFile = null;
        this.thinlet.setString(this.thinlet.find("bOk"), "text", this.mode == 0 ? "Open" : "Save");
        this.thinlet.setBoolean(this.thinlet.find("bShowHidden"), "selected", this.showHiddenFiles);
        this.thinlet.requestFocus(this.thinlet.find("tbFilelist"));
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(this.dialog.getOwner());
        this.dialog.setVisible(true);
    }

    public void setSelectedFile(File file) {
        this.showFile = file;
    }

    public File getSelectedFile() {
        return this.selectedFile;
    }

    public void setShowHiddenFiles(boolean showHiddenFiles) {
        this.showHiddenFiles = showHiddenFiles;
    }

    public boolean getShowHiddenFiles() {
        return this.showHiddenFiles;
    }

    public void setFileFilters(FileFilter[] filters) {
        this.filters = filters;
    }

    public FileFilter getSelectedFileFilter() {
        return this.selectedFilter;
    }

    public void ok() {
        String filename = this.thinlet.getString(this.tFilename, "text");
        if (filename == null || filename.trim().length() == 0) {
            new MessageDialog(this.dialog, "No selection", "Please select a file.").show();
        } else {
            File file = new File(this.currentDir, filename);
            if (fsv.isTraversable(file).booleanValue()) {
                this.addFiles(file);
            } else {
                this.selectedFile = file;
                this.close();
            }
        }
    }

    public void close() {
        this.dialog.setVisible(false);
    }

    public void goUp() {
        File parent;
        if (this.currentDir != null && (parent = fsv.getParentDirectory(this.currentDir)) != null) {
            this.addFiles(parent);
        }
    }

    public void goHome() {
        File home = new File(System.getProperty("user.home"));
        this.addFiles(home);
    }

    public void toggleShowHiddenFiles(boolean showHidden) {
        this.showHiddenFiles = showHidden;
        this.addFiles(this.currentDir);
    }

    public void tableRowDoubleClicked() {
        File file = this.getSelectedTableRowFile();
        if (file != null && fsv.isTraversable(file).booleanValue()) {
            this.addFiles(file);
        } else {
            this.selectedFile = file;
            this.close();
        }
    }

    public void tableRowSelected() {
        this.thinlet.setString(this.tFilename, "text", this.getSelectedTableRowFilename());
    }

    public void tableHeaderChanged(Object colName, Object colType, Object colSize, Object colMod) {
        Object[] column = new Object[]{colName, colType, colSize, colMod};
        for (int i = 0; i < column.length; ++i) {
            String sort = this.thinlet.getChoice(column[i], "sort");
            if (sort.equals("none")) continue;
            this.sortColumn = i;
            this.sortAscending = sort.equals("ascent");
            break;
        }
        this.addFiles(this.currentDir);
    }

    public void cbPathChanged() {
        Object item = this.thinlet.getSelectedItem(this.cbPath);
        if (item != null) {
            File dir = (File)this.thinlet.getProperty(item, (Object)"file");
            this.addFiles(dir);
        }
    }

    public void cbFilterChanged(int index) {
        if (this.filters != null) {
            this.selectedFilter = this.filters[index];
            this.addFiles(this.currentDir);
        }
    }

    private void addFiles(File file) {
        this.currentDir = file;
        if (fsv.isTraversable(file).booleanValue()) {
            this.thinlet.setString(this.tFilename, "text", "");
        } else {
            this.thinlet.setString(this.tFilename, "text", fsv.getSystemDisplayName(file));
            this.currentDir = fsv.getParentDirectory(file);
        }
        File[] files = fsv.getFiles(this.currentDir, false);
        FileChooser.sort(files, this.sortColumn, this.sortAscending);
        this.thinlet.removeAll(this.tbFilelist);
        for (int i = 0; i < files.length; ++i) {
            if (!this.acceptFile(files[i])) continue;
            this.thinlet.add(this.tbFilelist, this.createTableRow(files[i]));
        }
        this.thinlet.removeAll(this.cbPath);
        File dir = this.currentDir;
        while (dir != null) {
            Object item = Thinlet.create((String)"choice");
            this.thinlet.setString(item, "text", fsv.getSystemDisplayName(dir));
            this.thinlet.putProperty(item, (Object)"file", (Object)dir);
            this.setFileIcon(item, dir);
            this.thinlet.add(this.cbPath, item, 0);
            dir = fsv.getParentDirectory(dir);
        }
        this.thinlet.setInteger(this.cbPath, "selected", this.thinlet.getCount(this.cbPath) - 1);
        this.thinlet.setBoolean(this.bUp, "enabled", fsv.getParentDirectory(this.currentDir) != null);
    }

    private boolean acceptFile(File file) {
        if (!this.showHiddenFiles && fsv.isHiddenFile(file)) {
            return false;
        }
        if (fsv.isTraversable(file).booleanValue()) {
            return true;
        }
        if (this.selectedFilter == null) {
            return true;
        }
        return this.selectedFilter.accept(file);
    }

    private void setupFileFilters() {
        this.thinlet.removeAll(this.cbFilter);
        if (this.filters == null) {
            this.addFileFilter("All files (*.*)");
            this.selectedFilter = null;
        } else {
            for (int i = 0; i < this.filters.length; ++i) {
                this.addFileFilter(this.filters[i].getDescription());
            }
            this.selectedFilter = this.filters[0];
        }
        this.thinlet.setInteger(this.cbFilter, "selected", 0);
    }

    private void addFileFilter(String description) {
        Object choice = Thinlet.create((String)"choice");
        this.thinlet.setString(choice, "text", description);
        this.thinlet.add(this.cbFilter, choice);
    }

    private Object createTableRow(File file) {
        Object row = Thinlet.create((String)"row");
        Object cellName = Thinlet.create((String)"cell");
        Object cellType = Thinlet.create((String)"cell");
        Object cellSize = Thinlet.create((String)"cell");
        Object cellMod = Thinlet.create((String)"cell");
        this.thinlet.add(row, cellName);
        this.thinlet.add(row, cellType);
        this.thinlet.add(row, cellSize);
        this.thinlet.add(row, cellMod);
        this.thinlet.setString(cellName, "text", fsv.getSystemDisplayName(file));
        this.thinlet.setString(cellType, "text", FileChooser.formatTypeString(file));
        this.thinlet.setString(cellMod, "text", FileChooser.formatDateString(file.lastModified()));
        this.thinlet.setString(cellSize, "text", fsv.isTraversable(file) != false ? "" : FileChooser.formatByteString(file.length()));
        this.thinlet.setChoice(cellSize, "alignment", "right");
        this.setFileIcon(cellName, file);
        this.thinlet.putProperty(row, (Object)"file", (Object)file);
        return row;
    }

    private static void sort(File[] files, int sortColumn, boolean sortAscending) {
        if (files.length == 0) {
            return;
        }
        File firstFile = files[0];
        if (fsv.isComputerNode(firstFile) || fsv.isDrive(firstFile) || fsv.isFileSystemRoot(firstFile) || fsv.isFloppyDrive(firstFile) || fsv.isRoot(firstFile)) {
            return;
        }
        Arrays.sort(files, new FileComparator(sortColumn, sortAscending));
    }

    private File getSelectedTableRowFile() {
        Object row = this.thinlet.getSelectedItem(this.tbFilelist);
        if (row != null) {
            return (File)this.thinlet.getProperty(row, (Object)"file");
        }
        return null;
    }

    private String getSelectedTableRowFilename() {
        File file = this.getSelectedTableRowFile();
        if (file != null) {
            return fsv.getSystemDisplayName(file);
        }
        return "";
    }

    private void setFileIcon(Object component, File file) {
        Icon icon = fsv.getSystemIcon(file);
        if (icon != null) {
            this.thinlet.setIcon(component, "icon", FileChooser.convertIconToImage(this.thinlet, icon));
        }
    }

    private static String formatTypeString(File file) {
        String desc = fsv.getSystemTypeDescription(file);
        if (desc == null || desc.length() == 0) {
            desc = fsv.isComputerNode(file) ? "Computer" : (fsv.isDrive(file) ? "Disk" : (fsv.isFloppyDrive(file) ? "Floppy" : (fsv.isTraversable(file) != false ? "Directory" : "Unknown")));
        }
        return desc;
    }

    private static String formatByteString(long size) {
        double d = size;
        int magnitude = 0;
        while (d >= 1024.0) {
            d /= 1024.0;
            ++magnitude;
        }
        switch (magnitude) {
            case 1: {
                return decimalFormat.format(d) + " KB";
            }
            case 2: {
                return decimalFormat.format(d) + " MB";
            }
            case 3: {
                return decimalFormat.format(d) + " GB";
            }
            case 4: {
                return decimalFormat.format(d) + " TB";
            }
        }
        return integerFormat.format(size);
    }

    private static String formatDateString(long date) {
        return dateFormat.format(new Date(date));
    }

    private static Image convertIconToImage(Thinlet thinlet, Icon icon) {
        BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        icon.paintIcon((Component)thinlet, image.getGraphics(), 0, 0);
        return image;
    }

    public static void main(String[] args) {
        FileChooser chooser = new FileChooser(new Frame(), "Choose File...", 0);
        if (args.length > 0) {
            chooser.setSelectedFile(new File(args[0]));
        }
        chooser.setFileFilters(new FileFilter[]{new ExtensionFileFilter("xml", "XML files (*.xml)"), new ExtensionFileFilter("java", "Java source code (*.java)"), new FileFilter(){

            @Override
            public boolean accept(File file) {
                return true;
            }

            @Override
            public String getDescription() {
                return "All files (*.*)";
            }
        }});
        chooser.show();
        System.out.println("File selected: " + chooser.getSelectedFile());
        System.exit(0);
    }

    private static class FileComparator
    implements Comparator {
        private Collator collator = Collator.getInstance();
        private int sortColumn;
        private boolean sortAscending;

        public FileComparator(int sortColumn, boolean sortAscending) {
            this.sortColumn = sortColumn;
            this.sortAscending = sortAscending;
        }

        public int compare(Object obj1, Object obj2) {
            File f1 = (File)obj1;
            File f2 = (File)obj2;
            boolean f1Traversable = fsv.isTraversable(f1);
            boolean f2Traversable = fsv.isTraversable(f2);
            if (f1Traversable && !f2Traversable) {
                return this.sortAscending ? Integer.MIN_VALUE : Integer.MAX_VALUE;
            }
            if (!f1Traversable && f2Traversable) {
                return this.sortAscending ? Integer.MAX_VALUE : Integer.MIN_VALUE;
            }
            int retval = 0;
            switch (this.sortColumn) {
                case 0: {
                    retval = this.collator.compare(fsv.getSystemDisplayName(f1), fsv.getSystemDisplayName(f2));
                    break;
                }
                case 1: {
                    retval = this.collator.compare(fsv.getSystemTypeDescription(f1), fsv.getSystemTypeDescription(f2));
                    break;
                }
                case 2: {
                    retval = f1.length() > f2.length() ? 1 : (f1.length() < f2.length() ? -1 : 0);
                    break;
                }
                case 3: {
                    retval = f1.lastModified() > f2.lastModified() ? 1 : (f1.lastModified() < f2.lastModified() ? -1 : 0);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unexpected column: " + this.sortColumn);
                }
            }
            if (retval == 0 && this.sortColumn != 0) {
                retval = this.collator.compare(fsv.getSystemDisplayName(f1), fsv.getSystemDisplayName(f2));
            }
            return this.sortAscending ? retval : -1 * retval;
        }

        @Override
        public boolean equals(Object other) {
            return false;
        }
    }
}

