/*
 * Decompiled with CFR 0.152.
 */
package thinletcommons;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import thinlet.Thinlet;
import thinletcommons.AntiAliasedThinlet;
import thinletcommons.ThinletDialog;

public class FontChooser {
    private static final Logger log = Logger.getLogger("thinletcommons");
    private ThinletDialog dialog;
    private Thinlet thinlet;
    private Font selectedFont;

    private static final boolean debug() {
        return log.isLoggable(Level.FINE);
    }

    public FontChooser(Frame owner, String title) {
        this.dialog = new ThinletDialog(owner, title);
        this.init();
    }

    public FontChooser(Dialog owner, String title) {
        this.dialog = new ThinletDialog(owner, title);
        this.init();
    }

    private void init() {
        this.thinlet = new AntiAliasedThinlet();
        try {
            Object panel = this.thinlet.parse("/thinletcommons/fontchooser.xml", (Object)this);
            this.thinlet.add(panel);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error parsing fontchooser.xml", e);
        }
        this.dialog.setContent(this.thinlet);
    }

    public void show() {
        this.dialog.setSize(new Dimension(320, 360));
        this.dialog.setLocationRelativeTo(this.dialog.getOwner());
        this.dialog.setVisible(true);
    }

    public void setSelectedFont(Font font) {
        String family = null;
        int size = 12;
        boolean isBold = false;
        boolean isItalic = false;
        if (font != null) {
            family = font.getFamily();
            size = font.getSize();
            isBold = font.isBold();
            isItalic = font.isItalic();
            this.thinlet.setFont(this.thinlet.find("preview"), "font", font);
        }
        this.thinlet.setString(this.thinlet.find("fontsize"), "text", String.valueOf(size));
        this.thinlet.setBoolean(this.thinlet.find("cb_bold"), "selected", isBold);
        this.thinlet.setBoolean(this.thinlet.find("cb_italic"), "selected", isItalic);
        Object fontlist = this.thinlet.find("fontlist");
        Object[] items = this.thinlet.getItems(fontlist);
        for (int i = 0; i < items.length; ++i) {
            String text = this.thinlet.getString(items[i], "text");
            this.thinlet.setBoolean(items[i], "selected", text.equals(family));
        }
        this.thinlet.setBoolean(this.thinlet.find("b_ok"), "enabled", font != null);
    }

    public Font getSelectedFont() {
        return this.selectedFont;
    }

    public void init(Object fontlist) {
        if (FontChooser.debug()) {
            log.fine("in init()");
        }
        Object[] names = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        Arrays.sort(names);
        for (int i = 0; i < names.length; ++i) {
            Object item = Thinlet.create((String)"item");
            this.thinlet.add(fontlist, item);
            this.thinlet.setString(item, "text", (String)names[i]);
        }
    }

    public void ok(Object fontlist, Object fontsize, Object cbBold, Object cbItalic) {
        this.selectedFont = this.getFont(fontlist, fontsize, cbBold, cbItalic);
        if (FontChooser.debug()) {
            log.fine("selected: " + this.selectedFont);
        }
        this.dialog.setVisible(false);
    }

    public void close() {
        this.dialog.setVisible(false);
    }

    public void fontChanged(Object fontlist, Object fontsize, Object cbBold, Object cbItalic, Object preview, Object bOk) {
        Font font = this.getFont(fontlist, fontsize, cbBold, cbItalic);
        if (font == null) {
            this.thinlet.setBoolean(bOk, "enabled", false);
        } else {
            this.thinlet.setBoolean(bOk, "enabled", true);
            this.thinlet.setFont(preview, "font", font);
        }
    }

    private Font getFont(Object fontlist, Object fontsize, Object cbBold, Object cbItalic) {
        Object item = this.thinlet.getSelectedItem(fontlist);
        if (item == null) {
            return null;
        }
        String family = this.thinlet.getString(item, "text");
        int size = 12;
        String fontsizeText = this.thinlet.getString(fontsize, "text");
        if (fontsizeText.length() > 0) {
            size = Integer.parseInt(fontsizeText);
        }
        boolean isBold = this.thinlet.getBoolean(cbBold, "selected");
        boolean isItalic = this.thinlet.getBoolean(cbItalic, "selected");
        Font font = new Font(family, isBold ? (isItalic ? 3 : 1) : (isItalic ? 2 : 0), size);
        return font;
    }
}

