/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.xmlschema.prov.kxml.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gvsig.xmlpull.lib.api.stream.IXmlStreamReader;
import org.gvsig.xmlschema.lib.api.som.IXSComplexTypeDefinition;
import org.gvsig.xmlschema.lib.api.som.IXSContentType;
import org.gvsig.xmlschema.lib.api.som.IXSElementDeclaration;
import org.gvsig.xmlschema.lib.api.som.IXSGroup;
import org.gvsig.xmlschema.lib.api.som.XSQName;
import org.gvsig.xmlschema.prov.kxml.model.AbstractXSTypeDefinition;
import org.gvsig.xmlschema.prov.kxml.model.XSChoice;
import org.gvsig.xmlschema.prov.kxml.model.XSComplexContent;
import org.gvsig.xmlschema.prov.kxml.model.XSElementDeclaration;
import org.gvsig.xmlschema.prov.kxml.model.XSSchema;
import org.gvsig.xmlschema.prov.kxml.model.XSSequence;

public class XSComplexTypeDefinition
extends AbstractXSTypeDefinition
implements IXSComplexTypeDefinition {
    private LinkedHashMap baseElements = null;
    private int attributesType = 0;
    private IXSContentType contentType = null;
    private IXSGroup group = null;
    private List items = new ArrayList();

    public XSComplexTypeDefinition(XSSchema schema, String namespace, String name, IXmlStreamReader xmlStreamReader) throws IOException {
        super(schema, namespace, name);
        this.qName = new XSQName(namespace, name);
        this.baseElements = new LinkedHashMap();
        this.parse(xmlStreamReader);
    }

    private void parse(IXmlStreamReader xmlStreamReader) throws IOException {
        boolean end = false;
        int currentTag = xmlStreamReader.next();
        while (!end) {
            switch (currentTag) {
                case 1: {
                    if ("complexContent".equals(xmlStreamReader.getName().getLocalPart())) {
                        this.contentType = new XSComplexContent(this.schema, xmlStreamReader);
                        this.items.add(this.contentType);
                        break;
                    }
                    if ("sequence".equals(xmlStreamReader.getName().getLocalPart())) {
                        this.group = new XSSequence(this.schema, xmlStreamReader);
                        this.items.add(this.group);
                        break;
                    }
                    if (!"choice".equals(xmlStreamReader.getName().getLocalPart())) break;
                    this.group = new XSChoice(this.schema, xmlStreamReader);
                    this.items.add(this.group);
                    break;
                }
                case 2: {
                    if (!"complexType".equals(xmlStreamReader.getName().getLocalPart())) break;
                    end = true;
                    break;
                }
            }
            if (end) continue;
            currentTag = xmlStreamReader.next();
        }
    }

    public Map getSubtypes() {
        return this.baseElements;
    }

    public void addElements(XSElementDeclaration element) {
        if (element.getQName() != null) {
            this.baseElements.put(element.getQName().getLocalPart(), element);
        }
    }

    public XSElementDeclaration getAttribute(String name) {
        return (XSElementDeclaration)this.baseElements.get(name);
    }

    public int getAttributesType() {
        return this.attributesType;
    }

    public void setAttributesType(int attributesType) {
        this.attributesType = attributesType;
    }

    public IXSElementDeclaration addElement(String name, String typeName, boolean nillable, int minOccurs, int maxOccurs) {
        return null;
    }

    public IXSElementDeclaration addElement(String name, String typeName) {
        return null;
    }

    public IXSContentType getContentType() {
        return this.contentType;
    }

    public IXSGroup getGroup() {
        return this.group;
    }

    public String getTypeName() {
        if (this.qName != null) {
            return this.qName.getLocalPart();
        }
        return null;
    }

    public short getNodeType() {
        return 0;
    }

    public String getNodeValue() {
        return null;
    }

    public boolean isComplex() {
        return true;
    }

    public Collection getItems() {
        ArrayList items = new ArrayList();
        if (this.group != null) {
            Iterator it = this.group.getItems().iterator();
            while (it.hasNext()) {
                items.add(it.next());
            }
            if (this.contentType != null) {
                if (this.contentType.getRestriction() != null) {
                    it = this.contentType.getRestriction().getGroup().getItems().iterator();
                    while (it.hasNext()) {
                        items.add(it.next());
                    }
                }
                if (this.contentType.getExtension() != null) {
                    it = this.contentType.getExtension().getGroup().getItems().iterator();
                    while (it.hasNext()) {
                        items.add(it.next());
                    }
                }
            }
        }
        return items;
    }
}

