/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.List;
import javax.units.NonSI;
import javax.units.Unit;
import org.geotools.metadata.iso.citation.CitationImpl;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.CylindricalProjection;
import org.opengis.referencing.operation.MathTransform;

public class IdrCassiniSoldner
extends MapProjection {
    private final double latitudeOfOrigin;

    protected IdrCassiniSoldner(ParameterValueGroup parameters) throws ParameterNotFoundException {
        super(parameters);
        List expected = this.getParameterDescriptors().descriptors();
        if (expected.contains(Provider.LATITUDE_OF_ORIGIN)) {
            this.latitudeOfOrigin = Math.abs(IdrCassiniSoldner.doubleValue((Collection)expected, (ParameterDescriptor)Provider.LATITUDE_OF_ORIGIN, (ParameterValueGroup)parameters));
            IdrCassiniSoldner.ensureLatitudeInRange((ParameterDescriptor)Provider.LATITUDE_OF_ORIGIN, (double)this.latitudeOfOrigin, (boolean)false);
        } else {
            this.latitudeOfOrigin = Double.NaN;
        }
    }

    public ParameterDescriptorGroup getParameterDescriptors() {
        return Provider.PARAMETERS;
    }

    public ParameterValueGroup getParameterValues() {
        ParameterValueGroup values = super.getParameterValues();
        if (!Double.isNaN(this.latitudeOfOrigin)) {
            List expected = this.getParameterDescriptors().descriptors();
            IdrCassiniSoldner.set((Collection)expected, (ParameterDescriptor)Provider.LATITUDE_OF_ORIGIN, (ParameterValueGroup)values, (double)this.latitudeOfOrigin);
        }
        return values;
    }

    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        return null;
    }

    protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        return null;
    }

    public static class Provider_Hyperbolic
    extends Provider {
        public static final ParameterDescriptor LATITUDE_OF_ORIGIN = Provider_Hyperbolic.createDescriptor((Identifier[])new NamedIdentifier[]{new NamedIdentifier(CitationImpl.OGC, "latitude_of_origin"), new NamedIdentifier(CitationImpl.EPSG, "CenterLat"), new NamedIdentifier(CitationImpl.EPSG, "Latitude of projection centre"), new NamedIdentifier(CitationImpl.GEOTIFF, "NatOriginLat"), new NamedIdentifier(CitationImpl.EPSG, "FalseOriginLat"), new NamedIdentifier(CitationImpl.EPSG, "Latitude of false origin"), new NamedIdentifier(CitationImpl.EPSG, "Latitude of natural origin"), new NamedIdentifier(CitationImpl.EPSG, "Latitude of projection centre"), new NamedIdentifier(CitationImpl.EPSG, "ProjCenterLat")}, (double)0.0, (double)-90.0, (double)90.0, (Unit)NonSI.DEGREE_ANGLE);
        static final ParameterDescriptorGroup PARAMETERS = Provider_Hyperbolic.createDescriptorGroup((Identifier[])new NamedIdentifier[]{new NamedIdentifier(CitationImpl.OGC, "Hyperbolic Cassini-Soldner"), new NamedIdentifier(CitationImpl.EPSG, "Hyperbolic_Cassini-Soldner"), new NamedIdentifier(CitationImpl.EPSG, "Cassini-Soldner (Hyperbolic)"), new NamedIdentifier(CitationImpl.EPSG, "Cassini-Soldner_(Hyperbolic)"), new NamedIdentifier((Citation)new CitationImpl((CharSequence)"IDR"), "IDR")}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN, LATITUDE_OF_ORIGIN, FALSE_EASTING, FALSE_NORTHING});

        public Provider_Hyperbolic() {
            super(PARAMETERS);
        }

        protected Class getOperationType() {
            return CylindricalProjection.class;
        }

        public MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            return new IdrCassiniSoldner(parameters);
        }
    }

    public static class Provider
    extends MapProjection.AbstractProvider {
        public static final ParameterDescriptor LATITUDE_OF_ORIGIN = Provider.createDescriptor((Identifier[])new NamedIdentifier[]{new NamedIdentifier(CitationImpl.OGC, "latitude_of_origin"), new NamedIdentifier(CitationImpl.EPSG, "CenterLat"), new NamedIdentifier(CitationImpl.EPSG, "Latitude of projection centre"), new NamedIdentifier(CitationImpl.GEOTIFF, "NatOriginLat"), new NamedIdentifier(CitationImpl.EPSG, "FalseOriginLat"), new NamedIdentifier(CitationImpl.EPSG, "Latitude of false origin"), new NamedIdentifier(CitationImpl.EPSG, "Latitude of natural origin"), new NamedIdentifier(CitationImpl.EPSG, "Latitude of projection centre"), new NamedIdentifier(CitationImpl.EPSG, "ProjCenterLat")}, (double)0.0, (double)-90.0, (double)90.0, (Unit)NonSI.DEGREE_ANGLE);
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup((Identifier[])new NamedIdentifier[]{new NamedIdentifier(CitationImpl.OGC, "Cassini_Soldner"), new NamedIdentifier(CitationImpl.EPSG, "Cassini-Soldner"), new NamedIdentifier(CitationImpl.EPSG, "Peters (approximated by Gall Orthographic)"), new NamedIdentifier(CitationImpl.EPSG, "9806"), new NamedIdentifier(CitationImpl.EPSG, "Cassini"), new NamedIdentifier((Citation)new CitationImpl((CharSequence)"IDR"), "IDR")}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN, LATITUDE_OF_ORIGIN, FALSE_EASTING, FALSE_NORTHING});

        public Provider() {
            super(PARAMETERS);
        }

        protected Provider(ParameterDescriptorGroup params) {
            super(params);
        }

        protected Class getOperationType() {
            return CylindricalProjection.class;
        }

        public MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            return new IdrCassiniSoldner(parameters);
        }
    }
}

