/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.List;
import javax.units.NonSI;
import javax.units.Unit;
import org.geotools.metadata.iso.citation.CitationImpl;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.CylindricalProjection;
import org.opengis.referencing.operation.MathTransform;

public class IdrWinkelII
extends MapProjection {
    protected final double standardParallel;

    protected IdrWinkelII(ParameterValueGroup parameters) throws ParameterNotFoundException {
        super(parameters);
        List expected = this.getParameterDescriptors().descriptors();
        if (expected.contains(Provider.STANDARD_PARALLEL)) {
            this.standardParallel = Math.abs(IdrWinkelII.doubleValue((Collection)expected, (ParameterDescriptor)Provider.STANDARD_PARALLEL, (ParameterValueGroup)parameters));
            IdrWinkelII.ensureLatitudeInRange((ParameterDescriptor)Provider.STANDARD_PARALLEL, (double)this.standardParallel, (boolean)false);
        } else {
            this.standardParallel = Double.NaN;
        }
    }

    public ParameterDescriptorGroup getParameterDescriptors() {
        return Provider.PARAMETERS;
    }

    public ParameterValueGroup getParameterValues() {
        List expected = this.getParameterDescriptors().descriptors();
        ParameterValueGroup values = super.getParameterValues();
        IdrWinkelII.set((Collection)expected, (ParameterDescriptor)Provider.STANDARD_PARALLEL, (ParameterValueGroup)values, (double)this.standardParallel);
        return values;
    }

    protected Point2D transformNormalized(double lambda, double phi, Point2D ptDst) throws ProjectionException {
        return null;
    }

    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        return null;
    }

    public static class Provider
    extends MapProjection.AbstractProvider {
        public static final ParameterDescriptor STANDARD_PARALLEL = Provider.createDescriptor((Identifier[])new NamedIdentifier[]{new NamedIdentifier(CitationImpl.OGC, "standard_parallel_1"), new NamedIdentifier(CitationImpl.EPSG, "Latitude of 1st standard parallel"), new NamedIdentifier(CitationImpl.GEOTIFF, "StdParallel1")}, (double)0.0, (double)-90.0, (double)90.0, (Unit)NonSI.DEGREE_ANGLE);
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup((Identifier[])new NamedIdentifier[]{new NamedIdentifier(CitationImpl.OGC, "Winkel_II"), new NamedIdentifier(CitationImpl.GEOTIFF, "Winkel II"), new NamedIdentifier(CitationImpl.EPSG, "Winkel II"), new NamedIdentifier((Citation)new CitationImpl((CharSequence)"IDR"), "IDR")}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN, STANDARD_PARALLEL, FALSE_EASTING, FALSE_NORTHING});

        public Provider() {
            super(PARAMETERS);
        }

        protected Class getOperationType() {
            return CylindricalProjection.class;
        }

        public MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            return new IdrWinkelII(parameters);
        }
    }
}

