/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.crs;

import java.util.Arrays;
import java.util.Iterator;
import org.cresques.ProjectionLibrary;
import org.geotools.factory.FactoryRegistry;
import org.geotools.referencing.operation.MathTransformProvider;
import org.gvsig.crs.CrsFactory;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.tools.library.AbstractLibrary;
import org.gvsig.tools.library.LibraryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRSLibrary
extends AbstractLibrary {
    private static final Logger logger = LoggerFactory.getLogger(JCRSLibrary.class);

    public void doRegistration() {
        this.registerAsImplementationOf(ProjectionLibrary.class, 10);
    }

    protected void doInitialize() throws LibraryException {
        this.initializeGeotoolsProviders();
        CRSFactory.registerCRSFactory(new CrsFactory());
    }

    protected void doPostInitialize() throws LibraryException {
    }

    private void initializeGeotoolsProviders() {
        Class[] categories = new Class[]{MathTransformProvider.class};
        FactoryRegistry registry = new FactoryRegistry(Arrays.asList(categories));
        Iterator providers = registry.getServiceProviders(MathTransformProvider.class);
        Iterator providers2 = null;
        MathTransformProvider provider = null;
        MathTransformProvider provider2 = null;
        while (providers.hasNext()) {
            provider = (MathTransformProvider)providers.next();
            if (!provider.nameMatches("IDR")) continue;
            providers2 = registry.getServiceProviders(MathTransformProvider.class);
            while (providers2.hasNext()) {
                provider2 = (MathTransformProvider)providers2.next();
                if (!provider2.nameMatches(provider.getName().toString()) || provider2.nameMatches("IDR")) continue;
                registry.deregisterServiceProvider((Object)provider2, categories[0]);
            }
        }
        logger.debug("Dump of CRS MathTransformProviders");
        providers = registry.getServiceProviders(MathTransformProvider.class);
        while (providers.hasNext()) {
            provider = (MathTransformProvider)providers.next();
            logger.debug(provider.toString());
        }
    }
}

