/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.crs.proj;

import org.gdal.osr.CoordinateTransformation;
import org.gdal.osr.SpatialReference;
import org.gvsig.crs.CrsException;
import org.gvsig.crs.proj.CrsProjException;
import org.gvsig.crs.proj.OperationCrsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrsProj {
    private static Logger logger = LoggerFactory.getLogger(CrsProj.class);
    private SpatialReference spatialReference;
    private String _strCrs;

    public CrsProj(String proj4String) {
        try {
            if (proj4String == null) {
                logger.error("Can't create CRS from 'null' value.");
                return;
            }
            this.createCrs(proj4String);
        }
        catch (CrsProjException e) {
            logger.error("Can't create CRS from '" + proj4String + "'.", (Throwable)e);
        }
    }

    private void showInfo() {
        logger.info("=========================================================================");
        logger.info("_strCrs = " + this._strCrs);
        logger.info("IsProjected = " + this.spatialReference.IsProjected());
        logger.info("IsGeographic = " + this.spatialReference.IsGeographic());
        logger.info("IsGeocentric = " + this.spatialReference.IsGeocentric());
        logger.info("IsVertical = " + this.spatialReference.IsVertical());
        logger.info("SemiMajor = " + this.spatialReference.GetSemiMajor());
        logger.info("SemiMinor = " + this.spatialReference.GetSemiMinor());
        logger.info("InvFlattening = " + this.spatialReference.GetInvFlattening());
        logger.info("PROJCS = " + this.spatialReference.GetAttrValue("PROJCS"));
        logger.info("GEOGCS = " + this.spatialReference.GetAttrValue("GEOGCS"));
        logger.info("DATUM = " + this.spatialReference.GetAttrValue("DATUM"));
        logger.info("SPHEROID = " + this.spatialReference.GetAttrValue("SPHEROID"));
        logger.info("PROJECTION = " + this.spatialReference.GetAttrValue("PROJECTION"));
        logger.info("UNIT = " + this.spatialReference.GetAttrValue("UNIT"));
        logger.info("conversion a metros = " + this.spatialReference.GetAttrValue("UNIT", 1));
        logger.info("Linear unit name = " + this.spatialReference.GetLinearUnitsName());
        logger.info("linear units = " + this.spatialReference.GetLinearUnits());
        logger.info("Angular units = " + this.spatialReference.GetAngularUnits());
        logger.info("TOWGS84 = " + this.spatialReference.GetAttrValue("TOWGS84"));
        logger.info("TOWGS84 = " + this.spatialReference.GetAttrValue("TOWGS84", 1));
        logger.info("TOWGS84 = " + this.spatialReference.GetAttrValue("TOWGS84", 2));
        logger.info("SRS_PP_LATITUDE_OF_ORIGIN = " + this.spatialReference.GetAttrValue("SRS_PP_LATITUDE_OF_ORIGIN"));
        logger.info("=========================================================================");
    }

    protected void createCrs(String strCrs) throws CrsProjException {
        this.spatialReference = new SpatialReference();
        int errNo = 0;
        try {
            errNo = this.spatialReference.ImportFromProj4(strCrs);
        }
        catch (Exception e) {
            throw new CrsProjException("Error creating CRS", e);
        }
        if (errNo != 0) {
            throw new CrsProjException("Error creating CRS. Erro code = " + errNo);
        }
        try {
            errNo = this.spatialReference.Fixup();
        }
        catch (Exception e) {
            throw new CrsProjException("Error fixing up CRS", e);
        }
        if (errNo != 0) {
            throw new CrsProjException("Error creating CRS. Erro code = " + errNo);
        }
        this._strCrs = strCrs;
    }

    public void reloadCrs() throws CrsException {
    }

    public void changeStrCrs(String code) {
        this._strCrs = this._strCrs + code;
    }

    public boolean isLatlong() {
        return this.spatialReference.IsGeographic() != 0;
    }

    public boolean isGeocent() {
        return this.spatialReference.IsGeocentric() != 0;
    }

    public String getUnits() {
        return this.spatialReference.GetAttrValue("UNIT", 0);
    }

    public double getConversionFactorToMeters() {
        return Double.parseDouble(this.spatialReference.GetAttrValue("UNIT", 1));
    }

    public String getStr() {
        return this.spatialReference.ExportToProj4();
    }

    public long getPtr() {
        return SpatialReference.getCPtr((SpatialReference)this.spatialReference);
    }

    public SpatialReference getSpatialReference() {
        return this.spatialReference;
    }

    public static int operate(double[] firstCoord, double[] secondCoord, double[] thirdCoord, CrsProj srcCrs, CrsProj destCrs) throws OperationCrsException {
        try {
            logger.warn("CrsProj.operate: No deber\u00eda pasar por aqu\u00ed. (Excepcion provocada para ver de d\u00f3nde viene).");
            throw new Exception();
        }
        catch (Exception e) {
            e.printStackTrace();
            long srcCrsPtr = srcCrs.getPtr();
            long destCrsPtr = destCrs.getPtr();
            if (srcCrsPtr == 0L || destCrsPtr == 0L) {
                throw new OperationCrsException(srcCrs, destCrs, "");
            }
            int points = firstCoord.length;
            if (secondCoord.length > points) {
                points = secondCoord.length;
            }
            if (thirdCoord.length > points) {
                points = thirdCoord.length;
            }
            CoordinateTransformation ct = null;
            try {
                ct = CoordinateTransformation.CreateCoordinateTransformation((SpatialReference)srcCrs.spatialReference, (SpatialReference)destCrs.spatialReference);
            }
            catch (Exception e2) {
                throw new OperationCrsException(srcCrs, destCrs, "Can't create transformation");
            }
            try {
                if (ct != null) {
                    for (int i = 0; i < points; ++i) {
                        double[] resultCoords = ct.TransformPoint(firstCoord[i], secondCoord[i], thirdCoord[i]);
                        firstCoord[i] = resultCoords[0];
                        secondCoord[i] = resultCoords[1];
                        thirdCoord[i] = resultCoords[2];
                    }
                }
            }
            catch (Exception e3) {
                throw new OperationCrsException(srcCrs, destCrs, "Can't transform points");
            }
            return 0;
        }
    }

    public static int compareDatums(CrsProj crs1, CrsProj crs2) {
        long crs1Ptr = crs1.getPtr();
        long crs2Ptr = crs2.getPtr();
        if (crs1Ptr == 0L || crs2Ptr == 0L) {
            throw new IllegalArgumentException("Coordinate compare error: " + crs1.getStr() + " to " + crs2.getStr());
        }
        return Long.valueOf(crs1Ptr).compareTo(crs2Ptr);
    }
}

