/*
 * Decompiled with CFR 0.152.
 */
package org.cresques.impl.geo;

import geojava.Mutil;
import geojava.SexaAngle;
import java.awt.geom.Point2D;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.cresques.geo.Projected;
import org.cresques.impl.geo.Projection;

public class GeoPoint
extends Point2D
implements Projected {
    public static int decimales = 4;
    IProjection proj = null;
    public SexaAngle Longitude;
    public SexaAngle Latitude;
    public double h;

    public GeoPoint(SexaAngle sexaangle, SexaAngle sexaangle1, double d) {
        this.Longitude = sexaangle;
        this.Latitude = sexaangle1;
        this.h = d;
    }

    public GeoPoint() {
        this.Longitude = new SexaAngle();
        this.Latitude = new SexaAngle();
        this.h = 0.0;
    }

    public GeoPoint(double x, double y) {
        this.setLocation(x, y);
        this.h = 0.0;
    }

    public GeoPoint(Projection proj, double x, double y) {
        this.setLocation(x, y);
        this.h = 0.0;
        this.proj = proj;
    }

    public GeoPoint(Point2D pt) {
        this.setLocation(pt.getX(), pt.getY());
        this.h = 0.0;
    }

    public GeoPoint(Projection proj, Point2D pt) {
        this.setLocation(pt.getX(), pt.getY());
        this.h = 0.0;
        this.proj = proj;
    }

    public IProjection getProjection() {
        return this.proj;
    }

    public void reProject(ICoordTrans rp) {
    }

    @Override
    public double getX() {
        return this.Longitude.ToDecimal();
    }

    @Override
    public double getY() {
        return this.Latitude.ToDecimal();
    }

    @Override
    public void setLocation(double x, double y) {
        this.Longitude = SexaAngle.fromDecimal((double)x);
        this.Latitude = SexaAngle.fromDecimal((double)y);
    }

    public String toString() {
        String str = "";
        String s = String.valueOf(this.Longitude.Deg);
        String s1 = String.valueOf(this.Longitude.Min);
        String s2 = String.valueOf(Mutil.double2String((double)this.Longitude.Sec, (int)decimales));
        SexaAngle sexaangle = new SexaAngle(s, s1, s2);
        sexaangle.Normalize();
        str = str + String.valueOf(sexaangle.Deg) + "\u00ba";
        str = str + String.valueOf(sexaangle.Min) + "'";
        str = str + Mutil.double2String((double)sexaangle.Sec, (int)decimales) + "\"";
        str = str + " ";
        s = String.valueOf(this.Latitude.Deg);
        s1 = String.valueOf(this.Latitude.Min);
        s2 = String.valueOf(Mutil.double2String((double)this.Latitude.Sec, (int)decimales));
        sexaangle = new SexaAngle(s, s1, s2);
        sexaangle.Normalize();
        str = str + String.valueOf(sexaangle.Deg) + "\u00ba";
        str = str + String.valueOf(sexaangle.Min) + "'";
        str = str + Mutil.double2String((double)sexaangle.Sec, (int)decimales) + "\"";
        return str;
    }
}

