/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gpe.prov.kml.parser;

import java.io.IOException;
import org.gvsig.gpe.lib.api.parser.IAttributesIterator;
import org.gvsig.gpe.prov.kml.exceptions.KmlHeaderParseException;
import org.gvsig.gpe.prov.kml.parser.profiles.IBindingProfile;
import org.gvsig.gpe.prov.kml.parser.v21.features.PlaceMarketBinding;
import org.gvsig.gpe.prov.kml.utils.Kml2_1_Tags;
import org.gvsig.gpe.prov.xml.parser.GPEXmlParser;
import org.gvsig.gpe.prov.xml.utils.QNameComparator;
import org.gvsig.gpe.prov.xml.utils.XMLAttributesIterator;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.xmlpull.lib.api.stream.IQName;
import org.gvsig.xmlpull.lib.api.stream.XmlStreamException;

public abstract class GPEDeafultKmlParser
extends GPEXmlParser {
    private static final String DEFAULT_CRS = "EPSG:4326";
    private IBindingProfile profile = null;
    private Object layer = null;
    protected QNameComparator qNameComparator = null;

    public IBindingProfile getProfile() {
        return this.profile;
    }

    public QNameComparator getQNameComparator() {
        return this.qNameComparator;
    }

    public void setQNameComparator(QNameComparator qNameComparator) {
        this.qNameComparator = qNameComparator;
    }

    public void setProfile(IBindingProfile profile) {
        this.profile = profile;
    }

    protected void initParse() {
        this.layer = null;
        try {
            String namespace = this.getProfile().getHeaderBinding().parse(this.getParser(), this);
            boolean endFeature = false;
            IQName tag = this.getParser().getName();
            int currentTag = this.getParser().getEventType();
            XMLAttributesIterator attributesIterator = new XMLAttributesIterator(this.getParser());
            boolean hasOnlyPlacemarks = false;
            while (!endFeature) {
                switch (currentTag) {
                    case 1: {
                        if (this.getQNameComparator().equals(tag, Kml2_1_Tags.DOCUMENT)) {
                            this.layer = this.getProfile().getDocumentBinding().parse(this.getParser(), this);
                            break;
                        }
                        if (this.qNameComparator.equals(tag, Kml2_1_Tags.FOLDER)) {
                            this.layer = this.getProfile().getFolderBinding().parse(this.getParser(), this, null);
                            break;
                        }
                        if (!this.getQNameComparator().equals(tag, Kml2_1_Tags.PLACEMARK)) break;
                        if (this.layer == null) {
                            this.layer = this.getContentHandler().startLayer(null, "http://earth.google.com/kml/2.1", null, null, DEFAULT_CRS, (IAttributesIterator)attributesIterator, null, null);
                            hasOnlyPlacemarks = true;
                        }
                        this.getProfile().getPlaceMarketBinding();
                        Object feature = PlaceMarketBinding.parse(this.getParser(), this);
                        this.getContentHandler().addFeatureToLayer(feature, this.layer);
                        break;
                    }
                    case 8: {
                        endFeature = true;
                    }
                }
                if (endFeature) continue;
                currentTag = this.getParser().next();
                tag = this.getParser().getName();
            }
            if (this.layer != null && hasOnlyPlacemarks) {
                this.getContentHandler().endLayer(this.layer);
            }
        }
        catch (KmlHeaderParseException e) {
            this.getErrorHandler().addError((Throwable)((Object)e));
        }
        catch (BaseException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
        catch (XmlStreamException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
    }

    public String getProjection() {
        return DEFAULT_CRS;
    }
}

