/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.csv;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.exception.PerformEditingException;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.fmap.dal.store.csv.CSVStoreParameters;
import org.gvsig.fmap.dal.store.csv.simplereaders.CSVReaderSuperCSV;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.SpatialIndex;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.Coercion;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.Tags;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.supercsv.io.CsvListWriter;
import org.supercsv.prefs.CsvPreference;

public class CSVFeatureWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CSVFeatureWriter.class);
    private Map<String, Envelope> envelopes = null;
    private boolean calculate_envelope = false;
    private CsvListWriter listWriter = null;
    private CsvPreference csvpreferences = null;
    private Writer writer = null;
    private FeatureType ftype;
    private File file;
    private String[] values;
    private FeatureAttributeDescriptor[] descriptors;
    private Coercion convert = null;
    private int errorcounts = 0;
    private Throwable lasterror = null;
    private CSVStoreParameters storeParameters;
    private String charset = null;
    private boolean includeMetadataInHeader;
    private Locale locale;
    private GeometryManager geometryManager;
    private Map<String, SpatialIndex> spatialIndexes;

    public void initialize(CSVStoreParameters storeParameters, File file, FeatureType ftype, CsvPreference csvpreferences) {
        this.initialize(storeParameters, file, ftype, csvpreferences, null);
    }

    public void initialize(CSVStoreParameters storeParameters, File file, FeatureType ftype, CsvPreference csvpreferences, Map<String, SpatialIndex> spatialIndex) {
        this.file = file;
        this.ftype = ftype;
        this.storeParameters = storeParameters;
        this.csvpreferences = csvpreferences == null ? CSVStoreParameters.getPredefinedCSVPreferences((DynObject)storeParameters) : csvpreferences;
        if (this.ftype != null) {
            this.descriptors = this.ftype.getAttributeDescriptors();
            if (ftype.getDefaultGeometryAttributeName() != null) {
                this.calculate_envelope = true;
            }
        }
        this.convert = ToolsLocator.getDataTypesManager().getCoercion(8);
        this.errorcounts = 0;
        this.charset = CSVStoreParameters.getCharset((DynObject)storeParameters);
        this.includeMetadataInHeader = CSVStoreParameters.getIncludeMetadataInHeader((DynObject)storeParameters);
        this.locale = CSVStoreParameters.getLocale((DynObject)storeParameters);
        this.geometryManager = GeometryLocator.getGeometryManager();
        this.spatialIndexes = spatialIndex;
        if (spatialIndex != null) {
            for (SpatialIndex index : spatialIndex.values()) {
                index.removeAll();
            }
        }
    }

    public void beginAppend() {
        try {
            FileOutputStream fos = new FileOutputStream(this.file, true);
            this.writer = this.charset != null ? new OutputStreamWriter((OutputStream)fos, this.charset) : new OutputStreamWriter(fos);
            this.listWriter = new CsvListWriter(this.writer, this.csvpreferences);
            if (this.ftype != null) {
                this.descriptors = this.ftype.getAttributeDescriptors();
                int n = 0;
                for (FeatureAttributeDescriptor descriptor : this.descriptors) {
                    if (descriptor.getEvaluator() != null) continue;
                    ++n;
                }
                this.values = new String[n];
            }
        }
        catch (IOException e) {
            LOGGER.warn("Can't open file for write (" + this.file.getAbsolutePath() + ").", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void begin() {
        Tags tags;
        try {
            FileOutputStream fos = new FileOutputStream(this.file, false);
            this.writer = this.charset != null ? new OutputStreamWriter((OutputStream)fos, this.charset) : new OutputStreamWriter(fos);
        }
        catch (IOException e) {
            LOGGER.warn("Can't open file for write (" + this.file.getAbsolutePath() + ").", (Throwable)e);
            throw new RuntimeException(e);
        }
        this.listWriter = new CsvListWriter(this.writer, this.csvpreferences);
        int n = 0;
        for (FeatureAttributeDescriptor descriptor : this.descriptors) {
            if (descriptor.isComputed()) continue;
            ++n;
        }
        String[] header = new String[n];
        this.values = new String[n];
        n = 0;
        for (FeatureAttributeDescriptor descriptor : this.descriptors) {
            if (descriptor.isComputed()) continue;
            header[n++] = this.includeMetadataInHeader ? (String)descriptor.get("all") : descriptor.getName();
        }
        if (this.includeMetadataInHeader && (tags = this.ftype.getTags()) != null && !tags.isEmpty()) {
            String s = header[0];
            for (String tagName : tags) {
                String value = tags.getString(tagName, null);
                if (value == null) continue;
                String sep = "/";
                if (value.contains(sep)) {
                    value = StringEscapeUtils.escapeHtml3((String)value);
                    value = StringUtils.replace((String)value, (String)sep, (String)("&#" + sep.charAt(0) + ";"));
                    s = s + sep + "typetagesc" + sep + "html" + sep + tagName + "=" + value;
                    continue;
                }
                s = s + sep + "typetag" + sep + tagName + "=" + value;
            }
            header[0] = s;
        }
        try {
            this.listWriter.writeHeader(header);
        }
        catch (Exception e) {
            LOGGER.warn("Can't write header '" + ArrayUtils.toString((Object)header) + "' file for write (" + this.file.getAbsolutePath() + ").", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void add(FeatureProvider feature) {
        block20: {
            if (this.calculate_envelope) {
                if (this.envelopes == null) {
                    this.envelopes = new HashMap<String, Envelope>();
                }
                for (FeatureAttributeDescriptor featureAttributeDescriptor : this.ftype) {
                    if (featureAttributeDescriptor.getType() != 66) continue;
                    String geomName = featureAttributeDescriptor.getName();
                    Geometry geom = (Geometry)feature.get(geomName);
                    Envelope env = this.envelopes.get(geomName);
                    if (env == null) {
                        if (geom == null) {
                            this.envelopes.put(geomName, null);
                            continue;
                        }
                        try {
                            this.envelopes.put(geomName, (Envelope)geom.getEnvelope().clone());
                        }
                        catch (CloneNotSupportedException e) {
                            LOGGER.warn("Este error no deberia pasar, siempre se puede hacer un clone de un envelope.", (Throwable)e);
                        }
                        continue;
                    }
                    if (geom == null) continue;
                    env.add(geom.getEnvelope());
                }
            }
            if (this.spatialIndexes == null) {
                this.spatialIndexes = new HashMap<String, SpatialIndex>();
            }
            for (int i = 0; i < this.descriptors.length; ++i) {
                block19: {
                    FeatureAttributeDescriptor descriptor = this.descriptors[i];
                    if (descriptor.getEvaluator() != null) continue;
                    Object value = feature.get(i);
                    try {
                        if (descriptor.getType() == 66) {
                            String geomName = descriptor.getName();
                            Geometry geom = (Geometry)value;
                            if (geom != null) {
                                SpatialIndex index = this.spatialIndexes.get(geomName);
                                if (index != null) {
                                    index.insert(geom, feature.getOID());
                                }
                                this.values[i] = StringUtils.equalsIgnoreCase((CharSequence)"WKT", (CharSequence)CSVStoreParameters.getGeometryFormat((DynObject)this.storeParameters)) ? geom.convertToWKT() : geom.convertToHexWKB();
                            }
                        } else {
                            this.values[i] = (String)this.convert.coerce(value, descriptor.getCoercionContext());
                        }
                    }
                    catch (GeometryOperationException | GeometryOperationNotSupportedException | CoercionException e) {
                        try {
                            this.values[i] = value.toString();
                        }
                        catch (Exception ex) {
                            this.values[i] = "";
                        }
                        if (this.errorcounts++ > 10) break block19;
                        this.lasterror = e;
                        LOGGER.warn("Can't convert value of field " + i + " to string in CVS file '" + this.file.getAbsolutePath() + "'.", e);
                        if (this.errorcounts != 10) break block19;
                        LOGGER.warn("Too many error writing CVS file '" + this.file.getAbsolutePath() + "', don't output more.");
                    }
                }
                this.values[i] = CSVReaderSuperCSV.escapeCRLF(this.values[i]);
            }
            try {
                this.listWriter.write(this.values);
            }
            catch (IOException e) {
                if (this.errorcounts++ > 10) break block20;
                this.lasterror = e;
                LOGGER.warn("Can't write values to CVS file '" + this.file.getAbsolutePath() + "'.", (Throwable)e);
                if (this.errorcounts != 10) break block20;
                LOGGER.warn("Too many error writing CVS file '" + this.file.getAbsolutePath() + "', don't output more.");
            }
        }
    }

    public void end() throws PerformEditingException {
        if (this.errorcounts > 0) {
            throw new PerformEditingException(this.file.getAbsolutePath(), this.lasterror);
        }
        if (this.listWriter != null) {
            try {
                this.listWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.listWriter = null;
        }
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.writer = null;
        }
        File indexFile = null;
        try {
            indexFile = CSVReaderSuperCSV.getIndexFile(this.file);
            if (indexFile != null) {
                Files.deleteIfExists(indexFile.toPath());
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Can't delete index file '" + (indexFile == null ? "null" : indexFile.getAbsolutePath()) + "'", (Throwable)ex);
        }
        if (this.spatialIndexes != null) {
            for (SpatialIndex index : this.spatialIndexes.values()) {
                index.flush();
            }
        }
    }

    public Map<String, Envelope> getEnvelopes() {
        return this.envelopes;
    }
}

