/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.csv.virtualrows;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.AbstractList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.gvsig.fmap.dal.store.csv.virtualrows.CSVList;
import org.gvsig.fmap.dal.store.simplereader.virtualrows.RandomAccessFileIndex;
import org.gvsig.fmap.dal.store.simplereader.virtualrows.RandomAccessFileReader;

public abstract class AbstractCSVList
extends AbstractList<List<String>>
implements CSVList {
    protected final RandomAccessFileReader reader;
    protected final RandomAccessFileIndex index;
    protected int skipLines;

    public AbstractCSVList(File text, File index, Charset charset) throws IOException {
        this.reader = new RandomAccessFileReader(text, charset);
        this.index = new RandomAccessFileIndex(index);
        this.skipLines = 0;
    }

    public AbstractCSVList(RandomAccessFileReader reader, RandomAccessFileIndex index) throws IOException {
        this.reader = reader;
        this.index = index;
        this.skipLines = 0;
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((Reader)this.reader);
        IOUtils.closeQuietly((Closeable)this.index);
    }

    @Override
    public List<String> get(int index) {
        try {
            long pos = this.index.get(index + this.skipLines);
            this.reader.seek(pos);
            return this.nextRecord();
        }
        catch (IOException ex) {
            throw new RuntimeException("Can't access to " + index + " element.", ex);
        }
    }

    @Override
    public int size() {
        return this.index.size() - this.skipLines;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public long size64() {
        return this.index.size64() - (long)this.skipLines;
    }

    public List<String> get64(long index) {
        try {
            long pos = this.index.get64(index + (long)this.skipLines);
            this.reader.seek(pos);
            return this.nextRecord();
        }
        catch (IOException ex) {
            throw new RuntimeException("Can't access to " + index + " element.", ex);
        }
    }

    protected abstract List<String> nextRecord() throws IOException;
}

