/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.selectiontools.app.extension;

import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.gui.IView;
import org.gvsig.app.project.documents.view.toolListeners.StatusBarListener;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.tools.Behavior.Behavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.MouseMovementBehavior;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PointListener;
import org.gvsig.selectiontools.app.extension.tools.CircleSelectListener;
import org.gvsig.selectiontools.app.extension.tools.behavior.CircleSelectionBehavior;

public class SelectByCircleExtension
extends Extension {
    public static final String CIRCLE_SELECTION_TOOL_NAME = "circleSelection";

    public void initialize() {
        IconThemeHelper.registerIcon((String)"action", (String)"selection-select-by-circle", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"cursor", (String)"cursor-select-by-circle", (Object)((Object)this));
    }

    public void execute(String actionCommand) {
        ApplicationManager application = ApplicationLocator.getManager();
        IView view = (IView)application.getActiveComponent(ViewDocument.class);
        if (view == null) {
            return;
        }
        if (actionCommand.equals("SELCIRCLE")) {
            MapControl mc = view.getMapControl();
            if (!mc.getNamesMapTools().containsKey(CIRCLE_SELECTION_TOOL_NAME)) {
                CircleSelectListener circleSelListener = new CircleSelectListener(mc);
                mc.addBehavior(CIRCLE_SELECTION_TOOL_NAME, new Behavior[]{new CircleSelectionBehavior(circleSelListener), new MouseMovementBehavior((PointListener)new StatusBarListener(mc))});
            }
            mc.setTool(CIRCLE_SELECTION_TOOL_NAME);
        }
    }

    public boolean isVisible() {
        ApplicationManager application = ApplicationLocator.getManager();
        IView view = (IView)application.getActiveComponent(ViewDocument.class);
        if (view == null) {
            return false;
        }
        ViewDocument document = view.getViewDocument();
        MapContext mapa = document.getMapContext();
        return mapa.getLayers().getLayersCount() > 0;
    }

    public boolean isEnabled() {
        ApplicationManager application = ApplicationLocator.getManager();
        IView view = (IView)application.getActiveComponent(ViewDocument.class);
        if (view == null) {
            return false;
        }
        ViewDocument document = view.getViewDocument();
        return document.getMapContext().hasActiveVectorLayers();
    }
}

