/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.selectiontools.app.extension.tools;

import com.vividsolutions.jts.geom.TopologyException;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.GeneralPathX;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Events.MeasureEvent;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PolylineListener;

public class PolyLineSelectionListener
implements PolylineListener {
    private Cursor cur = null;
    private MapControl mapCtrl;

    public PolyLineSelectionListener(MapControl mc) {
        this.mapCtrl = mc;
    }

    public Cursor getCursor() {
        if (this.cur == null) {
            this.cur = Toolkit.getDefaultToolkit().createCustomCursor(this.getImageCursor(), new Point(16, 16), "");
        }
        return this.cur;
    }

    public boolean cancelDrawing() {
        return false;
    }

    public void points(MeasureEvent event) throws BehaviorException {
    }

    public void pointFixed(MeasureEvent event) throws BehaviorException {
    }

    public void polylineFinished(MeasureEvent event) throws BehaviorException {
        try {
            GeneralPathX gp = event.getGP();
            GeometryManager manager = GeometryLocator.getGeometryManager();
            Line geom = null;
            Line line = null;
            try {
                line = (Line)manager.create(18, 0);
                line.setGeneralPath(gp);
                geom = line;
            }
            catch (CreateGeometryException e1) {
                NotificationManager.showMessageError((String)PluginServices.getText(null, (String)"Failed_creating_geometry"), (Exception)((Object)e1));
            }
            if (geom == null) {
                return;
            }
            FLayer[] actives = this.mapCtrl.getMapContext().getLayers().getActives();
            for (int i = 0; i < actives.length; ++i) {
                if (!(actives[i] instanceof FLyrVect)) continue;
                FLyrVect lyrVect = (FLyrVect)actives[i];
                FeatureSet newSelection = null;
                newSelection = lyrVect.queryByGeometry((Geometry)geom, lyrVect.getFeatureStore().getDefaultFeatureType());
                if (event.getEvent().isControlDown()) {
                    ((FeatureSelection)lyrVect.getDataStore().getSelection()).select(newSelection);
                    continue;
                }
                lyrVect.getFeatureStore().setSelection(newSelection);
            }
        }
        catch (TopologyException topEx) {
            NotificationManager.showMessageError((String)PluginServices.getText(null, (String)"Failed_selecting_geometries_by_polyline_topology_exception_explanation"), (Exception)((Object)topEx));
        }
        catch (Exception ex) {
            NotificationManager.showMessageError((String)PluginServices.getText(null, (String)"Failed_selecting_geometries"), (Exception)ex);
        }
    }

    public Image getImageCursor() {
        return IconThemeHelper.getImage((String)"cursor-select-by-polyline");
    }
}

