/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.scripting.swing.impl;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.commons.io.FilenameUtils;
import org.gvsig.scripting.ScriptingExternalFile;
import org.gvsig.scripting.ScriptingFolder;
import org.gvsig.scripting.ScriptingManager;
import org.gvsig.scripting.ScriptingUnit;
import org.gvsig.scripting.swing.api.JScriptingBrowser;
import org.gvsig.scripting.swing.api.ScriptingUIManager;
import org.gvsig.tools.swing.api.ActionListenerSupport;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJScriptingBrowser
extends JPanel
implements JScriptingBrowser {
    private static final Logger logger = LoggerFactory.getLogger(DefaultJScriptingBrowser.class);
    private static final long serialVersionUID = 3140698910497806258L;
    protected ScriptingUIManager uimanager;
    protected ScriptingManager manager;
    protected TreeModel treeModel;
    protected JTree tree;
    protected ScriptingFolder root;
    protected ActionListenerSupport actionlisteners = ToolsSwingLocator.getToolsSwingManager().createActionListenerSupport();
    private final boolean foldersOnly;

    public DefaultJScriptingBrowser(ScriptingUIManager uimanager, ScriptingFolder root) {
        this(uimanager, root, false);
    }

    public DefaultJScriptingBrowser(ScriptingUIManager uimanager, ScriptingFolder root, boolean foldersOnly) {
        super(new GridLayout(1, 2));
        this.foldersOnly = foldersOnly;
        this.uimanager = uimanager;
        this.manager = uimanager.getManager();
        this.root = root;
        this.makeUI();
    }

    public JComponent asJComponent() {
        return this;
    }

    public void refresh() {
        Enumeration<TreePath> x = this.tree.getExpandedDescendants(new TreePath(this.treeModel.getRoot()));
        ((ScriptingFolderTreeModel)this.treeModel).reload();
        if (x != null) {
            while (x.hasMoreElements()) {
                try {
                    TreePath treePath = x.nextElement();
                    this.tree.expandPath(treePath);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public ScriptingManager getManager() {
        return this.manager;
    }

    public ScriptingFolder getRoot() {
        return this.root;
    }

    public void addActionListener(ActionListener actionlistener) {
        this.actionlisteners.addActionListener(actionlistener);
    }

    private void makeUI() {
        this.treeModel = this.foldersOnly ? new ScriptingFolderTreeModelFoldersOnly(this.root) : new ScriptingFolderTreeModel(this.root);
        this.tree = new JTree(this.treeModel);
        this.tree.setCellRenderer(new IconCellRenderer());
        this.tree.setEditable(false);
        this.tree.setShowsRootHandles(true);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                JTree tree = (JTree)e.getSource();
                if (!tree.isSelectionEmpty()) {
                    DefaultJScriptingBrowser.this.fireSelectAction(tree.getSelectionPath());
                }
            }
        });
        this.tree.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                JTree tree;
                if (arg0.getClickCount() == 2 && !(tree = (JTree)arg0.getSource()).isSelectionEmpty()) {
                    DefaultJScriptingBrowser.this.fireDefaultAction(tree.getSelectionPath());
                }
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }
        });
        this.tree.getActionMap().put(KeyStroke.getKeyStroke("+"), new ExpandSelectedNodeAction());
        this.tree.getActionMap().put(KeyStroke.getKeyStroke("SPACE"), new ExpandSelectedNodeAction());
        this.tree.getActionMap().put(KeyStroke.getKeyStroke(10, 0), new EnterAction());
        JScrollPane scrollPane = new JScrollPane(this.tree);
        this.add(scrollPane);
    }

    public TreePath getSelectionPath() {
        return this.tree.getSelectionPath();
    }

    public void setSelectionPath(TreePath path) {
        if (path == null) {
            this.tree.clearSelection();
        } else {
            this.tree.setSelectionPath(path);
        }
    }

    public ScriptingUnit getSelectedNode() {
        ScriptingUnit unit = this.tree.getSelectionPath() != null ? (ScriptingUnit)this.tree.getSelectionPath().getLastPathComponent() : (ScriptingUnit)this.treeModel.getRoot();
        return unit;
    }

    private void fireDefaultAction(TreePath path) {
        ScriptingUnit unit = (ScriptingUnit)path.getLastPathComponent();
        unit.reload();
        DefaultBrowserActionEvent ae = new DefaultBrowserActionEvent((Object)this, 1, "default", unit);
        this.actionlisteners.fireActionEvent((ActionEvent)ae);
    }

    private void fireSelectAction(TreePath path) {
        ScriptingUnit unit = (ScriptingUnit)path.getLastPathComponent();
        DefaultBrowserActionEvent ae = new DefaultBrowserActionEvent((Object)this, 2, "select", unit);
        this.actionlisteners.fireActionEvent((ActionEvent)ae);
    }

    private class IconCellRenderer
    extends JLabel
    implements TreeCellRenderer {
        private static final long serialVersionUID = 1L;
        protected Color m_textSelectionColor;
        protected Color m_textNonSelectionColor;
        protected Color m_bkSelectionColor;
        protected Color m_bkNonSelectionColor;
        protected Color m_borderSelectionColor;
        protected boolean m_selected;
        private final Map<String, ImageIcon> icons = new HashMap<String, ImageIcon>();

        public IconCellRenderer() {
            this.m_textSelectionColor = UIManager.getColor("Tree.selectionForeground");
            this.m_textNonSelectionColor = UIManager.getColor("Tree.textForeground");
            this.m_bkSelectionColor = UIManager.getColor("Tree.selectionBackground");
            this.m_bkNonSelectionColor = UIManager.getColor("Tree.textBackground");
            this.m_borderSelectionColor = UIManager.getColor("Tree.selectionBorderColor");
            this.setOpaque(false);
        }

        private ImageIcon getIcon(String iconName) {
            ImageIcon img = this.icons.get(iconName);
            if (img == null) {
                img = DefaultJScriptingBrowser.this.uimanager.getIcon(iconName);
                this.icons.put(iconName, img);
            }
            return img;
        }

        private ImageIcon getExpandedIcon(ScriptingUnit unit) {
            if (unit instanceof ScriptingExternalFile) {
                ScriptingExternalFile extfile = (ScriptingExternalFile)unit;
                String ext = FilenameUtils.getExtension((String)extfile.getExternalFile().getName());
                ClassLoader loader = this.getClass().getClassLoader();
                URL res = loader.getResource("org/gvsig/scripting/images/16x16/extensions/" + ext + "-icon-16x16.png");
                if (res != null) {
                    return new ImageIcon(res);
                }
            }
            return this.getIcon(unit.getIconNames()[1]);
        }

        private ImageIcon getCollapsedIcon(ScriptingUnit unit) {
            if (unit instanceof ScriptingExternalFile) {
                ScriptingExternalFile extfile = (ScriptingExternalFile)unit;
                String ext = FilenameUtils.getExtension((String)extfile.getExternalFile().getName());
                ClassLoader loader = this.getClass().getClassLoader();
                URL res = loader.getResource("org/gvsig/scripting/images/16x16/extensions/" + ext + "-icon-16x16.png");
                if (res != null) {
                    return new ImageIcon(res);
                }
            }
            return this.getIcon(unit.getIconNames()[0]);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            ScriptingUnit unit = (ScriptingUnit)value;
            this.setText(unit.getName());
            if (expanded) {
                this.setIcon(this.getExpandedIcon(unit));
            } else {
                this.setIcon(this.getCollapsedIcon(unit));
            }
            this.setFont(tree.getFont());
            this.setForeground(sel ? this.m_textSelectionColor : this.m_textNonSelectionColor);
            this.setBackground(sel ? this.m_bkSelectionColor : this.m_bkNonSelectionColor);
            this.m_selected = sel;
            return this;
        }

        @Override
        public void paintComponent(Graphics g) {
            Color bColor = this.getBackground();
            Icon icon = this.getIcon();
            g.setColor(bColor);
            int offset = 0;
            if (icon != null && this.getText() != null) {
                offset = icon.getIconWidth() + this.getIconTextGap();
            }
            g.fillRect(offset, 0, this.getWidth() - 1 - offset, this.getHeight() - 1);
            if (this.m_selected) {
                g.setColor(this.m_borderSelectionColor);
                g.drawRect(offset, 0, this.getWidth() - 1 - offset, this.getHeight() - 1);
            }
            super.paintComponent(g);
        }
    }

    private class ExpandSelectedNodeAction
    extends AbstractAction {
        private static final long serialVersionUID = -4121272513454221967L;

        private ExpandSelectedNodeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            try {
                TreePath selected = DefaultJScriptingBrowser.this.tree.getSelectionPath();
                if (DefaultJScriptingBrowser.this.tree.isCollapsed(selected)) {
                    DefaultJScriptingBrowser.this.tree.expandPath(selected);
                } else {
                    DefaultJScriptingBrowser.this.tree.collapsePath(selected);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private class EnterAction
    extends AbstractAction {
        private static final long serialVersionUID = -3673546098243190397L;

        private EnterAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            TreePath selected = DefaultJScriptingBrowser.this.tree.getSelectionPath();
            DefaultJScriptingBrowser.this.fireDefaultAction(selected);
        }
    }

    class ScriptingFolderTreeModelFoldersOnly
    extends ScriptingFolderTreeModel {
        public ScriptingFolderTreeModelFoldersOnly(ScriptingFolder root) {
            super(root);
        }

        @Override
        public Object getChild(Object parent, int index) {
            ScriptingFolder folder = (ScriptingFolder)parent;
            List children = folder.getUnitFolders();
            return children.get(index);
        }

        @Override
        public int getChildCount(Object parent) {
            if (!(parent instanceof ScriptingFolder)) {
                return 0;
            }
            ScriptingFolder folder = (ScriptingFolder)parent;
            return folder.getUnitFolders().size();
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            String childPath = ((ScriptingFolder)child).getFile().getAbsolutePath();
            ScriptingFolder folder = (ScriptingFolder)parent;
            List children = folder.getUnitFolders();
            for (int i = 0; i < children.size(); ++i) {
                ScriptingUnit aChild = (ScriptingUnit)children.get(i);
                if (!aChild.getFile().getAbsolutePath().equals(childPath)) continue;
                return i;
            }
            return -1;
        }
    }

    class ScriptingFolderTreeModel
    implements TreeModel {
        protected final ScriptingFolder root;
        protected final List<TreeModelListener> listeners = new ArrayList<TreeModelListener>();

        public ScriptingFolderTreeModel(ScriptingFolder root) {
            this.root = root;
        }

        @Override
        public Object getRoot() {
            return this.root;
        }

        @Override
        public Object getChild(Object parent, int index) {
            ScriptingFolder folder = (ScriptingFolder)parent;
            List children = folder.getUnits();
            return children.get(index);
        }

        @Override
        public int getChildCount(Object parent) {
            if (!(parent instanceof ScriptingFolder)) {
                return 0;
            }
            ScriptingFolder folder = (ScriptingFolder)parent;
            return folder.getUnits().size();
        }

        @Override
        public boolean isLeaf(Object node) {
            return !(node instanceof ScriptingFolder);
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            String childPath = ((ScriptingUnit)child).getFile().getAbsolutePath();
            ScriptingFolder folder = (ScriptingFolder)parent;
            List children = folder.getUnits();
            for (int i = 0; i < children.size(); ++i) {
                ScriptingUnit aChild = (ScriptingUnit)children.get(i);
                if (!aChild.getFile().getAbsolutePath().equals(childPath)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public void valueForPathChanged(TreePath path, Object value) {
        }

        @Override
        public void addTreeModelListener(TreeModelListener listener) {
            this.listeners.add(listener);
        }

        @Override
        public void removeTreeModelListener(TreeModelListener listener) {
            this.listeners.remove(listener);
        }

        public void reload() {
            TreeModelEvent event = new TreeModelEvent((Object)this, new TreePath(this.root));
            for (TreeModelListener listener : this.listeners) {
                listener.treeStructureChanged(event);
            }
        }
    }

    public static class DefaultBrowserActionEvent
    extends ActionEvent
    implements JScriptingBrowser.BrowserActionEvent {
        private static final long serialVersionUID = -1474410768278633364L;
        private ScriptingUnit unit = null;

        public DefaultBrowserActionEvent(Object source, int id, String command, ScriptingUnit unit) {
            super(source, id, command);
            this.unit = unit;
        }

        public ScriptingUnit getUnit() {
            return this.unit;
        }
    }
}

