/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.scripting.swing.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringBufferInputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.gvsig.scripting.swing.api.JThinlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thinlet.Thinlet;

public class DefaultJThinlet
extends JThinlet
implements AncestorListener {
    private static final long serialVersionUID = 5130602761126860652L;
    private static final Logger logger = LoggerFactory.getLogger(DefaultJThinlet.class);
    static final Pattern pattern = Pattern.compile(" action=\\s*\"([^\"]*)\"");
    protected Thinlet thinlet;
    protected ActionListener actionlistener = null;

    public DefaultJThinlet() {
        this.setLayout(new BorderLayout());
        this.addAncestorListener(this);
        this.thinlet = null;
    }

    public DefaultJThinlet(File file) {
        this();
        if (file != null) {
            this.load(file);
        }
    }

    static String readFileAsString(File file) throws IOException {
        StringBuffer fileData = new StringBuffer(1000);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        char[] buf = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            String readData = String.valueOf(buf, 0, numRead);
            fileData.append(readData);
            buf = new char[1024];
        }
        reader.close();
        return fileData.toString();
    }

    public void load(File file) {
        String xml = null;
        StringBufferInputStream input = null;
        Object component = null;
        ThinletWrapper thinlet = new ThinletWrapper();
        try {
            xml = DefaultJThinlet.readFileAsString(file);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        Matcher match = pattern.matcher(xml);
        xml = match.replaceAll(" action=\"invoke('$1')\"");
        input = new StringBufferInputStream(xml);
        try {
            component = thinlet.parse(input, this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (component != null) {
            thinlet.add(component);
        }
        this.add((Component)((Object)thinlet), "Center");
        this.thinlet = thinlet;
    }

    private void hideThinlet() {
        this.setVisible(false);
    }

    public void invoke(String name) {
        if (this.actionlistener != null) {
            ActionEvent event = new ActionEvent(this, 1, name);
            this.actionlistener.actionPerformed(event);
        }
    }

    public Thinlet getThinlet() {
        return this.thinlet;
    }

    public Dimension getPreferredSize() {
        return this.getThinlet().getPreferredSize();
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        if (this.getThinlet() == null) {
            this.getThinlet().repaint();
        }
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
        if (this.getThinlet() == null) {
            this.getThinlet().repaint();
        }
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
    }

    public void addActionListener(ActionListener actionlistener) {
        this.actionlistener = actionlistener;
    }

    class ThinletWrapper
    extends Thinlet {
        ThinletWrapper() {
        }

        public void setVisible(boolean b) {
            super.setVisible(b);
            if (!b) {
                DefaultJThinlet.this.hideThinlet();
            }
        }
    }
}

