/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.scripting.swing.impl.composer.components;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeListener;
import org.gvsig.scripting.swing.api.JScriptingComposer;
import org.gvsig.scripting.swing.impl.composer.components.DefaultJTabbedPaneClosable;
import org.gvsig.scripting.swing.impl.composer.components.JTabbedPaneClosable;

public class DefaultDock
extends JPanel
implements JScriptingComposer.Dock {
    private static final long serialVersionUID = 4899734277977456625L;
    private final Map<String, JScriptingComposer.Dock.DockedPanel> panels = new HashMap<String, JScriptingComposer.Dock.DockedPanel>();
    private final JTabbedPaneClosable tabbedPanelLeft;
    private final JTabbedPaneClosable tabbedPanelBottom;
    private final JTabbedPaneClosable tabbedPanelCenter;
    private Set<ActionListener> closeListeners;
    private Set<ActionListener> activePanelListeners;

    public DefaultDock(JTabbedPaneClosable tabbedPanelLeft, JTabbedPaneClosable tabbedPanelBottom, JTabbedPaneClosable tabbedPanelCenter) {
        this.tabbedPanelBottom = tabbedPanelBottom;
        this.tabbedPanelLeft = tabbedPanelLeft;
        this.tabbedPanelCenter = tabbedPanelCenter;
        ActionListener onCloseTab = e -> {
            JScriptingComposer.Dock.DockedPanel panel;
            DefaultJTabbedPaneClosable tabbedPanel = (DefaultJTabbedPaneClosable)e.getSource();
            Component component1 = tabbedPanel.getSelectedComponent();
            if (component1 != null && (panel = this.getDockedPanel(component1)) != null) {
                this.fireCloseListener(new ActionEvent(panel, 0, "ClosePanel"));
            }
        };
        ChangeListener onChangeTab = e -> this.fireChangeListener(new ActionEvent(this, 0, "ActivePanel"));
        this.tabbedPanelCenter.addChangeListener(onChangeTab);
        this.tabbedPanelBottom.addChangeListener(onChangeTab);
        this.tabbedPanelLeft.addChangeListener(onChangeTab);
        this.tabbedPanelBottom.addCloseTabListener(onCloseTab);
        this.tabbedPanelLeft.addCloseTabListener(onCloseTab);
        this.tabbedPanelCenter.addCloseTabListener(onCloseTab);
    }

    public void addCloseListener(ActionListener listener) {
        if (this.closeListeners == null) {
            this.closeListeners = new HashSet<ActionListener>();
        }
        this.closeListeners.add(listener);
    }

    public void removeCloseListener(ActionListener listener) {
        if (this.closeListeners == null) {
            return;
        }
        this.closeListeners.remove(listener);
    }

    public void addActivateListener(ActionListener listener) {
        if (this.activePanelListeners == null) {
            this.activePanelListeners = new HashSet<ActionListener>();
        }
        this.activePanelListeners.add(listener);
    }

    public void removeActivateListener(ActionListener listener) {
        if (this.activePanelListeners == null) {
            return;
        }
        this.activePanelListeners.remove(listener);
    }

    public void fireCloseListener(ActionEvent e) {
        if (this.closeListeners == null) {
            return;
        }
        for (ActionListener listener : this.closeListeners) {
            try {
                listener.actionPerformed(e);
            }
            catch (Exception exception) {}
        }
    }

    public void fireChangeListener(ActionEvent e) {
        if (this.activePanelListeners == null) {
            return;
        }
        for (ActionListener listener : this.activePanelListeners) {
            try {
                listener.actionPerformed(e);
            }
            catch (Exception exception) {}
        }
    }

    private JTabbedPaneClosable getTabbedPanel(String align) {
        switch (align) {
            case "West": {
                return this.tabbedPanelLeft;
            }
            case "Center": {
                return this.tabbedPanelCenter;
            }
        }
        return this.tabbedPanelBottom;
    }

    private JScriptingComposer.Dock.DockedPanel getDockedPanel(Component component) {
        for (JScriptingComposer.Dock.DockedPanel panel : this.panels.values()) {
            if (panel.getComponent().asJComponent() != component) continue;
            return panel;
        }
        return null;
    }

    private int getIndex(JScriptingComposer.Dock.DockedPanel panel) {
        JTabbedPaneClosable tabbedPanel = this.getTabbedPanel(panel.getAlign());
        for (int i = 0; i < tabbedPanel.getTabCount(); ++i) {
            Component component = tabbedPanel.getComponentAt(i);
            if (component != panel.getComponent().asJComponent()) continue;
            return i;
        }
        return -1;
    }

    public void setModified(JScriptingComposer.Dock.DockedPanel panel, boolean modified) {
        int index = this.getIndex(panel);
        if (index < 0) {
            return;
        }
        JTabbedPaneClosable tabbedPanel = this.getTabbedPanel(panel.getAlign());
        tabbedPanel.setTabModified(index, modified);
    }

    public boolean getModified(JScriptingComposer.Dock.DockedPanel panel) {
        int index = this.getIndex(panel);
        if (index < 0) {
            return false;
        }
        JTabbedPaneClosable tabbedPanel = this.getTabbedPanel(panel.getAlign());
        return tabbedPanel.isTabModified(index);
    }

    public JScriptingComposer.Dock.DockedPanel getSelected(String align) {
        JTabbedPaneClosable tabbedPanel = this.getTabbedPanel(align);
        Component selected = tabbedPanel.getSelectedComponent();
        return this.getDockedPanel(selected);
    }

    public JScriptingComposer.Dock.DockedPanel add(String id, String title, org.gvsig.tools.swing.api.Component component, String align) {
        JTabbedPaneClosable tabbedPanel = this.getTabbedPanel(align);
        JScriptingComposer.Dock.DockedPanel panel = this.panels.get(id);
        if (panel != null) {
            tabbedPanel.removeTab(panel.getComponent().asJComponent());
        }
        panel = new DefaultDockedPanel(id, title, component, align);
        this.panels.put(id, panel);
        tabbedPanel.addTab(panel.getTitle(), panel.getComponent().asJComponent());
        JComponent tabComponent = (JComponent)tabbedPanel.getTabComponentAt(tabbedPanel.getTabCount() - 1);
        if (tabComponent != null) {
            tabComponent.setComponentPopupMenu(this.createDefaultComponentPopupMenu(panel));
        }
        return panel;
    }

    private JPopupMenu createDefaultComponentPopupMenu(JScriptingComposer.Dock.DockedPanel panel) {
        JPopupMenu menu = new JPopupMenu();
        menu.add(this.createMenuItem("Move to left", e -> panel.moveto("West")));
        menu.add(this.createMenuItem("Move to bottom", e -> panel.moveto("South")));
        menu.add(this.createMenuItem("Move to center", e -> panel.moveto("Center")));
        return menu;
    }

    private JMenuItem createMenuItem(String text, ActionListener listener) {
        JMenuItem item = new JMenuItem(text);
        item.addActionListener(listener);
        return item;
    }

    public void remove(String id) {
        JScriptingComposer.Dock.DockedPanel panel = this.panels.get(id);
        if (panel != null) {
            JTabbedPaneClosable tabbedPanel = this.getTabbedPanel(panel.getAlign());
            tabbedPanel.removeTab(panel.getComponent().asJComponent());
            this.panels.remove(id);
        }
    }

    public JScriptingComposer.Dock.DockedPanel get(String id) {
        JScriptingComposer.Dock.DockedPanel panel = this.panels.get(id);
        return panel;
    }

    public void select(String id) {
        JScriptingComposer.Dock.DockedPanel panel = this.panels.get(id);
        if (panel != null) {
            JTabbedPaneClosable tabbedPanel = this.getTabbedPanel(panel.getAlign());
            tabbedPanel.setSelectedComponent(panel.getComponent().asJComponent());
        }
    }

    public Iterator<JScriptingComposer.Dock.DockedPanel> iterator() {
        return this.panels.values().iterator();
    }

    public class DefaultDockedPanel
    implements JScriptingComposer.Dock.DockedPanel {
        String id;
        String title;
        org.gvsig.tools.swing.api.Component component;
        private final String align;

        public DefaultDockedPanel(String id, String title, org.gvsig.tools.swing.api.Component component, String align) {
            this.id = id;
            this.title = title;
            this.component = component;
            this.align = align;
        }

        public String getId() {
            return this.id;
        }

        public String getAlign() {
            return this.align;
        }

        public org.gvsig.tools.swing.api.Component getComponent() {
            return this.component;
        }

        public String getTitle() {
            return this.title;
        }

        public boolean isModified() {
            return DefaultDock.this.getModified(this);
        }

        public void setModified(boolean modified) {
            DefaultDock.this.setModified(this, modified);
        }

        public void remove() {
            DefaultDock.this.remove(this.getId());
        }

        public void select() {
            DefaultDock.this.select(this.getId());
        }

        public void moveto(String position) {
            switch (position) {
                case "West": {
                    DefaultDock.this.add(this.getId(), this.getTitle(), this.getComponent(), "West");
                    break;
                }
                case "Center": {
                    DefaultDock.this.add(this.getId(), this.getTitle(), this.getComponent(), "Center");
                    break;
                }
                default: {
                    DefaultDock.this.add(this.getId(), this.getTitle(), this.getComponent(), "South");
                }
            }
        }
    }
}

