/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.scripting.swing.impl.composer.editors;

import java.awt.BorderLayout;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.gvsig.scripting.ScriptingScript;
import org.gvsig.scripting.ScriptingUnit;
import org.gvsig.scripting.swing.api.JCodeEditor;
import org.gvsig.scripting.swing.api.ScriptingUIManager;
import org.gvsig.scripting.swing.api.SyntaxtHighlightTextComponent;
import org.gvsig.scripting.swing.impl.FileChangesObserver;
import org.gvsig.scripting.swing.impl.composer.ChangeListenerSupport;
import org.gvsig.scripting.swing.impl.composer.JPropertiesScript;
import org.gvsig.scripting.swing.impl.composer.editors.BaseTextEditor;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.script.Script;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptUnitEditor
extends JPanel
implements JCodeEditor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptUnitEditor.class);
    private static final long serialVersionUID = 5191252525229037754L;
    private JTabbedPane tabs;
    protected ScriptingScript script;
    protected final ScriptingUIManager uimanager;
    protected final ChangeListenerSupport changeListeners;
    protected BaseTextEditor textEditor;
    protected JPropertiesScript propertiesPanel;
    protected boolean modified;
    private final Observer fileObserver;
    private boolean saving;

    public ScriptUnitEditor(ScriptingUIManager uimanager) {
        this(uimanager, null);
    }

    public ScriptUnitEditor(ScriptingUIManager uimanager, Script script) {
        this.script = (ScriptingScript)script;
        this.uimanager = uimanager;
        this.modified = false;
        this.saving = false;
        this.changeListeners = new ChangeListenerSupport();
        this.initComponents();
        if (this.script != null) {
            this.set((ScriptingUnit)this.script);
        }
        this.fileObserver = (o, o1) -> this.doFileModified();
    }

    private synchronized void doFileModified() {
        if (this.saving) {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.doFileModified());
            return;
        }
        if (this.isModified()) {
            JOptionPane.showMessageDialog(this, "The file '" + this.getUnit().getUserPath() + "' has externaly modified.", "File modification", 1);
        } else {
            this.reload();
        }
    }

    public ScriptingScript getScript() {
        return this.script;
    }

    public ScriptingUnit getUnit() {
        return this.script;
    }

    private void initComponents() {
        this.textEditor = new BaseTextEditor();
        this.textEditor.addChangeListener(evt -> {
            this.modified = true;
            this.fireChangeEvent(evt);
        });
        this.propertiesPanel = new JPropertiesScript((ScriptingUnit)this.script);
        this.propertiesPanel.addChangeListener(evt -> {
            this.modified = true;
            this.fireChangeEvent(evt);
        });
        this.tabs = new JTabbedPane();
        this.tabs.setTabPlacement(3);
        this.tabs.addTab(this.uimanager.getTranslation("Code"), this.textEditor);
        this.tabs.addTab(this.uimanager.getTranslation("Properties"), this.propertiesPanel);
        this.setLayout(new BorderLayout());
        this.add("Center", this.tabs);
    }

    protected JTabbedPane getTabbedPane() {
        return this.tabs;
    }

    public boolean isModified() {
        return this.modified;
    }

    public synchronized void save() {
        try {
            this.saving = true;
            this.fetch(this.getUnit());
            this.script.save();
            this.modified = false;
        }
        finally {
            this.saving = false;
        }
    }

    public void reload() {
        JTextComponent text = this.getJTextComponent();
        int pos = text.getCaretPosition();
        this.set(this.getUnit());
        int len = text.getDocument().getLength();
        if (pos > len) {
            pos = len;
        }
        if (pos < 0) {
            pos = 0;
        }
        try {
            text.setCaretPosition(pos);
        }
        catch (Exception ex) {
            LOGGER.trace("Can't restore caret position after reload", (Throwable)ex);
        }
    }

    public void addChangeListener(PropertyChangeListener listener) {
        this.changeListeners.addChangeListener(listener);
    }

    protected void fireChangeEvent(String name, Object oldValue) {
        this.changeListeners.fireChange(name, oldValue);
    }

    protected void fireChangeEvent(PropertyChangeEvent evt) {
        this.changeListeners.fireChange(evt);
    }

    public void set(ScriptingUnit unit) {
        this.script = (ScriptingScript)unit;
        this.propertiesPanel.set(unit);
        this.textEditor.setText(this.script.getMimeType(), this.script.getCode());
        if (unit.isASystemUnit()) {
            this.textEditor.getJTextComponent().setEditable(false);
        } else {
            this.textEditor.getJTextComponent().setEditable(true);
        }
        if (this.script != null) {
            FileChangesObserver.getInstance().addObserver(this.fileObserver, this.script.getScriptFile());
        }
    }

    public void fetch(ScriptingUnit unit) {
        ScriptingScript theScript = (ScriptingScript)unit;
        if (this.propertiesPanel != null) {
            this.propertiesPanel.fectch((ScriptingUnit)theScript);
        }
        if (this.textEditor != null) {
            theScript.setCode(this.textEditor.getText());
        }
    }

    public JTextComponent getJTextComponent() {
        return this.textEditor.getJTextComponent();
    }

    public SyntaxtHighlightTextComponent getSyntaxtHighlightTextComponent() {
        return this.textEditor.getSyntaxtHighlightTextComponent();
    }

    public void selectLine(int line) {
        this.textEditor.selectLine(line);
    }

    public int getLineCount() {
        return this.textEditor.getLineCount();
    }

    public JComponent asJComponent() {
        return this;
    }

    public void gotoline(int line) {
        this.textEditor.gotoline(line);
    }

    public void addUpdateCaretPositionActionListener(ActionListener actionlistener) {
        this.textEditor.addUpdateCaretPositionActionListener(actionlistener);
    }
}

