/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.scripting.swing.impl.composer.editors;

import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.gvsig.scripting.ScriptingText;
import org.gvsig.scripting.ScriptingUnit;
import org.gvsig.scripting.swing.api.JTextEditor;
import org.gvsig.scripting.swing.api.ScriptingSwingLocator;
import org.gvsig.scripting.swing.api.ScriptingUIManager;
import org.gvsig.scripting.swing.api.SyntaxtHighlightTextComponent;
import org.gvsig.scripting.swing.impl.FileChangesObserver;
import org.gvsig.scripting.swing.impl.composer.ChangeListenerSupport;
import org.gvsig.scripting.swing.impl.composer.editors.BaseTextEditor;
import org.gvsig.scripting.swing.impl.composer.editors.ExternalFileEditorView;
import org.gvsig.tools.observer.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextEditor
extends ExternalFileEditorView
implements JTextEditor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TextEditor.class);
    private static final long serialVersionUID = 9189395063548155843L;
    protected ScriptingText unit;
    protected boolean modified;
    protected BaseTextEditor textEditor;
    protected final ChangeListenerSupport changeListeners = new ChangeListenerSupport();
    private final ScriptingUIManager uimanager = ScriptingSwingLocator.getUIManager();
    private final Observer fileObserver = (o, o1) -> this.doFileModified();
    private boolean saving = false;

    public TextEditor(ScriptingText unit) {
        this.initComponents();
        this.set((ScriptingUnit)unit);
    }

    private synchronized void doFileModified() {
        if (this.saving) {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.doFileModified());
            return;
        }
        if (this.isModified()) {
            JOptionPane.showMessageDialog(this, "The file '" + this.getUnit().getUserPath() + "' has externaly modified.", "File modification", 1);
        } else {
            this.reload();
        }
    }

    public ScriptingText getUnit() {
        return this.unit;
    }

    protected void setModified(boolean modified) {
        this.modified = modified;
    }

    protected BaseTextEditor getTextEditor() {
        return this.textEditor;
    }

    protected JTabbedPane getTabbedPane() {
        return this.tabEditor;
    }

    protected ChangeListenerSupport getChangeListeners() {
        return this.changeListeners;
    }

    private void initComponents() {
        this.textEditor = new BaseTextEditor();
        this.textEditor.addChangeListener(evt -> {
            this.modified = true;
            this.fireChangeEvent(evt);
        });
        this.getTabbedPane().insertTab(this.uimanager.getTranslation("Contents"), null, this.textEditor, null, 0);
        this.getTabbedPane().setSelectedIndex(0);
    }

    public void addPanel(String name, JComponent panel) {
        this.getTabbedPane().addTab(name, panel);
    }

    public boolean isModified() {
        return this.modified;
    }

    public synchronized void save() {
        try {
            this.saving = true;
            this.fetch((ScriptingUnit)this.unit);
            this.unit.save();
        }
        finally {
            this.saving = false;
        }
    }

    public void addChangeListener(PropertyChangeListener listener) {
        this.changeListeners.addChangeListener(listener);
    }

    protected void fireChangeEvent(String name, Object oldValue) {
        this.changeListeners.fireChange(name, oldValue);
    }

    protected void fireChangeEvent(PropertyChangeEvent evt) {
        this.changeListeners.fireChange(evt);
    }

    private String threadId() {
        Thread th = Thread.currentThread();
        return "thread=" + th.getId() + " (" + th.getName() + ")";
    }

    public void set(ScriptingUnit unit) {
        this.unit = (ScriptingText)unit;
        if (unit == null) {
            this.textEditor.setText("", "");
            this.txtMimeType.setText("");
            this.txtName.setText("");
            this.textEditor.getJTextComponent().setEditable(false);
            return;
        }
        this.txtMimeType.setText(this.unit.getMimeType());
        this.txtName.setText(this.unit.getFile().getAbsolutePath());
        this.textEditor.setText(this.unit.getMimeType(), this.unit.getText());
        if (unit.isASystemUnit()) {
            this.textEditor.getJTextComponent().setEditable(false);
        } else {
            this.textEditor.getJTextComponent().setEditable(true);
        }
        if (this.unit != null) {
            FileChangesObserver.getInstance().addObserver(this.fileObserver, this.unit.getFile());
        }
    }

    public void fetch(ScriptingUnit unit) {
        ((ScriptingText)unit).setText(this.textEditor.getText());
        this.modified = false;
    }

    public JTextComponent getJTextComponent() {
        return this.textEditor.getJTextComponent();
    }

    public SyntaxtHighlightTextComponent getSyntaxtHighlightTextComponent() {
        return this.textEditor.getSyntaxtHighlightTextComponent();
    }

    public void selectLine(int line) {
        this.textEditor.selectLine(line);
    }

    public int getLineCount() {
        return this.textEditor.getLineCount();
    }

    public JComponent asJComponent() {
        return this;
    }

    public void gotoline(int line) {
        this.textEditor.gotoline(line);
    }

    public void addUpdateCaretPositionActionListener(ActionListener actionlistener) {
        this.textEditor.addUpdateCaretPositionActionListener(actionlistener);
    }

    public void reload() {
        JTextComponent text = this.getJTextComponent();
        int pos = text.getCaretPosition();
        this.set((ScriptingUnit)this.getUnit());
        int len = text.getDocument().getLength();
        if (pos > len) {
            pos = len;
        }
        if (pos < 0) {
            pos = 0;
        }
        try {
            text.setCaretPosition(pos);
        }
        catch (Exception ex) {
            LOGGER.trace("Can't restore caret position after reload", (Throwable)ex);
        }
    }
}

