/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.spatial;

import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.math.util.MathUtils;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractGeometryFunction;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.primitive.Point;

public class PointByAngleFunction
extends AbstractGeometryFunction {
    public PointByAngleFunction() {
        super("Spatial", "PointByAngle", Range.between((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(5)));
    }

    public boolean allowConstantFolding() {
        return true;
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        double angle;
        double distance;
        Point pointGeom;
        Object arg1 = this.getObject(args, 0);
        try {
            arg1 = this.getDouble(args, 0);
        }
        catch (Exception ex) {
            arg1 = this.getObject(args, 0);
        }
        String unit = "s";
        if (!(arg1 instanceof Number)) {
            Geometry argGeom = GeometryLocator.getGeometryManager().createFrom(arg1);
            if (argGeom == null) {
                throw new RuntimeException("Geometry can't be null");
            }
            pointGeom = argGeom.centroid();
            if (args.length == 4) {
                unit = this.getStr(args, 3);
            }
            distance = this.getDouble(args, 1);
            angle = this.getDouble(args, 2);
        } else {
            double x1 = (Double)arg1;
            double x2 = this.getDouble(args, 1);
            pointGeom = GeometryLocator.getGeometryManager().createPoint(x1, x2, 0);
            if (pointGeom == null) {
                throw new RuntimeException("Geometry can't be null");
            }
            if (args.length == 5) {
                unit = this.getStr(args, 4);
            }
            distance = this.getDouble(args, 2);
            angle = this.getDouble(args, 3);
        }
        if (StringUtils.equals((CharSequence)unit, (CharSequence)"s")) {
            angle = MathUtils.round((double)Math.toRadians(angle), (int)8);
        } else if (StringUtils.equals((CharSequence)unit, (CharSequence)"g")) {
            angle = Math.PI * angle / 200.0;
        }
        double deltaX = distance * MathUtils.round((double)Math.cos(angle), (int)8);
        double deltaY = distance * MathUtils.round((double)Math.sin(angle), (int)8);
        pointGeom.move(deltaX, deltaY);
        return pointGeom;
    }
}

