/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.spatial;

import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.ExpressionRuntimeException;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractGeometryFunction;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.aggregate.Aggregate;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.primitive.OrientablePrimitive;
import org.gvsig.fmap.geom.primitive.Polygon;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.geom.primitive.Surface;

public class STMakePolygonFunction
extends AbstractGeometryFunction {
    public STMakePolygonFunction() {
        super("OGC", "ST_MakePolygon", Range.between((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(2)));
    }

    public boolean allowConstantFolding() {
        return true;
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        Polygon geomR;
        switch (args.length) {
            default: {
                Geometry geom1 = this.getGeom(args, 0);
                if (geom1 == null || geom1 instanceof Surface && ((Surface)geom1).getNumInteriorRings() > 0) {
                    throw new ExpressionRuntimeException("Linestring required");
                }
                if (geom1 instanceof OrientablePrimitive) {
                    Polygon geom = GeometryUtils.createPolygon((int)geom1.getGeometryType().getSubType());
                    OrientablePrimitive primitive = (OrientablePrimitive)geom1;
                    for (int i = 0; i < primitive.getNumVertices(); ++i) {
                        geom.addVertex(primitive.getVertex(i));
                    }
                    geomR = geom;
                    break;
                }
                if (geom1 instanceof Aggregate) {
                    MultiPolygon multiPolygon = GeometryUtils.createMultiPolygon((int)geom1.getGeometryType().getSubType());
                    for (int i = 0; i < ((Aggregate)geom1).getPrimitivesNumber(); ++i) {
                        Polygon polygon = GeometryUtils.createPolygon((int)geom1.getGeometryType().getSubType());
                        OrientablePrimitive primitive = (OrientablePrimitive)multiPolygon.getPrimitiveAt(i);
                        if (primitive instanceof Surface && ((Surface)primitive).getNumInteriorRings() > 0) {
                            throw new ExpressionRuntimeException("Linestring required");
                        }
                        for (int j = 0; j < primitive.getNumVertices(); ++j) {
                            polygon.addVertex(primitive.getVertex(j));
                        }
                        multiPolygon.addPrimitive((Primitive)polygon);
                    }
                    geomR = multiPolygon;
                    break;
                }
                throw new ExpressionRuntimeException("Unsupported inout geometry (" + geom1.getGeometryType().getFullName() + ")");
            }
            case 2: {
                throw new ExpressionRuntimeException("Unsupported holes.");
            }
        }
        return geomR;
    }
}

