/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.scripting.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutableURLClassLoader
extends URLClassLoader {
    protected static final Logger LOGGER = LoggerFactory.getLogger(MutableURLClassLoader.class);

    public MutableURLClassLoader(List<URL> urls, ClassLoader parent) {
        super(urls.toArray(new URL[urls.size()]), parent);
    }

    public void addUrls(List<URL> urls) {
        ArrayList<URL> currentsURLs = new ArrayList<URL>();
        currentsURLs.addAll(Arrays.asList(this.getURLs()));
        for (URL url : urls) {
            if (currentsURLs.contains(url)) continue;
            this.addURL(url);
            currentsURLs.add(url);
        }
    }

    public boolean needRecompile(String name, URL url) {
        if (url != null && name.endsWith("$py.class") && StringUtils.equalsIgnoreCase((CharSequence)url.getProtocol(), (CharSequence)"file")) {
            String path = url.getPath();
            File binary = new File(path);
            File source = new File(StringUtils.left((String)path, (int)(path.length() - 9)) + ".py");
            if (!binary.exists() || FileUtils.isFileNewer((File)source, (File)binary)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public URL getResource(String name) {
        URL x = super.getResource(name);
        if (this.needRecompile(name, x)) {
            LOGGER.trace("getResoure(" + name + ") -> null (need recompile).");
            return null;
        }
        LOGGER.trace("getResoure(" + name + ") -> " + x);
        return x;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        URL url = super.getResource(name);
        if (this.needRecompile(name, url)) {
            LOGGER.trace("getResourceAsStream(" + name + ") -> null (need recompile).");
            return null;
        }
        InputStream x = super.getResourceAsStream(name);
        LOGGER.trace("getResourceAsStream(" + name + ") -> " + (x == null ? "null" : "(stream)"));
        return x;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> urls = super.getResources(name);
        LOGGER.info("getResources(" + name + ") -> " + (urls == null ? "null" : urls));
        return urls;
    }

    public String getResourcePath(String name) {
        URL url;
        if (name.startsWith("__pyclasspath__/")) {
            name = name.substring(16);
        }
        if ((url = this.getResource(name)) == null) {
            return name;
        }
        File f = FileUtils.toFile((URL)url);
        return f.getAbsolutePath();
    }

    public List<String> path(List<String> basepath) {
        URL[] urls;
        ArrayList<String> path = new ArrayList<String>();
        if (basepath != null) {
            for (String folder : basepath) {
                if (folder == null || folder.startsWith("__") || path.contains(folder)) continue;
                path.add(folder);
            }
        }
        for (URL url : urls = this.getURLs()) {
            String folder;
            if (url == null || !StringUtils.equalsIgnoreCase((CharSequence)url.getProtocol(), (CharSequence)"file") || (folder = url.getPath()) == null || folder.isEmpty() || path.contains(folder)) continue;
            path.add(folder);
        }
        return path;
    }
}

