/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gpe.exportto.kml.swing.panels;

import javax.swing.JComponent;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.gvsig.export.ExportParameters;
import org.gvsig.export.ExportParametersGeometry;
import org.gvsig.export.swing.JExportProcessPanel;
import org.gvsig.export.swing.spi.ExportPanel;
import org.gvsig.export.swing.spi.ExportPanelValidationException;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.ProjectionPickerController;
import org.gvsig.gpe.exportto.kml.swing.panels.KMLSelectTargetProjectionPanelView;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;

public class KMLSelectTargetProjectionPanel
extends KMLSelectTargetProjectionPanelView
implements ExportPanel {
    private final ExportParametersGeometry parameters;
    private final JExportProcessPanel processPanel;
    private ProjectionPickerController projectionController;

    public KMLSelectTargetProjectionPanel(JExportProcessPanel processPanel, ExportParameters parameters) {
        this.processPanel = processPanel;
        this.parameters = (ExportParametersGeometry)parameters;
        this.initComponents();
    }

    private void initComponents() {
        this.projectionController = DALSwingLocator.getDataSwingManager().createProjectionPickerController(this.txtUserProjection, this.btnSelectUserProjection);
        this.translate();
        this.projectionController.set((Object)CRSFactory.getCRS((String)"EPSG:4326"));
    }

    public String getIdPanel() {
        return "PANEL_SELECT_TARGET_PROJECTION";
    }

    public String getTitlePanel() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        return i18n.getTranslation("_Target_projection");
    }

    public boolean validatePanel() throws ExportPanelValidationException {
        if (this.parameters instanceof ExportParametersGeometry) {
            if (this.getTargetProjection() == null) {
                return false;
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)this.getTargetProjection().getAbrev(), (CharSequence)"EPSG:4326")) {
                return false;
            }
        }
        return true;
    }

    public void previousPanel() {
    }

    public void enterPanel() {
        if (this.projectionController.get() == null) {
            this.projectionController.set((Object)CRSFactory.getCRS((String)"EPSG:4326"));
        }
    }

    private IProjection getTargetProjection() {
        return (IProjection)this.projectionController.get();
    }

    private ICoordTrans getTargetTransformation() {
        return this.projectionController.getCoordinateTransformation();
    }

    public void nextPanel() {
        this.parameters.setTargetProjection(this.getTargetProjection());
        this.parameters.setTargetTransformation(this.getTargetTransformation());
    }

    public JComponent asJComponent() {
        return this;
    }

    private void translate() {
        ToolsSwingManager manager = ToolsSwingLocator.getToolsSwingManager();
        manager.translate(this.lblSelectTargetProjection);
    }
}

