/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.gui.preferencespage;

import java.awt.BorderLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.PluginsManager;
import org.gvsig.andami.preferences.AbstractPreferencePage;
import org.gvsig.andami.preferences.StoreException;
import org.gvsig.app.project.documents.view.toolListeners.snapping.gui.SnapConfig;
import org.gvsig.fmap.mapcontrol.MapControlLocator;
import org.gvsig.fmap.mapcontrol.MapControlManager;
import org.gvsig.fmap.mapcontrol.tools.snapping.snappers.ISnapper;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.exception.DynFieldNotFoundException;
import org.gvsig.tools.i18n.I18nManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapConfigPage
extends AbstractPreferencePage {
    private static final long serialVersionUID = -3288863201776046550L;
    private static final Logger logger = LoggerFactory.getLogger(SnapConfigPage.class);
    public static final String ID = SnapConfigPage.class.getName();
    private SnapConfig snapConfig;
    private static boolean applySnappers = true;
    private static MapControlManager mapControlManager = MapControlLocator.getMapControlManager();
    private DynObject pluginProperties;
    private PluginServices plugin;

    public SnapConfigPage() {
        PluginsManager pluginManager = PluginsLocator.getManager();
        this.plugin = pluginManager.getPlugin((Object)this);
        this.pluginProperties = this.plugin.getPluginProperties();
        this.snapConfig = new SnapConfig(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                SnapConfigPage.this.setChanged(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        }, new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                SnapConfigPage.this.setChanged(true);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                SnapConfigPage.this.setChanged(true);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                SnapConfigPage.this.setChanged(true);
            }
        });
        this.setLayout(new BorderLayout());
        this.add(this.snapConfig, "Center");
        this.snapConfig.setSnappers();
        this.initializeValues();
    }

    public void storeValues() throws StoreException {
        for (int n = 0; n < mapControlManager.getSnapperCount(); ++n) {
            Boolean b = (Boolean)this.snapConfig.getTableModel().getValueAt(n, 0);
            ISnapper snp = mapControlManager.getSnapperAt(n);
            String nameClass = snp.getClass().getName();
            nameClass = nameClass.substring(nameClass.lastIndexOf(46) + 1);
            this.pluginProperties.setDynValue("snapperActivated" + nameClass, (Object)b);
            if (b.booleanValue()) {
                snp.setEnabled(b.booleanValue());
            }
            this.pluginProperties.setDynValue("snapperPriority" + nameClass, (Object)snp.getPriority());
        }
        Boolean b = this.snapConfig.applySnappers();
        this.pluginProperties.setDynValue("applySnappers", (Object)b);
        applySnappers = b;
        Preferences prefs = Preferences.userRoot().node("snappers");
        prefs.putBoolean("apply-snappers", applySnappers);
        Integer snapTolerance = this.snapConfig.getSnapTolerance();
        this.pluginProperties.setDynValue("snapTolerance", (Object)snapTolerance);
        mapControlManager.setTolerance(snapTolerance.intValue());
        this.plugin.savePluginProperties();
    }

    public void setChangesApplied() {
        this.setChanged(false);
    }

    public String getID() {
        return ID;
    }

    public String getTitle() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        return i18nManager.getTranslation("Snapping");
    }

    public JPanel getPanel() {
        return this;
    }

    public void initializeValues() {
        try {
            applySnappers = (Boolean)this.pluginProperties.getDynValue("applySnappers");
        }
        catch (DynFieldNotFoundException e) {
            this.initializeDefaults();
        }
        this.snapConfig.setApplySnappers(applySnappers);
        for (int n = 0; n < mapControlManager.getSnapperCount(); ++n) {
            ISnapper snp = mapControlManager.getSnapperAt(n);
            String nameClass = snp.getClass().getName();
            nameClass = nameClass.substring(nameClass.lastIndexOf(46) + 1);
            Boolean active = (Boolean)this.pluginProperties.getDynValue("snapperActivated" + nameClass);
            this.snapConfig.getTableModel().setValueAt((boolean)active, n, 0);
            Integer prior = (Integer)this.pluginProperties.getDynValue("snapperPriority" + nameClass);
            this.snapConfig.getTableModel().setValueAt(prior, n, 3);
        }
        Integer snapTolerance = (Integer)this.pluginProperties.getDynValue("snapTolerance");
        this.snapConfig.setSnapTolerance(snapTolerance);
    }

    public void initializeDefaults() {
        for (int n = 0; n < mapControlManager.getSnapperCount(); ++n) {
            int priority;
            ISnapper snp = mapControlManager.getSnapperAt(n);
            String nameClass = snp.getClass().getName();
            if ((nameClass = nameClass.substring(nameClass.lastIndexOf(46) + 1)).equals(".FinalPointSnapper")) {
                priority = 1;
                snp.setEnabled(true);
                snp.setPriority(priority);
                continue;
            }
            if (nameClass.equals(".NearestPointSnapper")) {
                priority = 2;
                snp.setEnabled(true);
                snp.setPriority(priority);
                continue;
            }
            priority = 3;
            snp.setEnabled(false);
            snp.setPriority(priority);
        }
        applySnappers = true;
        this.snapConfig.setApplySnappers(applySnappers);
        this.snapConfig.selectSnappers();
        this.pluginProperties.setDynValue("snapTolerance", (Object)4);
        this.snapConfig.setSnapTolerance(4);
    }

    public ImageIcon getIcon() {
        return IconThemeHelper.getImageIcon((String)"preferences-snapper");
    }

    public boolean isValueChanged() {
        return super.hasChanged();
    }

    public boolean isResizeable() {
        return true;
    }
}

