/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.report.lib.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.report.lib.api.ReportDataSet;
import org.gvsig.report.lib.impl.DefaultReportDataSet;
import org.gvsig.report.lib.impl.UnmodifiableBasicList64ToListAdapter;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.TaskStatusManager;
import org.gvsig.tools.util.UnmodifiableBasicList64;
import org.gvsig.tools.visitor.VisitCanceledException;
import org.gvsig.tools.visitor.Visitable;
import org.gvsig.tools.visitor.Visitor;

public class DefaultSelectionOfFeatures
implements ReportDataSet.SelectionOfFeatures {
    private List<FeatureReference> references;
    private List<String> referenceCodes;
    private final DefaultReportDataSet dataSet;

    public DefaultSelectionOfFeatures(DefaultReportDataSet dataSet) {
        this.dataSet = dataSet;
        this.references = new ArrayList<FeatureReference>();
        this.referenceCodes = null;
    }

    private void resolveReferenceCodes() {
        if (this.referenceCodes == null) {
            return;
        }
        for (String referenceCode : this.referenceCodes) {
            FeatureReference reference = this.dataSet.getStore().getFeatureReference(referenceCode);
            this.references.add(reference);
        }
        this.referenceCodes = null;
    }

    public Feature get64(long pos) {
        int limit;
        if (this.referenceCodes != null) {
            this.resolveReferenceCodes();
        }
        if ((limit = this.dataSet.getLimit()) > 0 && pos > (long)limit) {
            throw new ArrayIndexOutOfBoundsException((int)pos);
        }
        try {
            FeatureReference reference = this.references.get((int)pos);
            return reference.getFeature();
        }
        catch (DataException ex) {
            throw new RuntimeException("Can't retrieve feature from reference.", ex);
        }
    }

    public FeatureReference getReference(int pos) {
        if (this.referenceCodes != null) {
            this.resolveReferenceCodes();
        }
        FeatureReference reference = this.references.get(pos);
        return reference;
    }

    public long size64() {
        int limit = this.dataSet.getLimit();
        int size = this.referenceCodes == null ? this.references.size() : this.referenceCodes.size();
        if (limit > 0 && limit < size) {
            size = limit;
        }
        return size;
    }

    public boolean isEmpty() {
        if (this.referenceCodes == null) {
            return this.references.isEmpty();
        }
        return this.referenceCodes.isEmpty();
    }

    public Iterator<Feature> iterator() {
        if (this.referenceCodes != null) {
            this.resolveReferenceCodes();
        }
        return new FeatureReferenceIteratorToFeatureIteratorAdapter(this.references.iterator());
    }

    public void accept(Visitor visitor) throws BaseException {
        if (this.referenceCodes != null) {
            this.resolveReferenceCodes();
        }
        int count = 0;
        int limit = this.dataSet.getLimit();
        for (FeatureReference reference : this.references) {
            try {
                if (limit > 0) {
                    if (count >= limit) break;
                    ++count;
                }
                visitor.visit((Object)reference.getFeature());
            }
            catch (VisitCanceledException ex) {
                break;
            }
            catch (Exception exception) {
            }
        }
    }

    public void clear() {
        this.referenceCodes = null;
        this.references = new ArrayList<FeatureReference>();
    }

    public void add(Feature feature) {
        this.add(feature.getReference());
    }

    public void add(FeatureReference reference) {
        if (this.referenceCodes != null) {
            this.resolveReferenceCodes();
        }
        this.references.add(reference);
    }

    public void add(String referenceCode) {
        if (CollectionUtils.isEmpty(this.references)) {
            if (this.referenceCodes == null) {
                this.referenceCodes = new ArrayList<String>();
            }
            this.referenceCodes.add(referenceCode);
        } else {
            FeatureReference reference = this.dataSet.getStore().getFeatureReference(referenceCode);
            this.references.add(reference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Iterator<Feature> features) {
        TaskStatusManager manager = ToolsLocator.getTaskStatusManager();
        SimpleTaskStatus status = manager.createDefaultSimpleTaskStatus("DataSet");
        status.setIndeterminate();
        status.setAutoremove(true);
        status.add();
        int n = 0;
        try {
            if (this.referenceCodes != null) {
                this.resolveReferenceCodes();
            }
            while (features.hasNext()) {
                Feature f = features.next();
                this.references.add(f.getReference());
                status.setCurValue((long)n++);
            }
        }
        finally {
            status.terminate();
        }
    }

    public void addAll(Visitable features) {
        TaskStatusManager manager = ToolsLocator.getTaskStatusManager();
        final SimpleTaskStatus status = manager.createDefaultSimpleTaskStatus("DataSet");
        status.setIndeterminate();
        status.setAutoremove(true);
        status.add();
        final MutableInt n = new MutableInt(0);
        try {
            if (this.referenceCodes != null) {
                this.resolveReferenceCodes();
            }
            features.accept(new Visitor(){

                public void visit(Object obj) throws VisitCanceledException, BaseException {
                    Feature f = (Feature)obj;
                    DefaultSelectionOfFeatures.this.references.add(f.getReference());
                    status.setCurValue((long)n.intValue());
                    n.increment();
                }
            });
        }
        catch (BaseException ex) {
            throw new RuntimeException("Can't set features to dataset", ex);
        }
        finally {
            status.terminate();
        }
    }

    public void addStoreSelection() {
        try {
            FeatureSelection selection = this.dataSet.getStore().getFeatureSelection();
            this.addAll((Visitable)selection);
        }
        catch (DataException ex) {
            throw new RuntimeException("Can't set features from current selection.", ex);
        }
    }

    public List<Feature> toList() {
        UnmodifiableBasicList64ToListAdapter<Feature> adapter = new UnmodifiableBasicList64ToListAdapter<Feature>((UnmodifiableBasicList64<Feature>)this);
        return adapter;
    }

    private class FeatureReferenceIteratorToFeatureIteratorAdapter
    implements Iterator<Feature> {
        private final Iterator<FeatureReference> iterator;
        private int count;

        public FeatureReferenceIteratorToFeatureIteratorAdapter(Iterator<FeatureReference> iterator) {
            this.iterator = iterator;
            this.count = 0;
        }

        @Override
        public boolean hasNext() {
            int limit = DefaultSelectionOfFeatures.this.dataSet.getLimit();
            if (limit < this.count) {
                return false;
            }
            return this.iterator.hasNext();
        }

        @Override
        public Feature next() {
            int limit = DefaultSelectionOfFeatures.this.dataSet.getLimit();
            if (limit < this.count) {
                throw new NoSuchElementException();
            }
            ++this.count;
            FeatureReference fr = this.iterator.next();
            try {
                return fr.getFeature();
            }
            catch (DataException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

