/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.legend.urbanhorizontalsignage.swing.impl.convertlines;

import java.util.Properties;
import javax.swing.JComponent;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.dal.swing.featuretype.AttributeDescriptorPickerController;
import org.gvsig.fmap.dal.swing.storesrepository.StoresRepositoryController;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.legend.urbanhorizontalsignage.lib.api.linelegend.UrbanHorizontalSignageConfig;
import org.gvsig.legend.urbanhorizontalsignage.swing.api.ConvertLinesToPolygonsPanel;
import org.gvsig.legend.urbanhorizontalsignage.swing.impl.convertlines.DefaultConvertLinesToPolygonsPanelView;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.resourcesstorage.ResourcesStorage;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.task.TaskStatusController;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConvertLinesToPolygonsPanel
extends DefaultConvertLinesToPolygonsPanelView
implements ConvertLinesToPolygonsPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultConvertLinesToPolygonsPanel.class);
    private AttributeDescriptorPickerController targetColorFieldController;
    private AttributeDescriptorPickerController targetLengthFieldController;
    private AttributeDescriptorPickerController targetAreaFieldController;
    private FeatureSet source = null;
    private UrbanHorizontalSignageConfig config;
    private TaskStatusController statusController;
    private StoresRepositoryController storesRepositoryController;

    public DefaultConvertLinesToPolygonsPanel() {
        this.initComponents();
    }

    private void initComponents() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        DataSwingManager dataSwingManager = DALSwingLocator.getDataSwingManager();
        this.targetColorFieldController = dataSwingManager.createAttributeDescriptorPickerController(this.cboTargetColorFields, t -> t.getDataType().isNumeric() || t.getType() == 8);
        this.targetColorFieldController.setEditable(true);
        this.targetLengthFieldController = dataSwingManager.createAttributeDescriptorPickerController(this.cboTargetLengthFields, t -> t.getDataType().isNumeric());
        this.targetLengthFieldController.setEditable(true);
        this.targetAreaFieldController = dataSwingManager.createAttributeDescriptorPickerController(this.cboTargetAreaFields, t -> t.getDataType().isNumeric());
        this.targetAreaFieldController.setEditable(true);
        this.treeTargetStore.getSelectionModel().addTreeSelectionListener(e -> {
            this.doUpdateTargetFeatureType();
            this.updateEnableComponents();
        });
        this.storesRepositoryController = dataSwingManager.createStoresRepositoryController(this.treeTargetStore);
        this.statusController = ToolsSwingLocator.getTaskStatusSwingManager().createTaskStatusController(this.lblStatusCaption, this.lblStatusMsg, this.pbStatus);
        this.setTaskStatusVisible(false);
        this.translateAll();
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)13, (int)80, (int)20, (int)100);
        this.updateEnableComponents();
    }

    private void translateAll() {
        ToolsSwingManager toolsSwingmanager = ToolsSwingLocator.getToolsSwingManager();
        toolsSwingmanager.translate(this.lblTargetColorField);
        toolsSwingmanager.translate(this.lblTargetLengthField);
        toolsSwingmanager.translate(this.lblTargetAreaField);
        toolsSwingmanager.translate(this.lblElementsToProcess);
        toolsSwingmanager.translate(this.lblTargetLayer);
        toolsSwingmanager.translate(this.lblDeleteLinesAtFinish);
        toolsSwingmanager.translate(this.lblUseFeatureEditionValidationRules);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putFromResources(FeatureSet source) {
        ResourcesStorage.Resource resource;
        ResourcesStorage resourcesStorage;
        block4: {
            FeatureStore store = null;
            resourcesStorage = null;
            resource = null;
            try {
                store = source.getFeatureStore();
                resourcesStorage = store.getResourcesStorage();
                resource = resourcesStorage.getResource("urbsignage_lines2pol");
                if (resource == null || !resource.exists()) break block4;
                try {
                    Properties props = new Properties();
                    props.load(resource.asInputStream());
                    this.storesRepositoryController.setSelectedStore(props.getProperty("StoreName", null));
                    this.targetColorFieldController.set(props.getProperty("Color", null));
                    this.targetAreaFieldController.set(props.getProperty("Area", null));
                    this.targetLengthFieldController.set(props.getProperty("Len", null));
                    this.chkDeleteLinesAtFinish.setSelected(BooleanUtils.toBoolean((String)props.getProperty("DeleteAtFinish", "false")));
                }
                catch (Exception ex) {
                    LOGGER.warn("Don't load values from resources for store " + store.getFullName(), (Throwable)ex);
                }
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(resource);
                DisposeUtils.disposeQuietly((Disposable)resourcesStorage);
                throw throwable;
            }
        }
        DisposeUtils.disposeQuietly((Object)resource);
        DisposeUtils.disposeQuietly((Disposable)resourcesStorage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveValuesInResources(FeatureSet source) {
        ResourcesStorage.Resource resource;
        ResourcesStorage resourcesStorage;
        block5: {
            FeatureStore store = null;
            resourcesStorage = null;
            resource = null;
            try {
                store = source.getFeatureStore();
                resourcesStorage = store.getResourcesStorage();
                resource = resourcesStorage.getResource("urbsignage_lines2pol");
                if (resource == null) break block5;
                try {
                    String storeName = "";
                    store = this.storesRepositoryController.getSelectedFeatureStore();
                    if (store != null) {
                        storeName = store.getName();
                        DisposeUtils.dispose((Disposable)store);
                    }
                    Properties props = new Properties();
                    props.setProperty("Color", StringUtils.defaultIfBlank((String)this.targetColorFieldController.getName(), (String)""));
                    props.setProperty("Len", StringUtils.defaultIfBlank((String)this.targetLengthFieldController.getName(), (String)""));
                    props.setProperty("Area", StringUtils.defaultIfBlank((String)this.targetAreaFieldController.getName(), (String)""));
                    props.setProperty("DeleteAtFinish", BooleanUtils.toStringTrueFalse((boolean)this.chkDeleteLinesAtFinish.isSelected()));
                    props.setProperty("StoreName", storeName);
                    props.store(resource.asOutputStream(), "");
                    resource.close();
                }
                catch (Exception ex) {
                    LOGGER.warn("Don't save values to resources for store " + store.getFullName(), (Throwable)ex);
                }
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(resource);
                DisposeUtils.disposeQuietly((Disposable)resourcesStorage);
                throw throwable;
            }
        }
        DisposeUtils.disposeQuietly((Object)resource);
        DisposeUtils.disposeQuietly((Disposable)resourcesStorage);
    }

    public void setSource(FeatureSet source) {
        this.source = source;
        if (this.source == null || this.source.isEmpty()) {
            this.targetColorFieldController.clean();
            this.targetAreaFieldController.clean();
            this.targetLengthFieldController.clean();
            this.txtElementsToProcess.setText("");
        } else {
            this.putFromResources(source);
            this.txtElementsToProcess.setText(String.valueOf(this.source.size()));
        }
        this.updateEnableComponents();
    }

    public UrbanHorizontalSignageConfig fetch(UrbanHorizontalSignageConfig config) {
        config.setTargetColorFieldName(this.targetColorFieldController.getName());
        config.setTargetLenghtFieldName(this.targetLengthFieldController.getName());
        config.setTargetAreaFieldName(this.targetAreaFieldController.getName());
        this.saveValuesInResources(this.source);
        return config;
    }

    public void put(UrbanHorizontalSignageConfig config) {
        try {
            this.config = config.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException("Can't put config", ex);
        }
        if (config.getTargetColorFieldName() != null) {
            this.targetColorFieldController.set(config.getTargetColorFieldName());
        }
        if (config.getTargetLenghtFieldName() != null) {
            this.targetLengthFieldController.set(config.getTargetLenghtFieldName());
        }
        if (config.getTargetAreaFieldName() != null) {
            this.targetAreaFieldController.set(config.getTargetAreaFieldName());
        }
        this.updateEnableComponents();
    }

    public JComponent asJComponent() {
        return this;
    }

    private void doUpdateTargetFeatureType() {
        FeatureType ft = this.getTargetFeatureType();
        if (ft == null) {
            this.targetColorFieldController.clean();
            this.targetAreaFieldController.clean();
            this.targetLengthFieldController.clean();
            return;
        }
        this.targetColorFieldController.setFeatureType(ft);
        this.targetAreaFieldController.setFeatureType(ft);
        this.targetLengthFieldController.setFeatureType(ft);
    }

    private void updateEnableComponents() {
        if (this.source == null) {
            this.targetColorFieldController.setEnabled(false);
            this.targetAreaFieldController.setEnabled(false);
            this.targetLengthFieldController.setEnabled(false);
            this.treeTargetStore.setEnabled(false);
            return;
        }
        this.treeTargetStore.setEnabled(true);
        if (this.getTargetStore() == null) {
            this.targetColorFieldController.setEnabled(false);
            this.targetAreaFieldController.setEnabled(false);
            this.targetLengthFieldController.setEnabled(false);
            return;
        }
        this.targetColorFieldController.setEnabled(true);
        this.targetAreaFieldController.setEnabled(true);
        this.targetLengthFieldController.setEnabled(true);
    }

    public UrbanHorizontalSignageConfig getConfig() {
        return this.fetch(this.config);
    }

    public FeatureSet getSource() {
        return this.source;
    }

    public FeatureStore getTargetStore() {
        FeatureStore store = this.storesRepositoryController.getSelectedFeatureStore();
        if (store == null) {
            return null;
        }
        try {
            FeatureType ft = store.getDefaultFeatureTypeQuietly();
            FeatureAttributeDescriptor geomattr = ft.getDefaultGeometryAttribute();
            int geomtype = geomattr.getGeomType().getType();
            if (GeometryUtils.isSubtype((int)19, (int)geomtype) || GeometryUtils.isSubtype((int)22, (int)geomtype)) {
                return store;
            }
            return null;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't get target store", (Throwable)ex);
            return null;
        }
    }

    private FeatureType getTargetFeatureType() {
        FeatureStore store = this.getTargetStore();
        if (store == null) {
            return null;
        }
        return store.getDefaultFeatureTypeQuietly();
    }

    public SimpleTaskStatus getTaskStatus() {
        return this.statusController.getSimpleTaskStatus();
    }

    public void setTaskStatusVisible(boolean visible) {
        this.pbStatus.setVisible(visible);
        this.lblStatusCaption.setVisible(visible);
        this.lblStatusMsg.setVisible(visible);
    }

    public boolean getDeleteSourceAtFinish() {
        return this.chkDeleteLinesAtFinish.isSelected();
    }

    public void setDeleteSourceAtFinish(boolean deleteSourceAtFinish) {
        this.chkDeleteLinesAtFinish.setSelected(deleteSourceAtFinish);
    }

    public void setUseFeatureEditionValidationRules(boolean useFeatureEditionValidationRules) {
        this.chkUseFeatureEditionValidationRules.setSelected(useFeatureEditionValidationRules);
    }

    public boolean getUseFeatureEditionValidationRules() {
        return this.chkUseFeatureEditionValidationRules.isSelected();
    }
}

