/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.georeferencing.swing.impl.launcher;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.parameter.RasterDataParameters;
import org.gvsig.fmap.dal.coverage.util.ProviderServices;
import org.gvsig.fmap.dal.exception.CloseException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.gui.beans.swing.JFileChooser;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.georeferencing.swing.impl.launcher.ExtendedFileFilter;
import org.slf4j.LoggerFactory;

public class FileSelectionPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JTextField fileName = null;
    private JButton bSelection = null;
    private RasterDataStore store = null;

    public FileSelectionPanel() {
        this.init();
    }

    public void init() {
        BorderLayout fl = new BorderLayout();
        fl.setHgap(3);
        fl.setVgap(0);
        this.setLayout(fl);
        this.setBorder(BorderFactory.createTitledBorder(null, Messages.getText((String)"georef_file"), 0, 0, null, null));
        this.add((Component)this.getFileName(), "Center");
        this.add((Component)this.getSelectFileButton(), "East");
    }

    private JTextField getFileName() {
        if (this.fileName == null) {
            this.fileName = new JTextField();
            this.fileName.setEditable(false);
        }
        return this.fileName;
    }

    private JButton getSelectFileButton() {
        if (this.bSelection == null) {
            this.bSelection = new JButton(Messages.getText((String)"select"));
            this.bSelection.addActionListener(this);
        }
        return this.bSelection;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getSelectFileButton()) {
            this.loadRasterLayer();
        }
    }

    private RasterDataStore loadRasterLayer() {
        String path = null;
        JFileChooser chooser = new JFileChooser("OPEN_LAYER_FILE_CHOOSER_ID", JFileChooser.getLastPath((String)"OPEN_LAYER_FILE_CHOOSER_ID", null));
        chooser.setAcceptAllFileFilterUsed(false);
        String[] extensionsSupported = RasterLocator.getManager().getProviderServices().getReadOnlyFormatList();
        ExtendedFileFilter allFiles = new ExtendedFileFilter();
        for (int i = 0; i < extensionsSupported.length; ++i) {
            ExtendedFileFilter fileFilter = new ExtendedFileFilter();
            fileFilter.addExtension(extensionsSupported[i]);
            allFiles.addExtension(extensionsSupported[i]);
            chooser.addChoosableFileFilter((FileFilter)fileFilter);
        }
        allFiles.setDescription(Messages.getText((String)"todos_soportados"));
        chooser.addChoosableFileFilter((FileFilter)allFiles);
        chooser.setFileFilter((FileFilter)allFiles);
        int returnVal = chooser.showOpenDialog(null);
        if (returnVal == 0) {
            path = chooser.getSelectedFile().getAbsolutePath();
            this.getFileName().setText(path);
            if (this.store != null) {
                try {
                    this.store.close();
                }
                catch (CloseException fileFilter) {
                    // empty catch block
                }
            }
            ProviderServices provServ = RasterLocator.getManager().getProviderServices();
            RasterDataParameters storeParameters = provServ.createParameters(path);
            storeParameters.setURI(new File(path).toURI());
            DataManager dataManager = DALLocator.getDataManager();
            try {
                this.store = (RasterDataStore)dataManager.openStore(storeParameters.getDataStoreName(), (DataStoreParameters)storeParameters);
            }
            catch (ValidateDataParametersException e) {
                LoggerFactory.getLogger(FileSelectionPanel.class).debug(Messages.getText((String)"error_load_layer"), (Throwable)e);
            }
            catch (InitializeException e) {
                LoggerFactory.getLogger(FileSelectionPanel.class).debug(Messages.getText((String)"error_load_layer"), (Throwable)e);
            }
            catch (ProviderNotRegisteredException e) {
                LoggerFactory.getLogger(FileSelectionPanel.class).debug(Messages.getText((String)"error_load_layer"), (Throwable)e);
            }
            return this.store;
        }
        return null;
    }

    public RasterDataStore getSelectedStore() {
        return this.store;
    }
}

