/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.georeferencing.swing.impl.tool;

import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.raster.georeferencing.swing.impl.view.CanvasZone;
import org.gvsig.raster.georeferencing.swing.view.CanvasTool;
import org.gvsig.raster.georeferencing.swing.view.GeorefCanvas;
import org.gvsig.raster.georeferencing.swing.view.GeoreferencingView;
import org.gvsig.raster.georeferencing.swing.view.ToolEvent;
import org.gvsig.raster.georeferencing.swing.view.ToolListener;

public abstract class BaseViewTool
implements CanvasTool,
ToolListener {
    protected List<ToolListener> listeners = new ArrayList<ToolListener>();
    protected boolean active = false;
    protected CanvasZone canvas = null;
    private boolean sleepActive = false;
    private boolean sleep = false;
    private GeoreferencingView parentView = null;
    protected int type = -1;

    public BaseViewTool(GeorefCanvas canvas, ToolListener listener, GeoreferencingView parentView) {
        this.canvas = (CanvasZone)canvas;
        this.addToolListener(listener);
        this.parentView = parentView;
    }

    public int getToolType() {
        return this.type;
    }

    public GeoreferencingView getParentView() {
        return this.parentView;
    }

    public void addToolListener(ToolListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void onTool(ToolEvent ev) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).onTool(ev);
        }
    }

    public void offTool(ToolEvent ev) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).offTool(ev);
        }
    }

    public void endAction(ToolEvent ev) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).endAction(ev);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void sleep() {
        if (!this.sleep) {
            this.sleepActive = this.active;
            this.active = false;
            this.sleep = true;
        }
    }

    public void awake() {
        if (this.sleep) {
            this.active = this.sleepActive;
            this.sleep = false;
        }
    }

    public abstract void draw(Graphics var1);

    public abstract Object getResult();
}

