/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.georeferencing.swing.impl.view;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import org.gvsig.raster.georeferencing.swing.GeoreferencingSwingLibrary;
import org.gvsig.raster.georeferencing.swing.impl.tool.BaseViewTool;
import org.gvsig.raster.georeferencing.swing.impl.tool.PanTool;
import org.gvsig.raster.georeferencing.swing.impl.tool.SelectCoordOnViewTool;
import org.gvsig.raster.georeferencing.swing.impl.tool.ZoomRectangleTool;
import org.gvsig.raster.georeferencing.swing.impl.view.CanvasZone;
import org.gvsig.raster.georeferencing.swing.impl.view.ViewControl;
import org.gvsig.raster.georeferencing.swing.view.GeoreferencingView;
import org.gvsig.raster.georeferencing.swing.view.IGraphicLayer;
import org.gvsig.raster.georeferencing.swing.view.ToolListener;
import org.gvsig.raster.georeferencing.swing.view.ViewListener;

public abstract class BaseViewPanel
extends JPanel
implements GeoreferencingView {
    private static final long serialVersionUID = -8041978144045965049L;
    protected ViewControl viewControl = null;
    protected BaseViewTool tool = null;

    public JPanel getComponent() {
        return this;
    }

    public void setViewListener(ViewListener listener) {
    }

    public Graphics2D getCanvasGraphic() {
        return (Graphics2D)this.viewControl.getCanvas().getGraphics();
    }

    public int getCanvasWidth() {
        return this.viewControl.getCanvasWith();
    }

    public int getCanvasHeight() {
        return this.viewControl.getCanvasHeight();
    }

    public BufferedImage getBufferedImage() {
        return this.viewControl.getBufferedImage();
    }

    public void setCursorSize(int w, int h) {
    }

    public void setCursorPosition(int x, int y) {
    }

    public abstract void setDrawParams(BufferedImage var1, Rectangle2D var2, double var3, Point2D var5);

    public abstract void addGraphicLayer(IGraphicLayer var1);

    public abstract ViewControl getControl();

    public void disableAllTools() {
        this.getControl().disableAllTools();
    }

    public void disableTool(int tool) {
        this.getControl().disableTool(tool);
    }

    public CanvasZone getCanvas() {
        return this.viewControl.getCanvas();
    }

    public void enableTool(int tool) {
        this.getControl().enableTool(tool);
    }

    public void enableToolPressingButton(int tool) {
        this.getControl().enableToolPressingButton(tool);
    }

    public void setSelectZoomAreaButtonSelected(boolean select) {
        this.getControl().getBSelectZoomArea().setSelected(select);
    }

    public void setMoveButtonSelected(boolean select) {
        this.getControl().getBPan().setSelected(select);
    }

    public void setListenerToTool(int tool, ToolListener listener) {
        if (tool == GeoreferencingSwingLibrary.SELECT_POINT_TOOL) {
            this.tool = new SelectCoordOnViewTool(listener, this);
        }
        if (tool == GeoreferencingSwingLibrary.ZOOM_RECTANGLE_TOOL) {
            this.tool = new ZoomRectangleTool(listener, this);
        }
        if (tool == GeoreferencingSwingLibrary.PAN_TOOL) {
            this.tool = new PanTool(listener, this);
        }
    }

    public int getToolSelected() {
        if (this.getControl().getToolSelected() instanceof SelectCoordOnViewTool) {
            return GeoreferencingSwingLibrary.SELECT_POINT_TOOL;
        }
        if (this.getControl().getToolSelected() instanceof PanTool) {
            return GeoreferencingSwingLibrary.PAN_TOOL;
        }
        if (this.getControl().getToolSelected() instanceof ZoomRectangleTool) {
            return GeoreferencingSwingLibrary.ZOOM_RECTANGLE_TOOL;
        }
        return -1;
    }
}

