/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.fmap.rendering;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import org.cresques.cts.ICoordTrans;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.rendering.legend.events.SymbolLegendEvent;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.i18n.Messages;
import org.gvsig.symbology.fmap.mapcontext.rendering.legend.driver.impl.PersistenceBasedLegendWriter;
import org.gvsig.symbology.fmap.mapcontext.rendering.legend.impl.AbstractClassifiedVectorLegend;
import org.gvsig.symbology.fmap.mapcontext.rendering.legend.impl.DefaultFeatureDrawnNotification;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.evaluator.Evaluator;
import org.gvsig.tools.evaluator.EvaluatorData;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.task.Cancellable;
import org.gvsig.tools.util.Callable;
import org.gvsig.tools.util.impl.DefaultCaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorFilterExpressionLegend
extends AbstractClassifiedVectorLegend {
    private static final Logger logger = LoggerFactory.getLogger(VectorFilterExpressionLegend.class);
    public static final String FILTER_EXPRESSION_LEGEND_PERSISTENCE_DEFINITION_NAME = "FILTER_EXPRESSION_LEGEND_PERSISTENCE_DEFINITION_NAME";
    public static final String FILTER_EXPRESSION_LEGEND_NAME = "FILTER_EXPRESSION_LEGEND_NAME";
    public static final String I18N_DEFAULT = Messages.getText((String)"default_value");
    public static final String NON_I18N_DEFAULT = Messages.getText((String)"Default");
    private int shapeType;
    private ISymbol defaultSymbol;
    private boolean useDefaultSymbol = false;
    private long error_msg_count = 0L;
    private ArrayList<Item> newSymbols = new ArrayList<Item>(){
        private static final long serialVersionUID = 1L;

        public int indexOf(String expr) {
            return super.indexOf(new Item(expr, null));
        }
    };

    public VectorFilterExpressionLegend() {
        this.setClassifyingFieldNames(new String[0]);
        this.setClassifyingFieldTypes(new int[0]);
    }

    public ISymbol getSymbolByFeature(Feature featu) {
        EvaluatorData evda = featu.getEvaluatorData();
        ISymbol returnSymbol = null;
        Object result = null;
        String expr = null;
        try {
            for (int i = 0; i < this.newSymbols.size(); ++i) {
                Evaluator eval = this.newSymbols.get(i).getEvaluator();
                expr = eval.getSQL();
                if (expr.equalsIgnoreCase(I18N_DEFAULT) || !this.isConsideredTrue(result = eval.evaluate(evda)) || (returnSymbol = this.newSymbols.get(i).sym) == null) continue;
                return returnSymbol;
            }
        }
        catch (Exception e) {
            if (this.error_msg_count % 1000L == 0L) {
                String s;
                I18nManager i18n = ToolsLocator.getI18nManager();
                try {
                    s = featu.toJson().toString().replace("\n", " ");
                }
                catch (Throwable t) {
                    s = featu.toString();
                }
                logger.info("Error (msg every 1000 occurrences) while getting symbol in VectorFilterExpressionLegend Expression = [" + expr + "], Feature = [" + s + "]", (Throwable)e);
                this.error_msg_count = 0L;
                ApplicationLocator.getManager().message(i18n.getTranslation("_Error_in_expressions_legend") + ". " + i18n.getTranslation("_see_error_log_for_more_information"), 2);
            }
            ++this.error_msg_count;
            return this.getDefaultSymbol();
        }
        if (this.useDefaultSymbol) {
            return this.getDefaultSymbol();
        }
        return null;
    }

    private boolean isConsideredTrue(Object res) {
        if (res == null) {
            return false;
        }
        if (res instanceof Boolean) {
            return (Boolean)res;
        }
        if (res instanceof Number) {
            return ((Number)res).doubleValue() != 0.0;
        }
        if (res instanceof String) {
            return ((String)res).length() > 0;
        }
        return true;
    }

    public void addSymbol(Object key, ISymbol symbol) {
        this.newSymbols.add(new Item(key.toString(), symbol));
    }

    public void clear() {
        this.newSymbols.clear();
    }

    public void resetItems() {
        this.newSymbols = new ArrayList<Item>(){
            private static final long serialVersionUID = 1L;

            public int indexOf(String expr) {
                return super.indexOf(new Item(expr, null));
            }
        };
    }

    public void delSymbol(Object key) {
        ISymbol mySymbol = null;
        for (int i = 0; i < this.newSymbols.size(); ++i) {
            if (!this.newSymbols.get(i).evaluator.getSQL().equals(key)) continue;
            this.newSymbols.remove(i);
        }
        this.fireClassifiedSymbolChangeEvent(new SymbolLegendEvent(mySymbol, null));
    }

    public void replace(ISymbol oldSymbol, ISymbol newSymbol) {
        for (int i = 0; i < this.newSymbols.size(); ++i) {
            if (!this.newSymbols.get(i).sym.equals(oldSymbol)) continue;
            this.newSymbols.get(i).sym = newSymbol;
        }
        this.fireClassifiedSymbolChangeEvent(new SymbolLegendEvent(oldSymbol, newSymbol));
    }

    public String[] getDescriptions() {
        String[] descriptions = new String[this.newSymbols.size()];
        ISymbol[] auxSym = this.getSymbols();
        for (int i = 0; i < descriptions.length; ++i) {
            descriptions[i] = auxSym[i].getDescription();
        }
        return descriptions;
    }

    public ISymbol[] getSymbols() {
        if (this.newSymbols != null) {
            ISymbol[] mySymbols = new ISymbol[this.newSymbols.size()];
            for (int i = 0; i < this.newSymbols.size(); ++i) {
                mySymbols[i] = this.newSymbols.get(i).sym;
            }
            return mySymbols;
        }
        return null;
    }

    public ISymbol getDefaultSymbol() {
        if (this.defaultSymbol == null) {
            this.defaultSymbol = MapContextLocator.getSymbolManager().createSymbol(this.shapeType);
            this.fireDefaultSymbolChangedEvent(new SymbolLegendEvent(null, this.defaultSymbol));
        }
        return this.defaultSymbol;
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public int getShapeType() {
        return this.shapeType;
    }

    public boolean isUseDefaultSymbol() {
        return this.useDefaultSymbol;
    }

    public void setDefaultSymbol(ISymbol s) throws IllegalArgumentException {
        if (s == null) {
            throw new NullPointerException("Default symbol cannot be null");
        }
        ISymbol old = this.defaultSymbol;
        this.defaultSymbol = s;
        this.fireDefaultSymbolChangedEvent(new SymbolLegendEvent(old, this.defaultSymbol));
    }

    public void setShapeType(int shapeType) {
        if (this.shapeType != shapeType) {
            ISymbol sym = MapContextLocator.getSymbolManager().createSymbol(shapeType);
            this.setDefaultSymbol(sym);
            this.shapeType = shapeType;
        }
    }

    public void useDefaultSymbol(boolean b) {
        this.useDefaultSymbol = b;
    }

    public Object[] getValues() {
        if (this.newSymbols != null) {
            Object[] myObjects = new Object[this.newSymbols.size()];
            for (int i = 0; i < this.newSymbols.size(); ++i) {
                myObjects[i] = this.newSymbols.get(i).getStringExpression();
            }
            return myObjects;
        }
        return null;
    }

    public static boolean isPolygonal(int ty) {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        return geomManager.isSubtype(9, ty) || geomManager.isSubtype(3, ty);
    }

    public static boolean isLinear(int ty) {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        return geomManager.isSubtype(8, ty) || geomManager.isSubtype(2, ty);
    }

    public static boolean isPoint(int ty) {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        return geomManager.isSubtype(7, ty) || geomManager.isSubtype(1, ty);
    }

    public void removeDefaultSymbol() {
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set("useDefaultSymbol", this.isUseDefaultSymbol());
        state.set("defaultSymbol", (Persistent)this.getDefaultSymbol());
        state.set("shapeType", this.getShapeType());
        Object[] syms = this.getSymbols();
        if (syms == null) {
            syms = new ISymbol[]{};
        }
        Object[] vals = this.getValues();
        String[] vals_str = null;
        if (vals == null) {
            vals_str = new String[]{};
        } else {
            vals_str = new String[vals.length];
            for (int i = 0; i < vals.length; ++i) {
                String aux = vals[i] == null ? null : vals[i].toString();
                vals_str[i] = aux = this.translateDefault(aux, false);
            }
        }
        state.set("itemSymbolArray", syms);
        state.set("itemStringArray", vals_str);
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        this.setShapeType(state.getInt("shapeType"));
        Boolean b = state.getBoolean("useDefaultSymbol");
        this.useDefaultSymbol(b);
        ISymbol defsym = (ISymbol)state.get("defaultSymbol");
        this.setDefaultSymbol(defsym);
        String[] strs = state.getStringArray("itemStringArray");
        ISymbol[] syms = (ISymbol[])state.getArray("itemSymbolArray", ISymbol.class);
        if (strs.length != syms.length) {
            logger.info("VectorFilterExpressionLegend - load state - Different size in arrays: " + strs.length + ", " + syms.length);
        }
        int nmin = Math.min(strs.length, syms.length);
        for (int i = 0; i < nmin; ++i) {
            String aux = strs[i];
            aux = this.translateDefault(aux, true);
            this.addSymbol(aux, syms[i]);
        }
    }

    private String translateDefault(String aux, boolean forward) {
        if (aux == null) {
            return null;
        }
        if (forward && aux.compareTo(NON_I18N_DEFAULT) == 0) {
            return I18N_DEFAULT;
        }
        if (!forward && aux.compareTo(I18N_DEFAULT) == 0) {
            return NON_I18N_DEFAULT;
        }
        return aux;
    }

    public Object clone() throws CloneNotSupportedException {
        VectorFilterExpressionLegend resp = (VectorFilterExpressionLegend)((Object)super.clone());
        Object[] vals = this.getValues();
        ISymbol[] syms = this.getSymbols();
        if (vals != null && syms != null) {
            resp.resetItems();
            int n = Math.min(vals.length, syms.length);
            for (int i = 0; i < n; ++i) {
                resp.addSymbol(vals[i], (ISymbol)syms[i].clone());
            }
        }
        ISymbol sym = this.getDefaultSymbol();
        sym = (ISymbol)sym.clone();
        resp.setDefaultSymbol(sym);
        return resp;
    }

    public static void selfRegister() {
        DefaultCaller caller = new DefaultCaller();
        caller.add((Callable)new RegisterLegend());
        caller.add((Callable)new RegisterPersistence());
        if (!caller.call()) {
            throw new RuntimeException("Can't register VectorFilterExpressionLegend", (Throwable)caller.getException());
        }
        MapContextManager mcoman = MapContextLocator.getMapContextManager();
        mcoman.registerLegendWriter(VectorFilterExpressionLegend.class, ".gvsleg".substring(1), PersistenceBasedLegendWriter.class);
    }

    protected void drawFeatures(BufferedImage image, Graphics2D g, ViewPort viewPort, Cancellable cancel, ICoordTrans coordTrans, double dpi, DefaultFeatureDrawnNotification drawnNotification, FeatureSet featureSet, FeatureSelection selection) throws BaseException {
        this.error_msg_count = 0L;
        super.drawFeatures(image, g, viewPort, cancel, coordTrans, dpi, drawnNotification, featureSet, selection);
    }

    public static class RegisterLegend
    implements Callable {
        public Object call() throws Exception {
            MapContextManager manager = MapContextLocator.getMapContextManager();
            manager.registerLegend(VectorFilterExpressionLegend.FILTER_EXPRESSION_LEGEND_NAME, VectorFilterExpressionLegend.class);
            return Boolean.TRUE;
        }
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() throws Exception {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            if (manager.getDefinition(VectorFilterExpressionLegend.FILTER_EXPRESSION_LEGEND_PERSISTENCE_DEFINITION_NAME) == null) {
                DynStruct definition = manager.addDefinition(VectorFilterExpressionLegend.class, VectorFilterExpressionLegend.FILTER_EXPRESSION_LEGEND_PERSISTENCE_DEFINITION_NAME, "FILTER_EXPRESSION_LEGEND_PERSISTENCE_DEFINITION_NAME Persistence definition", null, null);
                definition.extend(manager.getDefinition("ClassifiedVectorLegend"));
                definition.addDynFieldBoolean("useDefaultSymbol").setMandatory(true);
                definition.addDynFieldObject("defaultSymbol").setClassOfValue(ISymbol.class).setMandatory(true);
                definition.addDynFieldInt("shapeType").setMandatory(true);
                definition.addDynFieldArray("itemSymbolArray").setClassOfItems(ISymbol.class);
                definition.addDynFieldArray("itemStringArray").setClassOfItems(String.class);
            }
            return Boolean.TRUE;
        }
    }

    private class Item
    implements Cloneable {
        private ISymbol sym;
        private Evaluator evaluator;

        public Item(String expression, ISymbol sym) {
            this.sym = sym;
            DataManager dataManager = DALLocator.getDataManager();
            try {
                this.evaluator = dataManager.createFilter(expression);
            }
            catch (InitializeException ex) {
                this.evaluator = null;
            }
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!obj.getClass().equals(Item.class)) {
                return false;
            }
            return this.evaluator.getSQL().equals(((Item)obj).evaluator.getSQL());
        }

        public String getStringExpression() {
            return this.evaluator.getSQL();
        }

        public Evaluator getEvaluator() {
            return this.evaluator;
        }

        public Object clone() {
            ISymbol clonesym = null;
            try {
                clonesym = (ISymbol)this.sym.clone();
            }
            catch (CloneNotSupportedException e) {
                logger.info("Error: unable to clone symbol.", (Throwable)e);
                clonesym = this.sym;
            }
            return new Item(this.getStringExpression(), clonesym);
        }
    }
}

