/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.principalcomponents.swing.impl.main;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.EventListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.algorithm.BasicAPISwingPanel;
import org.gvsig.raster.algorithm.RasterBaseAlgorithmLibrary;
import org.gvsig.raster.algorithm.process.DataProcess;
import org.gvsig.raster.algorithm.process.ProcessException;
import org.gvsig.raster.principalcomponents.algorithm.PCStatsDataStructure;
import org.gvsig.raster.principalcomponents.swing.PrincipalComponentsSwingLibrary;
import org.gvsig.raster.principalcomponents.swing.impl.main.BandTableModel;
import org.gvsig.raster.principalcomponents.swing.impl.main.CheckBoxColumnEditor;
import org.gvsig.raster.principalcomponents.swing.impl.main.CheckBoxColumnRenderer;
import org.gvsig.raster.swing.RasterSwingLocator;
import org.gvsig.raster.swing.RasterSwingManager;
import org.gvsig.raster.swing.pagedtable.ModelLoader;
import org.gvsig.raster.swing.pagedtable.PagedTable;
import org.gvsig.raster.swing.pagedtable.TableModel;

public class PCAComponentsListPanelImpl
extends JPanel
implements BasicAPISwingPanel {
    private static final long serialVersionUID = 1L;
    private Object inputStore = null;
    private PagedTable table = null;
    private JRadioButton byBandRadioButton = null;
    private JRadioButton varCovarRadioButton = null;
    private JRadioButton autovectorRadioButton = null;
    private JButton generateButton = null;
    private PCStatsDataStructure stats = null;
    private String fileName = null;
    private boolean[] bands = null;
    private String roisEPSG = null;

    public PCAComponentsListPanelImpl(Object inputStore, PCStatsDataStructure stats, String fileName, boolean[] bands, String roisEPSG) {
        this.inputStore = inputStore;
        this.stats = stats;
        this.fileName = fileName;
        this.bands = bands;
        this.roisEPSG = roisEPSG;
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        gridBagConstraints1.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        this.add((Component)this.getInputsPanel(), gridBagConstraints1);
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.weighty = 0.0;
        gridBagConstraints1.gridy = 1;
        this.add((Component)this.getPanelStatistics(), gridBagConstraints1);
    }

    public JPanel getPanelStatistics() {
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createTitledBorder(Messages.getText((String)"statistics")));
        p.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.insets = new Insets(0, 0, 2, 0);
        gridBagConstraints1.gridwidth = 2;
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        p.add((Component)this.getByBandRadioButton(), gridBagConstraints1);
        gridBagConstraints1.gridwidth = 1;
        gridBagConstraints1.gridy = 1;
        p.add((Component)this.getVarCovarRadioButton(), gridBagConstraints1);
        gridBagConstraints1.gridwidth = 2;
        gridBagConstraints1.gridy = 2;
        p.add((Component)this.getAutovectorRadioButton(), gridBagConstraints1);
        gridBagConstraints1.gridwidth = 1;
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 1;
        p.add((Component)this.getGenerateButton(), gridBagConstraints1);
        return p;
    }

    public JRadioButton getByBandRadioButton() {
        if (this.byBandRadioButton == null) {
            this.byBandRadioButton = new JRadioButton(Messages.getText((String)"by_band"));
            this.byBandRadioButton.setSelected(true);
        }
        return this.byBandRadioButton;
    }

    public JRadioButton getVarCovarRadioButton() {
        if (this.varCovarRadioButton == null) {
            this.varCovarRadioButton = new JRadioButton(Messages.getText((String)"var_covar"));
        }
        return this.varCovarRadioButton;
    }

    public JRadioButton getAutovectorRadioButton() {
        if (this.autovectorRadioButton == null) {
            this.autovectorRadioButton = new JRadioButton(Messages.getText((String)"autovector"));
        }
        return this.autovectorRadioButton;
    }

    public JButton getGenerateButton() {
        if (this.generateButton == null) {
            this.generateButton = new JButton(Messages.getText((String)"generate"));
        }
        return this.generateButton;
    }

    private JPanel getInputsPanel() {
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createTitledBorder(Messages.getText((String)"components_selection")));
        p.setLayout(new BorderLayout());
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        gridBagConstraints1.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        p.add((Component)this.getPagedTable().getComponent(), "Center");
        return p;
    }

    public JComponent getComponent() {
        return this;
    }

    public PagedTable getPagedTable() {
        if (this.table == null) {
            RasterSwingManager manager = RasterSwingLocator.getSwingManager();
            String[] columnNames = new String[]{"", "C", Messages.getText((String)"autovalor"), "%"};
            int[] columnSizes = new int[]{30, 35, -1, -1};
            BandTableModel model = new BandTableModel(columnNames);
            ModelLoader loader = manager.createModelLoader((TableModel)model);
            CheckBoxColumnRenderer render = new CheckBoxColumnRenderer(null);
            CheckBoxColumnEditor editor = new CheckBoxColumnEditor();
            loader.setRenderForColumn(0, (TableCellRenderer)render);
            loader.setCellEditorForColumn(0, (TableCellEditor)editor);
            loader.setColumnNames(columnNames);
            loader.setColumnWidths(columnSizes);
            this.table = manager.createPagedTable(loader);
            this.table.showControllerTable(false);
            this.table.showMoveRowsControls(false);
        }
        return this.table;
    }

    public Object getResult() throws ProcessException {
        DataProcess task = RasterBaseAlgorithmLibrary.getManager().createRasterTask("PrincipalComponentsProcess");
        List params = task.getRasterTaskInputParameters("PrincipalComponentsProcess");
        for (int i = 0; i < params.size(); ++i) {
            String paramName = (String)params.get(i);
            Class paramType = task.getParameterTypeByProcess("PrincipalComponentsProcess", paramName);
            if (paramType == RasterDataStore.class) {
                task.addParam(paramName, (Object)((RasterDataStore)this.inputStore));
            }
            if (paramName.equals("SELECTEDPCS") && paramType == Boolean[].class) {
                boolean[] components = new boolean[this.getPagedTable().getRowCount()];
                for (int j = 0; j < this.getPagedTable().getRowCount(); ++j) {
                    Object obj = this.getPagedTable().getValueAt(j, 0);
                    if (!(obj instanceof Boolean)) continue;
                    components[j] = (Boolean)obj;
                }
                task.addParam(paramName, (Object)components);
            }
            if (paramName.equals("BANDS") && paramType == Boolean[].class) {
                task.addParam(paramName, (Object)this.bands);
            }
            if (paramType == PCStatsDataStructure.class) {
                task.addParam(paramName, (Object)this.stats);
            }
            if (paramType == String.class) {
                task.addParam(paramName, (Object)this.fileName);
            }
            if (!paramName.equals("ROI_EPSG")) continue;
            task.addParam(paramName, (Object)this.roisEPSG);
        }
        return new Object[]{task, this.getByBandRadioButton().isSelected(), this.getVarCovarRadioButton().isSelected(), this.getAutovectorRadioButton().isSelected()};
    }

    public void initialize() {
        int i;
        double acumulado = 0.0;
        for (int i2 = 0; i2 < this.stats.getAutovalues().length; ++i2) {
            acumulado += this.stats.getAutovalues()[i2];
        }
        int[] autova = new int[this.stats.getAutovalues().length];
        int cont = this.stats.getAutovalues().length - 1;
        for (i = 0; i < this.stats.getAutovalues().length; ++i) {
            autova[i] = cont--;
        }
        for (i = this.stats.getAutovalues().length - 1; i >= 0; --i) {
            this.getPagedTable().addRow(new Object[]{true, autova[i], this.stats.getAutovalues()[i], this.stats.getAutovalues()[i] / acumulado});
        }
    }

    public int getComponentIDByObject(Object obj) {
        return obj == this.getGenerateButton() ? PrincipalComponentsSwingLibrary.GENERATE_STATIST : -1;
    }

    public void addListener(EventListener listener) {
        if (listener instanceof ActionListener) {
            this.getGenerateButton().addActionListener((ActionListener)listener);
        }
    }
}

