/*
 * Decompiled with CFR 0.152.
 */
package gishur.x;

import gishur.core.Comparitor;
import gishur.core.List;
import gishur.core.ListItem;
import gishur.core.SimpleList;
import gishur.core.Sweep;
import gishur.core.SweepEvent;
import gishur.core.SweepEventComparitor;
import gishur.core.TreeItem;
import gishur.core.algorithms.Tracer;
import gishur.x.Intersection;
import gishur.x.LineComparitor;
import gishur.x.PointComparitor;
import gishur.x.XPoint;
import gishur.x.XSegment;

public class SegmentIntersectionSweep
extends Sweep {
    public static final int LABEL_TYPE_EVENT_LEFT = 1;
    public static final int LABEL_TYPE_EVENT_INTER = 2;
    public static final int LABEL_TYPE_EVENT_RIGHT = 3;
    public static final int LABEL_TYPE_AFTER_LEFT = 4;
    public static final int LABEL_TYPE_AFTER_INTER = 5;
    public static final int LABEL_TYPE_AFTER_RIGHT = 6;
    public static final byte LEFT_ENDPOINT = 1;
    public static final byte INTERSECTION = 2;
    public static final byte RIGHT_ENDPOINT = 3;
    public static final byte POINTS = 0;
    public static final byte POINTS_AND_SEGMENTS = 1;
    public static final byte ALL_INTERSECTIONS = 0;
    public static final byte REAL_INTERSECTIONS = 1;
    public static final byte WITHOUT_TARGETS = 2;
    private byte _output_mode = 0;
    private byte _intersection_mode = 0;
    private List _points;
    private LineComparitor _linecomparitor;
    private XPoint _lastcut = null;
    private XSegment[] _lastsegs = null;
    private Tracer _tracer = null;

    private XSegment[] addXSegmentArrays(XSegment[] xSegmentArray, XSegment[] xSegmentArray2) {
        int n = xSegmentArray.length + xSegmentArray2.length;
        XSegment[] xSegmentArray3 = new XSegment[xSegmentArray2.length];
        int n2 = 0;
        while (n2 < xSegmentArray2.length) {
            xSegmentArray3[n2] = xSegmentArray2[n2];
            ++n2;
        }
        n2 = 0;
        while (n2 < xSegmentArray.length) {
            int n3 = 0;
            while (n3 < xSegmentArray2.length) {
                if (xSegmentArray[n2] == xSegmentArray2[n3]) {
                    --n;
                    xSegmentArray3[n3] = null;
                }
                ++n3;
            }
            ++n2;
        }
        XSegment[] xSegmentArray4 = new XSegment[n];
        n = 0;
        while (n < xSegmentArray.length) {
            xSegmentArray4[n] = xSegmentArray[n];
            ++n;
        }
        n2 = 0;
        while (n2 < xSegmentArray3.length) {
            if (xSegmentArray3[n2] != null) {
                xSegmentArray4[n++] = xSegmentArray3[n2];
            }
            ++n2;
        }
        return xSegmentArray4;
    }

    public void processEvent(SweepEvent sweepEvent) {
        XPoint xPoint = (XPoint)sweepEvent.key();
        XPoint xPoint2 = null;
        XPoint xPoint3 = null;
        this._linecomparitor.setX(xPoint.x);
        if (this._tracer != null) {
            int n = sweepEvent.getID();
            this._tracer.object("event_point").recordNoClone((Object)xPoint);
            this._tracer.object("sss").record((Object)this.sss());
            this._tracer.recordLabel("Reached event point", n == 1 ? 1 : (n == 3 ? 3 : 2), 0);
        }
        switch (sweepEvent.getID()) {
            case 1: {
                this._linecomparitor.setDelta((byte)1);
                TreeItem treeItem = this.sss().add(sweepEvent.value());
                xPoint2 = this.testIntersection(treeItem, true);
                xPoint3 = this.testIntersection(treeItem, false);
                if (this._tracer == null) break;
                this._tracer.object("insert_seg").recordNoClone(sweepEvent.value());
                this._tracer.object("cut_1").recordNoClone((Object)xPoint2);
                this._tracer.object("cut_2").recordNoClone((Object)xPoint3);
                this._tracer.recordLabel("After event point", 4, 1);
                return;
            }
            case 3: {
                this._linecomparitor.setDelta((byte)2);
                TreeItem treeItem = this.sss().find(sweepEvent.value());
                TreeItem treeItem2 = this.sss().prev(treeItem);
                if (((XSegment)sweepEvent.value()).vertical()) {
                    this._linecomparitor.resetY();
                }
                this.sss().remove(treeItem);
                xPoint2 = this.testIntersection(treeItem2, true);
                if (this._tracer == null) break;
                this._tracer.object("remove_seg").recordNoClone(sweepEvent.value());
                this._tracer.object("cut_1").recordNoClone((Object)xPoint2);
                this._tracer.object("cut_2").recordNoClone((Object)xPoint3);
                this._tracer.recordLabel("After event point", 6, 1);
                return;
            }
            case 2: {
                XSegment[] xSegmentArray = (XSegment[])sweepEvent.value();
                this._linecomparitor.setDelta((byte)1);
                if (xSegmentArray[0].vertical() || xSegmentArray[1].vertical()) {
                    this._linecomparitor.setY(xPoint.y);
                }
                TreeItem treeItem = this.sss().find((Object)xSegmentArray[0]);
                TreeItem treeItem3 = this.sss().find((Object)xSegmentArray[1]);
                if (treeItem == null || treeItem3 == null) break;
                this.sss().remove(treeItem3);
                this.sss().remove(treeItem);
                this._linecomparitor.setDelta((byte)2);
                treeItem = this.sss().add(treeItem);
                treeItem3 = this.sss().add(treeItem3);
                xPoint3 = this.testIntersection(treeItem, false);
                xPoint2 = this.testIntersection(treeItem3, true);
                XSegment[] xSegmentArray2 = (XSegment[])sweepEvent.value();
                switch (this._output_mode) {
                    case 0: {
                        if (this._lastcut != null && this._lastcut.equals(xPoint)) break;
                        this._points.add((Object)xPoint);
                        break;
                    }
                    case 1: {
                        if (this._lastcut == null || !this._lastcut.equals(xPoint)) {
                            this._lastsegs = xSegmentArray2;
                            this._points.add((Object)xPoint, (Object)xSegmentArray2);
                            break;
                        }
                        this._lastsegs = this.addXSegmentArrays(this._lastsegs, xSegmentArray2);
                        this._points.pop();
                        this._points.add((Object)xPoint, (Object)this._lastsegs);
                    }
                }
                this._lastcut = xPoint;
                if (this._tracer == null) break;
                this._tracer.object("points").record((Object)this._points);
                this._tracer.object("swap_seg1").recordNoClone((Object)xSegmentArray[0]);
                this._tracer.object("swap_seg2").recordNoClone((Object)xSegmentArray[1]);
                this._tracer.object("cut_1").recordNoClone((Object)xPoint2);
                this._tracer.object("cut_2").recordNoClone((Object)xPoint3);
                this._tracer.recordLabel("After event point", 5, 1);
                return;
            }
        }
    }

    public byte outputMode() {
        return this._output_mode;
    }

    public void setOutputMode(byte by) {
        this._output_mode = by;
    }

    public byte intersectionMode() {
        return this._intersection_mode;
    }

    public List segmentIntersection(SimpleList simpleList) {
        if (simpleList == null || simpleList.length() < 2) {
            return new List();
        }
        this.createEventStructure((Comparitor)new SweepEventComparitor((Comparitor)new PointComparitor(1)), true);
        this._linecomparitor = new LineComparitor();
        this.createSSS((Comparitor)this._linecomparitor);
        ListItem listItem = simpleList.first();
        while (listItem != null) {
            if (listItem.value() instanceof XSegment) {
                XSegment xSegment = (XSegment)listItem.key();
                this.insertEvent(1, xSegment.getStartPoint(), xSegment);
                this.insertEvent(3, xSegment.getEndPoint(), xSegment);
            }
            listItem = listItem.next();
        }
        this._points = new List();
        this._lastcut = null;
        super.execute();
        return this._points;
    }

    public List segmentIntersection(SimpleList simpleList, Tracer tracer) {
        this._tracer = tracer;
        List list = this.segmentIntersection(simpleList);
        this._tracer = null;
        return list;
    }

    private XPoint testIntersection(TreeItem treeItem, boolean bl) {
        XSegment xSegment;
        TreeItem treeItem2;
        TreeItem treeItem3;
        if (bl) {
            treeItem3 = this.sss().next(treeItem);
            treeItem2 = treeItem;
        } else {
            treeItem3 = treeItem;
            treeItem2 = this.sss().prev(treeItem);
        }
        if (treeItem3 == null || treeItem2 == null) {
            return null;
        }
        XSegment xSegment2 = (XSegment)treeItem3.key();
        Intersection intersection = xSegment2.intersection(xSegment = (XSegment)treeItem2.key());
        XPoint xPoint = intersection.xpoint();
        if (xPoint == null) {
            return null;
        }
        XSegment[] xSegmentArray = new XSegment[]{xSegment2, xSegment};
        switch (this._intersection_mode) {
            case 0: {
                this.insertEvent(2, xPoint, xSegmentArray);
                break;
            }
            case 1: {
                if (!(xPoint.equals(xSegment2.source()) || xPoint.equals(xSegment2.target()) || xPoint.equals(xSegment.source()) || xPoint.equals(xSegment.target()))) {
                    this.insertEvent(2, xPoint, xSegmentArray);
                    break;
                }
                xPoint = null;
                break;
            }
            case 2: {
                if (!xPoint.equals(xSegment2.target()) && !xPoint.equals(xSegment.target())) {
                    this.insertEvent(2, xPoint, xSegmentArray);
                    break;
                }
                xPoint = null;
            }
        }
        return xPoint;
    }

    public void setIntersectionMode(byte by) {
        this._intersection_mode = by;
    }
}

