/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.rectangle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.vectorediting.lib.api.DrawingStatus;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.exceptions.DrawServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;
import org.gvsig.vectorediting.lib.api.exceptions.StartServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.StopServiceException;
import org.gvsig.vectorediting.lib.spi.AbstractEditingProvider;
import org.gvsig.vectorediting.lib.spi.DefaultDrawingStatus;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameter;
import org.gvsig.vectorediting.lib.spi.EditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProviderLocator;
import org.gvsig.vectorediting.lib.spi.EditingProviderManager;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;

public class RectangleEditingProvider
extends AbstractEditingProvider
implements EditingProvider {
    protected EditingServiceParameter firstPoint;
    protected EditingServiceParameter oppositePoint;
    protected Map<EditingServiceParameter, Object> values;
    protected FeatureStore featureStore;

    public RectangleEditingProvider(ProviderServices providerServices, DynObject parameters) {
        super(providerServices);
        this.featureStore = (FeatureStore)parameters.getDynValue("featureStore");
        this.firstPoint = new DefaultEditingServiceParameter("first_point", "first_point", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
        this.oppositePoint = new DefaultEditingServiceParameter("second_point", "second_point", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
    }

    public EditingServiceParameter next() {
        if (this.values.get(this.firstPoint) == null) {
            return this.firstPoint;
        }
        if (this.values.get(this.oppositePoint) == null) {
            return this.oppositePoint;
        }
        return null;
    }

    public DrawingStatus getDrawingStatus(Point mousePosition) throws DrawServiceException {
        Point firstPointValue;
        DefaultDrawingStatus drawingStatus = new DefaultDrawingStatus();
        EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
        ISymbol lineSymbolEditing = editingProviderManager.getSymbol("line-symbol-editing");
        ISymbol auxiliaryPointSymbolEditing = editingProviderManager.getSymbol("auxiliary-point-symbol-editing");
        ISymbol previewSymbol = this.getPreviewSymbol();
        if (this.values != null && (firstPointValue = (Point)this.values.get(this.firstPoint)) != null) {
            drawingStatus.addStatus((Geometry)firstPointValue, auxiliaryPointSymbolEditing, "");
            drawingStatus.addStatus((Geometry)mousePosition, auxiliaryPointSymbolEditing, "");
            EditingProviderServices editingProviderServices = this.getProviderServices();
            GeometryManager geometryManager = GeometryLocator.getGeometryManager();
            try {
                int subtype = editingProviderServices.getSubType(this.featureStore);
                Line rectangle = geometryManager.createLine(subtype);
                rectangle.addVertex(firstPointValue);
                Point secondPoint = editingProviderServices.createPoint(mousePosition.getX(), firstPointValue.getY(), subtype);
                rectangle.addVertex(secondPoint);
                rectangle.addVertex(mousePosition);
                Point thirdPoint = editingProviderServices.createPoint(firstPointValue.getX(), mousePosition.getY(), subtype);
                rectangle.addVertex(thirdPoint);
                rectangle.addVertex(firstPointValue);
                drawingStatus.addStatus((Geometry)rectangle, lineSymbolEditing, "");
                drawingStatus.addStatus((Geometry)rectangle, previewSymbol, "");
            }
            catch (BaseException e) {
                throw new DrawServiceException((Throwable)e);
            }
        }
        return drawingStatus;
    }

    public void stop() throws StopServiceException {
        this.values.clear();
    }

    public List<EditingServiceParameter> getParameters() {
        ArrayList<EditingServiceParameter> parameters = new ArrayList<EditingServiceParameter>();
        parameters.add(this.firstPoint);
        parameters.add(this.oppositePoint);
        return parameters;
    }

    public void setValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        this.validateAndInsertValue(parameter, value);
    }

    public void setValue(Object value) throws InvalidEntryException {
        EditingServiceParameter param = this.next();
        this.validateAndInsertValue(param, value);
    }

    private void validateAndInsertValue(EditingServiceParameter param, Object value) throws InvalidEntryException {
        if (param == this.firstPoint) {
            if (value instanceof Point) {
                this.values.put(param, value);
                return;
            }
        } else if (param == this.oppositePoint && value instanceof Point) {
            this.values.put(param, value);
            return;
        }
        throw new InvalidEntryException(null);
    }

    public Geometry finish() throws FinishServiceException {
        if (this.values != null) {
            Point oppistePointValue = (Point)this.values.get(this.oppositePoint);
            EditingProviderServices editingProviderServices = this.getProviderServices();
            GeometryManager geometryManager = GeometryLocator.getGeometryManager();
            try {
                int subtype = editingProviderServices.getSubType(this.featureStore);
                Line rectangle = geometryManager.createLine(subtype);
                Point firstPointValue = (Point)this.values.get(this.firstPoint);
                rectangle.addVertex(firstPointValue);
                Point secondPoint = editingProviderServices.createPoint(oppistePointValue.getX(), firstPointValue.getY(), subtype);
                rectangle.addVertex(secondPoint);
                rectangle.addVertex(oppistePointValue);
                Point fourthPoint = editingProviderServices.createPoint(firstPointValue.getX(), oppistePointValue.getY(), subtype);
                rectangle.addVertex(fourthPoint);
                rectangle.addVertex(firstPointValue);
                return this.makeMultiPrimitiveIsNeeded(this.featureStore, (Primitive)rectangle);
            }
            catch (BaseException e) {
                throw new FinishServiceException("There are some problem finalize" + this.getName(), (Throwable)e);
            }
        }
        return null;
    }

    public void finishAndStore() throws FinishServiceException {
        Geometry geometry = this.finish();
        EditingProviderServices editingProviderServices = this.getProviderServices();
        editingProviderServices.insertGeometryIntoFeatureStore(geometry, this.featureStore);
    }

    public void start() throws StartServiceException {
        this.values = new HashMap<EditingServiceParameter, Object>();
    }

    public String getName() {
        return "insert-rectangle";
    }

    public Object getValue(EditingServiceParameter parameter) {
        return this.values != null ? this.values.get(parameter) : null;
    }
}

