/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.swing.impl.execution.wizard;

import java.awt.Component;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.gvsig.gui.beans.wizard.panel.OptionPanel;
import org.gvsig.installer.lib.api.execution.InstallPackageService;
import org.gvsig.installer.swing.impl.execution.InstallWizardPanel_ext;
import org.gvsig.installer.swing.impl.panel.DefaultProgressPanel;
import org.gvsig.tools.task.AbstractMonitorableTask;
import org.gvsig.tools.task.CancellableTask;
import org.gvsig.tools.task.SimpleTaskStatus;

public class InstallersWizardPage
extends DefaultProgressPanel
implements OptionPanel {
    private static final long serialVersionUID = 8531884535246881448L;
    private final InstallWizardPanel_ext wizardPanel;

    public InstallersWizardPage(InstallWizardPanel_ext installerExecutionWizard) {
        this.wizardPanel = installerExecutionWizard;
    }

    public JPanel getJPanel() {
        return this;
    }

    public String getPanelTitle() {
        return this.wizardPanel.getTranslation("_Install_required_addons");
    }

    public void lastPanel() {
        this.wizardPanel.setFinishButtonEnabled(false);
        this.wizardPanel.setCancelButtonEnabled(true);
    }

    public void nextPanel() {
    }

    public void updatePanel() {
        if (this.wizardPanel.getDirection() == 0) {
            this.wizardPanel.skip();
            return;
        }
        InstallPackageService bundle = this.wizardPanel.getInstallerExecutionService();
        if (!this.wizardPanel.getSelectDefaultPackages() || !bundle.needInstallPackageProviders()) {
            this.wizardPanel.skip();
            return;
        }
        this.wizardPanel.setFinishButtonEnabled(false);
        this.wizardPanel.setBackButtonEnabled(false);
        this.wizardPanel.setNextButtonEnabled(false);
        this.wizardPanel.setCancelButtonEnabled(true);
        UpdatePanel task = new UpdatePanel(this);
        this.wizardPanel.addCancellableTask((CancellableTask)task);
        this.bind(task.getTaskStatus());
        task.setDaemon(true);
        task.start();
    }

    private class UpdatePanel
    extends AbstractMonitorableTask {
        private final InstallersWizardPage panel;

        public UpdatePanel(InstallersWizardPage panel) {
            super(panel.wizardPanel.getTranslation("_Installing_prerequisites_three_dots"));
            this.panel = panel;
        }

        private void showWarning(String msg) {
            if (!SwingUtilities.isEventDispatchThread()) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                        }
                    });
                }
                catch (Exception ex) {
                    logger.warn("Can't show message to the user. " + msg);
                }
                return;
            }
            JOptionPane.showMessageDialog((Component)((Object)this.panel), msg, "Warning", 2);
        }

        public synchronized void run() {
            try {
                logger.info("Package installation initiated");
                SimpleTaskStatus taskStatus = (SimpleTaskStatus)this.getTaskStatus();
                InstallPackageService bundle = InstallersWizardPage.this.wizardPanel.getInstallerExecutionService();
                if (bundle.needInstallPackageProviders()) {
                    bundle.installPackageProviders(taskStatus);
                }
                taskStatus.message(this.panel.wizardPanel.getTranslation("_Finished"));
                taskStatus.terminate();
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        InstallersWizardPage.this.wizardPanel.setFinishButtonEnabled(false);
                        InstallersWizardPage.this.wizardPanel.setBackButtonEnabled(true);
                        InstallersWizardPage.this.wizardPanel.setNextButtonEnabled(true);
                        InstallersWizardPage.this.wizardPanel.setCancelButtonEnabled(true);
                        InstallersWizardPage.this.wizardPanel.doAction(1);
                    }
                });
                logger.info("Package installation finished");
            }
            catch (Throwable th) {
                logger.warn("Problems install packages.", th);
                this.showWarning(this.panel.wizardPanel.getTranslation("_Cant_install_package"));
            }
        }
    }
}

