/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.scripting.app.extension;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.PluginsManager;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.scripting.ScriptingLocator;
import org.gvsig.scripting.ScriptingManager;
import org.gvsig.scripting.ScriptingScript;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptLaunchExtension
extends Extension {
    private static final Logger logger = LoggerFactory.getLogger(ScriptLaunchExtension.class);

    public void initialize() {
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isVisible() {
        return true;
    }

    public boolean canQueryByAction() {
        return true;
    }

    public void execute(String action) {
        ApplicationManager application = ApplicationLocator.getManager();
        ScriptingScript script = this.getScript(action);
        if (script == null) {
            application.messageDialog("Can't locate script '" + action + "'", "Warning", 2);
            return;
        }
        try {
            script.runAsTask(null);
        }
        catch (Throwable th) {
            logger.warn("Can't execute '" + action + "' script.", th);
        }
    }

    public void execute(String action, Object[] args) {
        ApplicationManager application = ApplicationLocator.getManager();
        ScriptingScript script = this.getScript(action);
        if (script == null) {
            application.messageDialog("Can't locate script '" + action + "'", "Warning", 2);
            return;
        }
        try {
            script.runAsTask(args);
        }
        catch (Throwable th) {
            logger.warn("Can't execute '" + action + "' script.", th);
        }
    }

    public boolean isVisible(String action) {
        ScriptingScript script = this.getScript(action);
        try {
            Boolean value = (Boolean)script.invokeFunction("isVisible", null);
            return value;
        }
        catch (Throwable th) {
            logger.warn("Can't execute isVisible in '" + action + "' script.", th);
            return false;
        }
    }

    public boolean isEnabled(String action) {
        ScriptingScript script = this.getScript(action);
        try {
            Boolean value = (Boolean)script.invokeFunction("isEnabled", null);
            return value;
        }
        catch (Throwable th) {
            logger.warn("Can't execute isEnabled in '" + action + "' script.", th);
            return false;
        }
    }

    private ScriptingScript getScript(String scriptpathname) {
        ScriptingManager manager = ScriptingLocator.getManager();
        PluginsManager pluginManager = PluginsLocator.getManager();
        String s = manager.getRootUserFolder().getAbsolutePath().replace("\\", "/");
        File scriptfile = new File(s + "/" + scriptpathname);
        if (scriptfile.exists()) {
            ScriptingScript script = (ScriptingScript)manager.getScript(scriptfile);
            return script;
        }
        ArrayList<File> pluginsFolders = new ArrayList<File>();
        for (File f : pluginManager.getPluginsFolders()) {
            pluginsFolders.addAll(Arrays.asList(f.listFiles()));
        }
        for (File pluginFolder : pluginsFolders) {
            s = pluginFolder.getAbsolutePath().replace("\\", "/");
            scriptfile = new File(s + "/scripting/scripts/" + scriptpathname);
            if (!scriptfile.exists()) continue;
            ScriptingScript script = (ScriptingScript)manager.getScript(scriptfile);
            return script;
        }
        return (ScriptingScript)manager.getScript(scriptpathname);
    }
}

