/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.remoteclient.wfs;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.gvsig.compat.net.ICancellable;
import org.gvsig.remoteclient.ogc.OGCProtocolHandler;
import org.gvsig.remoteclient.ogc.OGCServiceInformation;
import org.gvsig.remoteclient.wfs.WFSRequestInformation;
import org.gvsig.remoteclient.wfs.WFSServiceInformation;
import org.gvsig.remoteclient.wfs.WFSStatus;
import org.gvsig.remoteclient.wfs.exceptions.WFSException;
import org.gvsig.remoteclient.wfs.request.WFSDescribeFeatureTypeRequest;
import org.gvsig.remoteclient.wfs.request.WFSGetFeatureRequest;
import org.gvsig.remoteclient.wfs.request.WFSTLockFeatureRequest;
import org.gvsig.remoteclient.wfs.request.WFSTransactionRequest;
import org.kxml2.io.KXmlParser;

public abstract class WFSProtocolHandler
extends OGCProtocolHandler {
    protected WFSServiceInformation serviceInfo = new WFSServiceInformation();
    protected Hashtable features = new Hashtable();
    protected String currentFeature = null;
    private int numberOfErrors = 0;
    protected ArrayList wfsRequestInformations = new ArrayList();

    private void clear() {
        this.features.clear();
        this.serviceInfo.clear();
    }

    public void getCapabilities(WFSStatus status, boolean override, ICancellable cancel) throws WFSException {
        URL request = null;
        try {
            File f;
            request = new URL(this.buildCapabilitiesRequest(status));
            if (override) {
                downloader.removeURL(request);
            }
            if ((f = downloader.downloadFile(request, "wfs_capabilities.xml", cancel)) == null) {
                return;
            }
            this.clear();
            this.parseCapabilities(f);
        }
        catch (Exception e) {
            throw new WFSException(e);
        }
    }

    private String buildCapabilitiesRequest(WFSStatus status) {
        StringBuffer req = new StringBuffer();
        String symbol = null;
        String onlineResource = status == null || status.getOnlineResource() == null ? this.getHost() : status.getOnlineResource();
        symbol = WFSProtocolHandler.getSymbol((String)onlineResource);
        req.append(onlineResource).append(symbol).append("REQUEST=GetCapabilities&SERVICE=WFS&");
        req.append("VERSION=").append(this.getVersion()).append("&EXCEPTIONS=XML");
        return req.toString();
    }

    public static String buildCapabilitiesSuitableVersionRequest(String _host, String _version) {
        int index = _host.indexOf(63);
        if (index > -1) {
            String host = _host.substring(0, index + 1);
            String query = _host.substring(index + 1, _host.length());
            StringTokenizer tokens = new StringTokenizer(query, "&");
            String newQuery = "";
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken().trim();
                if (token.toUpperCase().compareTo("REQUEST=GETCAPABILITIES") == 0 || token.toUpperCase().compareTo("SERVICE=WFS") == 0 || _version != null && _version.length() > 0 && token.toUpperCase().compareTo("VERSION=" + _version) == 0 || token.toUpperCase().compareTo("EXCEPTIONS=XML") == 0) continue;
                newQuery = newQuery + token + "&";
            }
            _host = host + newQuery;
        } else {
            _host = _host + "?";
        }
        _host = _version != null && _version.compareTo("") != 0 ? _host + "REQUEST=GetCapabilities&SERVICE=WFS&VERSION=" + _version + "&EXCEPTIONS=XML" : _host + "REQUEST=GetCapabilities&SERVICE=WFS&EXCEPTIONS=XML";
        return _host;
    }

    public File describeFeatureType(WFSStatus status, boolean override, ICancellable cancel) throws WFSException {
        String namespaceURI;
        this.currentFeature = status.getFeatureFullName();
        if (status.getNamespacePrefix() != null && status.getNamespaceLocation() == null && (namespaceURI = this.serviceInfo.getNamespace(status.getNamespacePrefix())) != null) {
            status.setNamespaceLocation(namespaceURI);
        }
        try {
            WFSDescribeFeatureTypeRequest request = this.createDescribeFeatureTypeRequest(status);
            request.setDeleted(override);
            File f = request.sendRequest(cancel);
            return f;
        }
        catch (Exception e) {
            throw new WFSException(e);
        }
    }

    public File getFeature(WFSStatus status, boolean override, ICancellable cancel) throws WFSException {
        try {
            WFSGetFeatureRequest request = this.createGetFeatureRequest(status);
            File f = request.sendRequest(cancel);
            this.parseGetFeature(f, status.getNamespacePrefix());
            return f;
        }
        catch (WFSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WFSException("Can't get feature", e);
        }
    }

    protected abstract boolean parseGetFeature(File var1, String var2) throws WFSException;

    public void transaction(WFSStatus status, boolean override, ICancellable cancel) throws WFSException {
        try {
            WFSTransactionRequest request = this.createTransactionRequest(status);
            File f = request.sendRequest(cancel);
            this.parseTransaction(f, status);
        }
        catch (Exception e) {
            throw new WFSException(e);
        }
    }

    private String buildTransactionRequest(WFSStatus status) {
        StringBuffer req = new StringBuffer();
        String symbol = null;
        String onlineResource = this.serviceInfo.getOnlineResource("Transaction") != null ? this.serviceInfo.getOnlineResource("Transaction") : this.getHost();
        symbol = WFSProtocolHandler.getSymbol((String)onlineResource);
        req.append(onlineResource);
        return req.toString();
    }

    protected abstract boolean parseTransaction(File var1, WFSStatus var2) throws WFSException;

    public void lockFeature(WFSStatus status, boolean override, ICancellable cancel) throws WFSException {
        try {
            WFSTLockFeatureRequest request = this.createLockFeatureRequest(status);
            File f = request.sendRequest(cancel);
            this.parseLockFeature(f, status.getNamespacePrefix(), status);
        }
        catch (WFSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WFSException(e);
        }
    }

    protected abstract boolean parseLockFeature(File var1, String var2, WFSStatus var3) throws WFSException;

    public Hashtable getFeatures() {
        return this.features;
    }

    public String getCurrentFeature() {
        return this.currentFeature;
    }

    public void setCurrentFeature(String currentFeature) {
        this.currentFeature = currentFeature;
    }

    protected void parseNamespaces(KXmlParser parser) {
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            int index;
            String attName = parser.getAttributeName(i);
            if (!attName.startsWith("xmlns") || (index = attName.indexOf(":")) <= 0) continue;
            this.serviceInfo.addNamespace(attName.substring(index + 1, attName.length()), parser.getAttributeValue(i));
        }
    }

    public OGCServiceInformation getServiceInformation() {
        return this.serviceInfo;
    }

    protected abstract WFSDescribeFeatureTypeRequest createDescribeFeatureTypeRequest(WFSStatus var1);

    protected abstract WFSGetFeatureRequest createGetFeatureRequest(WFSStatus var1);

    protected abstract WFSTLockFeatureRequest createLockFeatureRequest(WFSStatus var1);

    protected abstract WFSTransactionRequest createTransactionRequest(WFSStatus var1);

    ArrayList getWfsRequestInformations() {
        return this.wfsRequestInformations;
    }

    public void addLastWfsRequestInformation(WFSRequestInformation wfsRequestInformation) {
        this.wfsRequestInformations.add(wfsRequestInformation);
    }

    public WFSRequestInformation getLastWfsRequestInformation() {
        if (!this.wfsRequestInformations.isEmpty()) {
            return (WFSRequestInformation)this.wfsRequestInformations.get(this.wfsRequestInformations.size() - 1);
        }
        return null;
    }
}

