/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.remoteclient.wfs;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.gvsig.compat.CompatLocator;
import org.gvsig.compat.lang.StringUtils;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.GeneralPathX;
import org.gvsig.remoteclient.RemoteClientStatus;
import org.gvsig.remoteclient.wfs.edition.WFSTTransaction;
import org.gvsig.remoteclient.wfs.filters.filterencoding.FilterEncoding;
import org.gvsig.remoteclient.wfs.filters.operations.WFSEnvelopeFilterOperation;
import org.gvsig.remoteclient.wfs.filters.operations.WFSGeometryFilterOperation;
import org.gvsig.remoteclient.wfs.filters.operations.WFSSpatialFilterOperation;

public class WFSStatus
extends RemoteClientStatus {
    private static final StringUtils stringUtils = CompatLocator.getStringUtils();
    private int resultType = 0;
    public static final int RESULTYPE_RESULTS = 0;
    public static final int RESULTYPE_HITS = 1;
    static final String LOCKACTION_ALL = "ALL";
    static final String LOCKACTION_SOME = "SOME";
    private String featureName = null;
    private String namespacePrefix = null;
    private String namespaceLocation = null;
    private String[] fields = null;
    private String onlineResource = null;
    private Integer timeout = new Integer(10000);
    private Integer maxFeatures = new Integer(10000);
    private String filterByAttribute = null;
    private WFSSpatialFilterOperation filterByArea = null;
    private static GeometryManager geometryManager = GeometryLocator.getGeometryManager();
    private String userName = null;
    private String password = null;
    private ArrayList featuresToLock = new ArrayList();
    private ArrayList featuresToLockPropertieName = new ArrayList();
    private ArrayList featuresToLockPropertieValue = new ArrayList();
    private ArrayList featuresLocked = new ArrayList();
    private int expiry = -1;
    private String lockAction = null;
    private Rectangle2D lockedArea = null;
    private String lockedAreaProperty = null;
    private WFSTTransaction transaction = null;

    public WFSStatus(String featureName) {
        this(featureName, null);
    }

    public WFSStatus(String featureName, String namespace) {
        this.featureName = featureName;
        this.namespaceLocation = namespace;
        this.setFeatureName(featureName);
        this.lockAction = LOCKACTION_ALL;
        this.featuresLocked = new ArrayList();
        this.featuresLocked = new ArrayList();
        this.featuresToLockPropertieName = new ArrayList();
        this.featuresToLockPropertieValue = new ArrayList();
    }

    public Integer getMaxFeatures() {
        return this.maxFeatures;
    }

    public void setMaxFeatures(Integer buffer) {
        if (buffer != null) {
            this.maxFeatures = buffer;
        }
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public String getFeatureFullName() {
        if (this.namespacePrefix == null) {
            return this.featureName;
        }
        return this.namespacePrefix + ":" + this.featureName;
    }

    public void setFeatureName(String featureName) {
        if (featureName != null) {
            int index = featureName.indexOf(":");
            if (index > 0) {
                this.featureName = featureName.substring(index + 1, featureName.length());
                this.namespacePrefix = featureName.substring(0, index);
            } else {
                this.featureName = featureName;
            }
        }
    }

    public String[] getFields() {
        if (this.fields == null) {
            this.fields = new String[0];
        }
        return this.fields;
    }

    public void setFields(String[] fields) {
        this.fields = fields;
    }

    public void setFields(String fields) {
        if (fields == null) {
            return;
        }
        this.fields = stringUtils.split(fields, ",");
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        if (timeout != null) {
            this.timeout = timeout;
        }
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getOnlineResource() {
        return this.onlineResource;
    }

    public void setOnlineResource(String url) {
        this.onlineResource = url;
    }

    public String getFilterByAttribute() {
        return this.filterByAttribute;
    }

    public void setFilterByAttribute(String filterQuery) {
        this.filterByAttribute = filterQuery;
    }

    public void setFilterByArea(Geometry geometry, String attributeName, String srs, Integer operation) {
        if (geometry == null) {
            return;
        }
        if (attributeName == null) {
            attributeName = "the_geom";
        }
        if (operation == null) {
            operation = new Integer(27);
        }
        this.filterByArea = new WFSGeometryFilterOperation(geometry, operation, attributeName, this.getNamespacePrefix(), this.getNamespaceLocation(), srs);
    }

    public void removeFilterByArea() {
        this.filterByArea = null;
    }

    public void removeFilterByAttribute() {
        this.filterByAttribute = null;
    }

    public void removeAllFilters() {
        this.removeFilterByArea();
        this.removeFilterByAttribute();
    }

    public void setFilterByArea(Envelope envelope, String attributeName, String srs, Integer operation) {
        if (envelope == null) {
            return;
        }
        if (attributeName == null) {
            attributeName = "the_geom";
        }
        if (operation == null) {
            operation = new Integer(27);
        }
        this.filterByArea = new WFSEnvelopeFilterOperation(envelope, operation, attributeName, this.getNamespacePrefix(), this.getNamespaceLocation(), srs);
    }

    public WFSSpatialFilterOperation getFilterByArea() {
        return this.filterByArea;
    }

    public String getFilterQueryLocked() {
        FilterEncoding filter = new FilterEncoding(this);
        filter.setQualified(true);
        filter.setNamepacePrefix(null);
        filter.setHasBlankSpaces(false);
        return this.getFilterQueryLocked(filter);
    }

    public String getFilterQueryLockedPost() {
        FilterEncoding filter = new FilterEncoding(this);
        filter.setQualified(true);
        return this.getFilterQueryLocked(filter);
    }

    private String getFilterQueryLocked(FilterEncoding filter) {
        int i;
        if (this.featuresToLock.size() == 0 && this.getLockedArea() == null && this.featuresToLockPropertieName.size() == 0) {
            return null;
        }
        for (i = 0; i < this.featuresToLock.size(); ++i) {
            filter.addFeatureById(this.featuresToLock.get(i));
        }
        if (this.featuresToLockPropertieName.size() > 0) {
            for (i = 0; i < this.featuresToLockPropertieName.size(); ++i) {
                filter.addAndClause((String)this.featuresToLockPropertieName.get(i), (String)this.featuresToLockPropertieValue.get(i));
            }
        }
        if (this.lockedArea != null) {
            GeneralPathX generalPath = new GeneralPathX();
            generalPath.moveTo(this.lockedArea.getMinX(), this.lockedArea.getMinY());
            generalPath.lineTo(this.lockedArea.getMaxX(), this.lockedArea.getMinY());
            generalPath.lineTo(this.lockedArea.getMaxX(), this.lockedArea.getMaxY());
            generalPath.lineTo(this.lockedArea.getMinX(), this.lockedArea.getMaxY());
            generalPath.lineTo(this.lockedArea.getMinX(), this.lockedArea.getMinY());
            try {
                filter.clearSpatialFilters();
                filter.addSpatialFilter((Geometry)geometryManager.createSurface(generalPath, 0), this.lockedAreaProperty, this.getNamespacePrefix(), this.getNamespaceLocation(), this.getSrs(), 81);
            }
            catch (CreateGeometryException e) {
                return null;
            }
        }
        return filter.toString();
    }

    public int getExpiry() {
        return this.expiry;
    }

    public void setExpiry(int expiry) {
        this.expiry = expiry;
    }

    public String getLockAction() {
        return this.lockAction;
    }

    public void setLockActionToAll() {
        this.lockAction = LOCKACTION_ALL;
    }

    public void setLockActionToSome() {
        this.lockAction = LOCKACTION_SOME;
    }

    public WFSTTransaction createNewTransaction() {
        this.transaction = new WFSTTransaction(this);
        return this.transaction;
    }

    public WFSTTransaction getTransaction() {
        return this.transaction;
    }

    public int getFeaturesToLockSize() {
        return this.featuresToLock.size();
    }

    public String getFeatureToLockAt(int i) {
        if (i > this.featuresToLock.size()) {
            return null;
        }
        return (String)this.featuresToLock.get(i);
    }

    public void removeFeaturesToLock() {
        this.featuresToLock.clear();
        this.featuresLocked.clear();
        this.featuresToLockPropertieName.clear();
        this.featuresToLockPropertieValue.clear();
    }

    public void addFeatureToLock(String idFeature) {
        this.featuresToLock.add(idFeature);
    }

    public void addFeatureToLock(String propertyName, String propertyValue) {
        this.featuresToLockPropertieName.add(propertyName);
        this.featuresToLockPropertieValue.add(propertyValue);
    }

    public int getFeaturesLocked() {
        return this.featuresLocked.size();
    }

    public String getFeatureLockedAt(int i) {
        if (i > this.featuresLocked.size()) {
            return null;
        }
        return (String)this.featuresLocked.get(i);
    }

    public void addFeatureLocked(String lockId) {
        this.featuresLocked.add(lockId);
    }

    public Rectangle2D getLockedArea() {
        return this.lockedArea;
    }

    public void setLockedArea(Rectangle2D lockedArea, String lockedAreaProperty) {
        this.lockedArea = lockedArea;
        this.lockedAreaProperty = lockedAreaProperty;
    }

    public String getNamespacePrefix() {
        return this.namespacePrefix;
    }

    public String getNamespaceLocation() {
        return this.namespaceLocation;
    }

    public void setNamespacePrefix(String namespacePrefix) {
        this.namespacePrefix = namespacePrefix;
    }

    public void setNamespaceLocation(String namespaceLocation) {
        this.namespaceLocation = namespaceLocation;
    }

    public int getResultType() {
        return this.resultType;
    }

    public void setResultType(int resultType) {
        this.resultType = resultType;
    }
}

